/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.connector.PerimeterTarget;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.manipulator.GrabHandle;
import diva.canvas.selection.SelectionDragger;
import diva.canvas.selection.SelectionModel;
import diva.graph.AbstractGraphController;
import diva.graph.EdgeInteractor;
import diva.graph.GraphView;
import diva.graph.NodeInteractor;
import diva.graph.model.Edge;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;

public class BasicGraphController
extends AbstractGraphController {
    private SelectionDragger _selectionDragger;
    private NodeCreator _nodeCreator;
    private EdgeCreator _edgeCreator;
    private MouseFilter _controlFilter = new MouseFilter(16, 2);

    public BasicGraphController() {
        SelectionModel sm = this.getSelectionModel();
        NodeInteractor ni = new NodeInteractor(this, sm);
        EdgeInteractor ei = new EdgeInteractor(this, sm);
        this.setNodeInteractor(ni);
        this.setEdgeInteractor(ei);
        PerimeterTarget ct = new PerimeterTarget(){

            public boolean accept(Figure f) {
                return f.getUserObject() instanceof Node;
            }
        };
        this.setConnectorTarget(ct);
        ConnectorManipulator manipulator = new ConnectorManipulator();
        manipulator.setSnapHalo(4.0);
        manipulator.setConnectorTarget(ct);
        manipulator.addConnectorListener(new EdgeDropper());
        ei.setSelectionManipulator(manipulator);
        MouseFilter handleFilter = new MouseFilter(1, 0, 0);
        manipulator.setHandleFilter(handleFilter);
    }

    public void initializeInteraction() {
        GraphicsPane pane = this.getGraphView().getGraphicsPane();
        SelectionDragger _selectionDragger = new SelectionDragger(pane);
        _selectionDragger.addSelectionInteractor(this.getEdgeInteractor());
        _selectionDragger.addSelectionInteractor(this.getNodeInteractor());
        this._nodeCreator = new NodeCreator();
        this._nodeCreator.setMouseFilter(this._controlFilter);
        pane.getBackgroundEventLayer().addInteractor(this._nodeCreator);
        this._edgeCreator = new EdgeCreator();
        this._edgeCreator.setMouseFilter(this._controlFilter);
        this.getNodeInteractor().addInteractor(this._edgeCreator);
    }

    protected class EdgeCreator
    extends AbstractInteractor {
        protected EdgeCreator() {
        }

        public void mousePressed(LayerEvent e) {
            GraphView view = BasicGraphController.this.getGraphView();
            GraphModel model = BasicGraphController.this.getGraphModel();
            Figure source = e.getFigureSource();
            FigureLayer layer = (FigureLayer)e.getLayerSource();
            double x = e.getLayerX();
            double y = e.getLayerY();
            Edge edge = model.createEdge();
            Site tailSite = BasicGraphController.this.getConnectorTarget().getTailSite(source, x, y);
            AutonomousSite headSite = new AutonomousSite(layer, x, y);
            Connector ef = view.getEdgeRenderer().render(edge, tailSite, headSite);
            ef.setInteractor(BasicGraphController.this.getEdgeInteractor());
            view.addEdgeFigureToLayer(ef);
            view.addEdgeMapping(edge, ef);
            model.setEdgeTail(edge, (Node)source.getUserObject());
            BasicGraphController.this.getSelectionModel().addSelection(ef);
            ConnectorManipulator cm = (ConnectorManipulator)ef.getParent();
            GrabHandle gh = cm.getHeadHandle();
            layer.grabPointer(e, gh);
        }
    }

    protected class EdgeDropper
    implements ConnectorListener {
        protected EdgeDropper() {
        }

        public void connectorDragged(ConnectorEvent evt) {
        }

        public void connectorGrabbed(ConnectorEvent evt) {
        }

        public void connectorDropped(ConnectorEvent evt) {
            Connector c = evt.getConnector();
            Figure f = evt.getTarget();
            Edge e = (Edge)c.getUserObject();
            Node n = f == null ? null : (Node)f.getUserObject();
            GraphModel model = BasicGraphController.this.getGraphModel();
            switch (evt.getEnd()) {
                case 21: {
                    model.setEdgeHead(e, n);
                    break;
                }
                case 22: {
                    model.setEdgeTail(e, n);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot handle both ends of an edge being dragged.");
                }
            }
        }

        public void connectorSnapped(ConnectorEvent evt) {
        }

        public void connectorUnsnapped(ConnectorEvent evt) {
        }
    }

    protected class NodeCreator
    extends AbstractInteractor {
        protected NodeCreator() {
        }

        public void mousePressed(LayerEvent e) {
            GraphView view = BasicGraphController.this.getGraphView();
            GraphModel model = BasicGraphController.this.getGraphModel();
            Node n = model.createNode();
            Figure nf = view.getNodeRenderer().render(n);
            nf.setInteractor(BasicGraphController.this.getNodeInteractor());
            view.addNodeFigureToLayer(nf);
            view.placeNodeFigure(nf, e.getLayerX(), e.getLayerY());
            view.addNodeMapping(n, nf);
            model.addNode(n);
        }
    }
}

