/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.graph.NodeRenderer;
import diva.graph.model.Node;
import java.util.Hashtable;

public class TypedNodeRenderer
implements NodeRenderer {
    private NodeRenderer _defaultRenderer = null;
    private Hashtable _typedRenderers = null;

    public TypedNodeRenderer(NodeRenderer defaultRenderer) {
        this._defaultRenderer = defaultRenderer;
        this._typedRenderers = new Hashtable();
    }

    public void addTypedRenderer(Class c, NodeRenderer r) {
        this._typedRenderers.put(c, r);
    }

    public void removeTypedRenderer(Class c) {
        this._typedRenderers.remove(c);
    }

    public Figure render(Node n) {
        NodeRenderer r;
        Object o = n.getSemanticObject();
        if (o != null && (r = (NodeRenderer)this._typedRenderers.get(o.getClass())) != null) {
            return r.render(n);
        }
        return this._defaultRenderer.render(n);
    }
}

