/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.GlobalLayout;
import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphAdapter;
import diva.graph.model.GraphEvent;
import diva.graph.model.Node;

public class IncrLayoutAdapter
extends GraphAdapter
implements IncrementalLayout {
    private LayoutTarget _target;
    private GlobalLayout _layout;

    public IncrLayoutAdapter(GlobalLayout l, LayoutTarget target) {
        this._layout = l;
        this._target = target;
    }

    public void nodeAdded(GraphEvent evt) {
        Node n = (Node)evt.getTarget();
        this.layout(n.getParent());
    }

    public void nodeRemoved(GraphEvent evt) {
        Node n = (Node)evt.getTarget();
        Graph g = (Graph)evt.getOldValue();
        this.layout(g);
    }

    public void edgeHeadChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        this.layout(e.getHead().getParent());
    }

    public void edgeTailChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        this.layout(e.getTail().getParent());
    }

    public void structureChanged(GraphEvent evt) {
        this.layout((Graph)evt.getTarget());
    }

    private void layout(Graph g) {
        try {
            this._layout.layout(this._target, g);
        }
        catch (Exception e) {
            System.err.println("Layout Failed: " + e.getMessage());
        }
    }
}

