/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.BasicEdgeSet;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.Node;
import diva.util.BasicPropertyContainer;
import diva.util.IteratorAdapter;
import java.io.Serializable;
import java.util.Iterator;

public class BasicNode
extends BasicPropertyContainer
implements Node,
Serializable {
    private Object _semanticObject = null;
    private Graph _parent = null;
    private BasicEdgeSet _in = new BasicEdgeSet();
    private BasicEdgeSet _out = new BasicEdgeSet();
    private boolean _visited = false;

    public BasicNode() {
        this((Object)null);
    }

    public BasicNode(Object userObject) {
        this.setSemanticObject(userObject);
    }

    public BasicEdgeSet getInEdgeSet() {
        return this._in;
    }

    public BasicEdgeSet getOutEdgeSet() {
        return this._out;
    }

    public Graph getParent() {
        return this._parent;
    }

    public Object getSemanticObject() {
        return this._semanticObject;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public Iterator inEdges() {
        return this.getInEdgeSet().edges();
    }

    public Iterator inNodes() {
        return new IteratorAdapter(){
            Iterator edges;
            {
                this.edges = BasicNode.this.getInEdgeSet().edges();
            }

            public boolean hasNext() {
                return this.edges.hasNext();
            }

            public Object next() {
                return ((Edge)this.edges.next()).getTail();
            }
        };
    }

    public Iterator outEdges() {
        return this.getOutEdgeSet().edges();
    }

    public Iterator outNodes() {
        return new IteratorAdapter(){
            Iterator edges;
            {
                this.edges = BasicNode.this.getOutEdgeSet().edges();
            }

            public boolean hasNext() {
                return this.edges.hasNext();
            }

            public Object next() {
                return ((Edge)this.edges.next()).getHead();
            }
        };
    }

    public void setParent(Graph g) {
        this._parent = g;
    }

    public void setSemanticObject(Object o) {
        this._semanticObject = o;
    }

    public void setVisited(boolean val) {
        this._visited = val;
    }

    public String toString() {
        Object o = this.getSemanticObject();
        if (o != null) {
            return "BasicNode[" + o.toString() + "]";
        }
        return super.toString();
    }
}

