/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StatePerimeterSite
extends AbstractSite {
    private double _angle;
    private int _id;
    private Figure _parentFigure;

    public StatePerimeterSite(Figure figure, int id, double x, double y) {
        this._parentFigure = figure;
        this._id = id;
        Rectangle2D bounds = figure.getBounds();
        double radius = bounds.getHeight() / 2.0;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        this._angle = Math.atan2(centerY - y, centerX - x);
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._id;
    }

    public Point2D getPoint() {
        Rectangle2D bounds = this._parentFigure.getBounds();
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        double radius = bounds.getHeight() / 2.0;
        double x = centerX + radius * Math.cos(this._angle);
        double y = centerY + radius * Math.sin(this._angle);
        return new Point2D.Double(x, y);
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public void setNormal(double normal) {
        if (normal == this._angle) {
            return;
        }
        while (normal > Math.PI) {
            normal -= Math.PI * 2;
        }
        while (normal < -Math.PI) {
            normal += Math.PI * 2;
        }
        this._angle = normal;
    }

    public double getNormal() {
        return this._angle;
    }
}

