/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.SymbolChangeException;
import fsa.SymbolEvent;
import fsa.SymbolListener;
import fsa.SymbolUser;
import fsa.VetoableSymbolEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class SymbolSet
implements SymbolUser,
Serializable {
    TreeSet _delegate;
    transient HashSet _listeners;
    Object _owner;

    public SymbolSet(Object owner) {
        this._owner = owner;
        this._delegate = new TreeSet();
        this._listeners = new HashSet();
    }

    public SymbolSet(Object owner, char[] chars) {
        this(owner);
        for (int i = 0; i < chars.length; ++i) {
            this._delegate.add(new Character(chars[i]));
        }
    }

    public SymbolSet(Object owner, Iterator iterator) {
        this(owner);
        while (iterator.hasNext()) {
            this._delegate.add((Character)iterator.next());
        }
    }

    public boolean contains(Character c) {
        return this._delegate.contains(c);
    }

    public boolean contains(char c) {
        return this._delegate.contains(new Character(c));
    }

    public void addSymbol(Character symbol) throws SymbolChangeException {
        Character[] symbols = new Character[]{symbol};
        this.fireVetoableSymbolEvent(0, symbols);
        this._delegate.add(symbol);
        this.fireSymbolEvent(0, symbols);
    }

    public void addSymbol(char symbol) throws SymbolChangeException {
        this.addSymbol(new Character(symbol));
    }

    public void addSymbols(Character[] symbols) throws SymbolChangeException {
        this.fireVetoableSymbolEvent(0, symbols);
        for (int i = 0; i < symbols.length; ++i) {
            this._delegate.add(symbols[i]);
        }
        this.fireSymbolEvent(0, symbols);
    }

    public void addSymbols(SymbolSet symbols) throws SymbolChangeException {
        this.addSymbols(symbols.getSymbolArray());
    }

    public void removeSymbol(char symbol) throws SymbolChangeException {
        this.removeSymbol(new Character(symbol));
    }

    public void removeSymbol(Character symbol) throws SymbolChangeException {
        Character[] symbols = new Character[]{symbol};
        this.fireVetoableSymbolEvent(1, symbols);
        this._delegate.remove(symbol);
        this.fireSymbolEvent(1, symbols);
    }

    public void removeSymbols(Character[] symbols) throws SymbolChangeException {
        this.fireVetoableSymbolEvent(1, symbols);
        for (int i = 0; i < symbols.length; ++i) {
            this._delegate.remove(symbols[i]);
        }
        this.fireSymbolEvent(1, symbols);
    }

    public void clear() throws SymbolChangeException {
        int i = 0;
        Character[] symbols = new Character[this._delegate.size()];
        Iterator iterator = this._delegate.iterator();
        while (iterator.hasNext()) {
            symbols[i] = (Character)iterator.next();
            ++i;
        }
        this.fireVetoableSymbolEvent(1, symbols);
        this._delegate.clear();
        this.fireSymbolEvent(1, symbols);
    }

    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    public String getSymbolString() {
        Iterator i = this._delegate.iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            sb.append((Character)i.next());
        }
        return sb.toString();
    }

    public String getFormattedSymbolString() {
        boolean startNewRange = false;
        boolean rangeStarted = false;
        boolean rangeEnded = false;
        char rangeEnd = '\u0000';
        char rangeStart = '\u0000';
        Iterator i = this._delegate.iterator();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            char curChar = ((Character)i.next()).charValue();
            if (rangeStarted) {
                if (Character.isLetterOrDigit(curChar)) {
                    if (rangeEnd + 1 == curChar) {
                        rangeEnd = curChar;
                    } else {
                        rangeEnded = true;
                        startNewRange = true;
                    }
                } else {
                    rangeEnded = true;
                }
            } else if (Character.isLetterOrDigit(curChar)) {
                startNewRange = true;
            }
            if (rangeStarted && (rangeEnded || !i.hasNext())) {
                int rangeSize = rangeEnd - rangeStart + 1;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(rangeStart);
                if (rangeSize == 2) {
                    sb.append(", " + rangeEnd);
                } else if (rangeSize > 2) {
                    sb.append("-" + rangeEnd);
                }
                rangeStarted = false;
                rangeEnded = false;
            }
            if (startNewRange) {
                if (i.hasNext()) {
                    rangeStarted = true;
                    rangeEnded = false;
                    char c = curChar;
                    rangeEnd = c;
                    rangeStart = c;
                    startNewRange = false;
                } else {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(curChar);
                }
            }
            if (Character.isLetterOrDigit(curChar)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(curChar);
        }
        return sb.toString();
    }

    public Character[] getSymbolArray() {
        Character[] symbolArray = new Character[this._delegate.size()];
        Iterator iterator = this._delegate.iterator();
        int position = 0;
        while (iterator.hasNext()) {
            symbolArray[position++] = (Character)iterator.next();
        }
        return symbolArray;
    }

    public Iterator getSymbols() {
        return Arrays.asList(this._delegate.toArray()).iterator();
    }

    public synchronized void addSymbolListener(SymbolListener l) {
        this._listeners.add(l);
    }

    public synchronized void removeSymbolListener(SymbolListener l) {
        this._listeners.remove(l);
    }

    public Object getOwner() {
        return this._owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVetoableSymbolEvent(int type, Character[] symbols) throws SymbolChangeException {
        Object[] listenerArray;
        VetoableSymbolEvent e = null;
        SymbolSet symbolSet = this;
        synchronized (symbolSet) {
            listenerArray = this._listeners.toArray();
        }
        e = new VetoableSymbolEvent(this, type, symbols);
        Iterator<Object> iterator = Arrays.asList(listenerArray).iterator();
        while (iterator.hasNext()) {
            SymbolListener sl = (SymbolListener)iterator.next();
            switch (type) {
                case 0: {
                    sl.aboutToAddSymbols(e);
                    break;
                }
                case 1: {
                    sl.aboutToRemoveSymbols(e);
                }
            }
            if (!e.isVetoed()) continue;
            throw new SymbolChangeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSymbolEvent(int type, Character[] symbols) {
        Object[] listenerArray;
        SymbolEvent e = null;
        SymbolSet symbolSet = this;
        synchronized (symbolSet) {
            listenerArray = this._listeners.toArray();
        }
        e = new SymbolEvent(this, type, symbols);
        Iterator<Object> iterator = Arrays.asList(listenerArray).iterator();
        while (iterator.hasNext()) {
            SymbolListener sl = (SymbolListener)iterator.next();
            switch (type) {
                case 0: {
                    sl.symbolsAdded(e);
                    break;
                }
                case 1: {
                    sl.symbolsRemoved(e);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._listeners = new HashSet();
    }
}

