
/**
 * Write a description of class ExerciseFrame here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import com.sun.xml.tree.*;
import com.sun.xml.parser.*;
import org.xml.sax.InputSource;
import org.w3c.dom.*; 
import java.io.*;

public class ExerciseFrame extends JFrame implements ActionListener
{
    private JButton create;
    private JButton edit;
    private JLabel label1;
    private Grammar grammar;

    ExerciseFrame()
    {
        setTitle("Exercise Creator");
       
        addWindowListener(new WindowAdapter()
        {  public void windowClosing(WindowEvent e)
           {
              System.exit(0);
           }
        });
        
        setSize(500, 100);
        
        label1 = new JLabel("Please choose from the following options: ");
        
        create = new JButton("Create New Grammar Exercise");
        create.addActionListener(this);
        create.setActionCommand("create");
        create.setToolTipText("new exercise");
        
        edit = new JButton("Edit Existing Grammar Exercise");
        edit.addActionListener(this);
        edit.setActionCommand("edit");
        edit.setToolTipText("edit exercise");
        
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        labelPanel.add(label1);
                
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        buttonPanel.add(create);
        buttonPanel.add(edit);
        
        getContentPane().add(labelPanel, "North");
        getContentPane().add(buttonPanel, "South");
    }

	public void actionPerformed(ActionEvent evt)
    {
        int returnValue = -99;
        int returnValue2 = -99;
        JFileChooser chooser = new JFileChooser("C:/Pascoe/Research03/TestFiles/");
        JFileChooser chooserOpen = new JFileChooser("C:/Pascoe/Research03/TestFiles/");
        GrammarDialog G = new GrammarDialog(this);
        String eventName = evt.getActionCommand();
        
        if (eventName.equals("create"))
        {    
            grammar = G.showDialog();
               
            if (grammar != null)
            {
                returnValue = chooser.showSaveDialog(this);
            }
            
            if (returnValue == -99)
            {
                JOptionPane.showMessageDialog(getContentPane(), "Grammar Not Saved");
            }
            else if (returnValue == JFileChooser.APPROVE_OPTION)
            {
                try
                {
                    grammar.writeToXML(chooser.getSelectedFile().getPath());
                    JOptionPane.showMessageDialog(getContentPane(), "Grammar Saved");
                }
                catch(Exception e)
                {
                }
            }
            else if (returnValue == JFileChooser.CANCEL_OPTION)
            {
                
            }
            else
            {
                JOptionPane.showMessageDialog(getContentPane(), "Grammar Not Saved Correctly");
            }
        }
        
        if (eventName.equals("edit"))
        {
            returnValue2 = chooserOpen.showOpenDialog(this);
            if (returnValue2 == JFileChooser.APPROVE_OPTION)
            {
                Grammar tempGrammar = extract_grammar(chooserOpen.getSelectedFile().getPath());
                grammar = G.showDialog(tempGrammar);
                
                if (grammar != null)
                {
                    returnValue = chooser.showSaveDialog(this);
                }
            
                if (returnValue == -99)
                {
                    JOptionPane.showMessageDialog(null, "Grammar Not Saved");
                }
                else if (returnValue == JFileChooser.APPROVE_OPTION)
                {
                    try
                    {
                        grammar.writeToXML(chooser.getSelectedFile().getPath());
                        JOptionPane.showMessageDialog(getContentPane(), "Grammar Saved");
                    }
                    catch(Exception e)
                    {
                    }
                }
                else if (returnValue == JFileChooser.CANCEL_OPTION)
                {
                    
                }
                else
                {
                    JOptionPane.showMessageDialog(getContentPane(), "Grammar Not Saved Correctly");
                }
            }
            else if (returnValue2 == JFileChooser.CANCEL_OPTION)
            {
                
            }
            else
            {
                JOptionPane.showMessageDialog(getContentPane(), "Grammar Not Loaded Correctly");
            }
        }
    }
    
    //=========================================================
   //  extract_grammar()
   //  args:  none
   //  ret:   returns Grammar object
   //  description:  this method extracts info from xml grammar file
   //			and saves in a Grammar object
   //=========================================================
    public Grammar extract_grammar(String fileName)
    {
       //URL u2= null;
       File inFile = new File(fileName);
       FileInputStream f;
       InputStream inStream;
       Document document;
       Grammar thisGrammar = new Grammar();
       Symbol aSymbol = new Symbol();             
            
       try {
          //u2= new URL(getCodeBase(), grammarFile );
          f = new FileInputStream(inFile);
       
          //inStream = f.openStream();
          document = XmlDocument.createXmlDocument( f, true );
          
          NodeList title = document.getElementsByTagName( "TITLE" );          
          Node titleElement = title.item(0);
          NodeList titleValues = titleElement.getChildNodes();
          Node titleValue = titleValues.item(0);
          thisGrammar.setTitle( titleValue.getNodeValue() );
         
          NodeList start = document.getElementsByTagName( "START" );
          Node startElement = start.item(0);
          NodeList startValues = startElement.getChildNodes();
          Node startValue = startValues.item(0);
          thisGrammar.setStart( startValue.getNodeValue() );
          
          NodeList lambda = document.getElementsByTagName( "LAMBDA" );
          if (lambda.getLength() != 0) {
             Node lambdaElement = lambda.item(0);
             NodeList lambdaValues = lambdaElement.getChildNodes();
             Node lambdaValue = lambdaValues.item(0);
             thisGrammar.setLambda( lambdaValue.getNodeValue() );
          }
          else
             thisGrammar.setLambda( null );
         
          NodeList rules = document.getElementsByTagName( "PRODUCTION" );            
              
          if (rules.getLength() == 0)
          {
              System.out.println("No rules in this grammar");
              System.exit(0);
          }
               
          thisGrammar.setNumRules(rules.getLength());
       
          for (int i=0; i < rules.getLength(); i++)
          {
             Element productionNode = (Element) rules.item(i);
             NodeList leftside = productionNode.getElementsByTagName( "LEFTSIDE" );
             Node leftsideElement = leftside.item(0);
             NodeList leftsideValues = leftsideElement.getChildNodes();
             Node leftsideValue = leftsideValues.item(0);
             String tempLeftside = leftsideValue.getNodeValue();
                
             NodeList rightside = productionNode.getElementsByTagName( "RIGHTSIDE" );
             Element rightsideNode = (Element) rightside.item(0);
             NodeList components = rightsideNode.getElementsByTagName( "SYMBOL" );
                           
             Symbol[] tempRSymbolArray = new Symbol[components.getLength()];
               
             for (int k=0; k < components.getLength(); k++)
             {
                Node componentElement = components.item(k);
                NodeList componentValues = componentElement.getChildNodes();
                Node componentValue = componentValues.item(0);
                                    
                NamedNodeMap componentAttrib = componentElement.getAttributes();
                Node termNode = componentAttrib.getNamedItem("Term");
                boolean isTerm = false;
                if (termNode.getNodeValue().equalsIgnoreCase( "terminal"))
                   isTerm = true;
                tempRSymbolArray[k] = new Symbol(componentValue.getNodeValue(), isTerm);
             }
             thisGrammar.setRule(i, tempLeftside, tempRSymbolArray);
          }
          //grammarErrorCond = false;            
       }  
       catch(Exception e)
       {
          System.out.println("Unexpected error creating document:  " + e);
          /*grammarFileError = "There was an unexpected error accessing the "
             + "grammar file " + grammarFile + ".  Try selecting a different "
             + "grammar from the menu using the \"Access Grammar Tools Menu\" "
             + "button below. (Click on the Instructions tab below for help.)";
             */
          //instruct.setForeground(Color.red);
          //instruct.setText(grammarFileError);
          //grammarErrorCond = true;          
       }       
       return thisGrammar;
   }
}
