//import FSAComponents.*;
import java.util.HashMap;
import java.io.*;

class Grammar
{ 
   private String start = new String();
   private String lambda = new String();
   private String title = new String();
   private int num_rules;
   private Rule[] ruleArray;
    
   public Grammar()
   {
      num_rules = 0;
   }
       
   public Grammar(int numRules)
   {
      num_rules = numRules;
      ruleArray = new Rule[num_rules];
      for (int i=0; i < num_rules; i++)
      {
         ruleArray[i] = new Rule();
      }
   }
   
   /*
   public StateMachine convertToFSA()
   {
      StateMachine T = new StateMachine();
      HashMap statesMap, tranMap;
      State newState, beginState, endState, finalState;
      SymbolSet fsaAlphabet, tranAlphabet;
      Transition tran1;
      
      if(!isGrammarRegular())
      {
         return null;
      }
      
      statesMap = new HashMap();
      tranMap = new HashMap();
      fsaAlphabet = T.getAlphabet();
      
      newState = new State();
      T.addState(newState);
      statesMap.put(ruleArray[0].getLeftside(), newState);
      T.setStartState(newState);
      
      finalState = new State();
      finalState.setFinalState(true);
      T.addState(finalState);
      
      
      for (int i = 0; i < num_rules; i++)
      {
         if (statesMap.get(ruleArray[i].getLeftside()) == null)
         {
            newState = new State();
            T.addState(newState);
            statesMap.put(ruleArray[i].getLeftside(), newState);
         }    
      }
      
      for (int i = 0; i < num_rules; i++)
      {
         String temp;
         char ch;
         
         if (ruleArray[i].getNumRSymbols() == 1)
         {
            beginState = (State)statesMap.get(ruleArray[i].getLeftside());
            if (tranMap.get(ruleArray[i].getLeftside()) == null)
            {
               tran1 = new Transition(beginState, finalState);
               tranMap.put(ruleArray[i].getLeftside(), tran1);
            }
            else
            {
                tran1 = (Transition)tranMap.get(ruleArray[i].getLeftside());
            }
            
            tranAlphabet = tran1.getSymbolSet();
            temp = ruleArray[i].getRightSym(0).getNameSymbol();
            
            if (temp.equals("lambda"))
            {
               ch = StateMachine.EMPTY_SYMBOL.charValue();
            }
            else
            {
               ch = temp.charAt(0);
            }
            
            try
            {
               fsaAlphabet.addSymbol(ch);
               tranAlphabet.addSymbol(ch);
            }
            catch (SymbolChangeException e)
            {
                System.exit(1);   
            }
            catch (Exception e)
            {
            }
            T.addTransition(tran1);
         }
         else if (ruleArray[i].getNumRSymbols() == 2)
         {
            beginState = (State)statesMap.get(ruleArray[i].getLeftside());
            endState = (State)statesMap.get(ruleArray[i].getRightSym(1).getNameSymbol());
            
            if (tranMap.get(ruleArray[i].getLeftside() + "," + 
                ruleArray[i].getRightSym(1).getNameSymbol()) == null)
            {
               tran1 = new Transition(beginState, endState);
               tranMap.put(ruleArray[i].getLeftside() + "," + 
                           ruleArray[i].getRightSym(1).getNameSymbol(), tran1);
            }
            else
            {
                tran1 = (Transition)tranMap.get(ruleArray[i].getLeftside() + "," + 
                             ruleArray[i].getRightSym(1).getNameSymbol());
            }
            
            tranAlphabet = tran1.getSymbolSet();
            temp = ruleArray[i].getRightSym(0).getNameSymbol();
            
            if (temp.equals("lambda"))
            {
               ch = StateMachine.EMPTY_SYMBOL.charValue();
            }
            else
            {
               ch = temp.charAt(0);
            }
            
            try
            {
               fsaAlphabet.addSymbol(ch);
               tranAlphabet.addSymbol(ch);
            }
            catch (SymbolChangeException e)
            {
               System.exit(1);   
            }
            catch (Exception e)
            {
            }
            T.addTransition(tran1);
         }
      }
      return T;
   } // end convertToFSA
   */
  
  
   public boolean isGrammarRegular()
   {
      Symbol[] tempSymbols;
      int numRSymbols;
      int numRules = num_rules;
      String rSymbolName;
      boolean found = false;
      
      for (int i = 0; i < numRules; i++)
      {
         Rule tempRule = ruleArray[i];
         numRSymbols = tempRule.getNumRSymbols();
         
         if (numRSymbols == 1)
         {
            rSymbolName = (tempRule.getRightSym(0)).getNameSymbol();
            if ((rSymbolName.length() != 1) && (!rSymbolName.equals("lambda")))
            {
               return false;
            }
            
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals(ruleArray[k].getLeftside()))
               {
                  return false;
               }
            }
         }
         else if (numRSymbols == 2)
         {
            rSymbolName = (tempRule.getRightSym(0)).getNameSymbol(); 
            
            if ((rSymbolName.length() != 1) && (!rSymbolName.equals("lambda")))
            {
               return false;
            }
            
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals(ruleArray[k].getLeftside()))
               {
                  return false;
               }
            }
            
            found = false;
            rSymbolName = (tempRule.getRightSym(1)).getNameSymbol();
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals(ruleArray[k].getLeftside()))
               {
                  found = true;
               }
            }
            if (!found)
            {
                return false;
            }
         }
         else
         {
             return false;
         }
      }
      return true;
   } //end isGrammarRegular

   public void setNumRules(int numRules)
   {
      num_rules = numRules;
      ruleArray = new Rule[num_rules];
      for (int i = 0; i < num_rules; i++)
      {
         ruleArray[i] = new Rule();
      }
   }

   public void setStart(String s)
   {
       start = s;
   }

   public void setLambda(String l)
   {
      lambda = l;
   }

   public void setTitle(String t)
   {
      title = t;
   } 


   public void setRule(int rule, String leftside, Symbol[] rightside)
   {
      ruleArray[rule].setLeftside(leftside);
      ruleArray[rule].setRightside(rightside);
   }

   public void setRule(int ruleNum, Rule rule)
   {
      ruleArray[ruleNum] = rule;
   } 

   public String getTitle()
   {
      return title;
   }

   public String getStart()
   {
      return start;
   }

   public String getLambda()
   {
      return lambda;
   }


   public int get_num_rules()
   {
      return num_rules;
   }

   public Rule getRule(int ruleNum)
   {
      return ruleArray[ruleNum];
   }  

   public String getRuleString(int ruleNum)
   {
      return ruleArray[ruleNum].toString();
   }
   
   // This method will only write out a REGULAR GRAMMAR to a file in XML format.
   public void writeToXML(String fileName) throws Exception
   {
       File output = new File(fileName);
       PrintWriter pout = new PrintWriter(new FileWriter(output));
       pout.println("<?xml version=\"1.0\"?>\n" +
                    "<!DOCTYPE GRAMMAR [\n" + 
                    "<!ELEMENT GRAMMAR (TITLE, START, PRODUCTION+)>\n" +
                    "<!ELEMENT TITLE (#PCDATA)>\n" +
                    "<!ELEMENT START (#PCDATA)>\n" + 
                    "<!ELEMENT PRODUCTION ( LEFTSIDE, RIGHTSIDE)>\n" +
                    "<!ELEMENT LEFTSIDE (#PCDATA)>\n" +
                    "<!ELEMENT RIGHTSIDE (SYMBOL)+ >\n" +
                    "<!ELEMENT SYMBOL (#PCDATA)>\n" +
                    "<!ATTLIST SYMBOL Term (terminal|nonterminal) #REQUIRED>\n" +
                    "]>");
       pout.println("<GRAMMAR>");
       pout.println("<TITLE>" + title + "</TITLE>");
       pout.println("<START>" + start + "</START>");
       for (int i = 0; i < num_rules; i++)
       {
           pout.println("<PRODUCTION>");
           pout.println("<LEFTSIDE>" + ruleArray[i].getLeftside() + "</LEFTSIDE>");
           pout.println("<RIGHTSIDE>");
           
           // changed to allow for CFG grammars to be written to file
           /*if (ruleArray[i].getNumRSymbols() == 1)
           {
               pout.println("<SYMBOL Term=\"terminal\">" + ruleArray[i].getRightSym(0).getNameSymbol() +
                            "</SYMBOL>");
           }
           else
           {
               pout.println("<SYMBOL Term=\"terminal\">" + ruleArray[i].getRightSym(0).getNameSymbol() +
                            "</SYMBOL>");
               pout.println("<SYMBOL Term=\"nonterminal\">" + ruleArray[i].getRightSym(1).getNameSymbol() +
                            "</SYMBOL>");
           }*/
           
           int number = ruleArray[i].getNumRSymbols();
           
           for (int j = 0; j < number; j++)
           {
               if (ruleArray[i].getRightSym(j).getIsTerminal())
               {
                   pout.println("<SYMBOL Term=\"terminal\">" + ruleArray[i].getRightSym(j).getNameSymbol() +
                            "</SYMBOL>");
               }
               else
               {
                   pout.println("<SYMBOL Term=\"nonterminal\">" + ruleArray[i].getRightSym(j).getNameSymbol() +
                            "</SYMBOL>");
               }
           }
           
           pout.println("</RIGHTSIDE>");
           pout.println("</PRODUCTION>");
       }
       pout.println("</GRAMMAR>");
       pout.close();
   }
}
