import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;



class GrammarDialog extends JDialog
   implements ActionListener
{
   JFrame test2;
   JTextArea messages;
   JTextArea description;
   JLabel desc;
   DefaultListModel listModel;
   JList getRuleList;
   JLabel test;
   JLabel leftLabel; 
   JLabel rightLabel; 
   JTextField leftField;
   JTextField rightField;
   String leftString;
   String rightString;
   JButton enterRule;
   JButton editRule;
   JButton insertRule;
   JButton deleteRule;
   JButton submit;
   JMenu menu;
   Vector grammarVector = new Vector(20, 20);
   Grammar userGrammar;
   String startSymbol; 
   final static int SYMBOLS = 10;
   boolean editMode;
   boolean insertMode;
   boolean prevSubmit;
   int ruleIndex;

      
   public GrammarDialog(JFrame someFrame)
   {
       super(someFrame, "Enter Your Grammar Rules", true);
      //test2 = new JFrame();
      
      setSize(650, 400);

      Container pane = getContentPane();

      setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
      addWindowListener(new myWindowAdapter());
      editMode = false;
      insertMode = false;
      prevSubmit = false;

      listModel = new DefaultListModel();
      getRuleList = new JList(listModel);
      getRuleList.setCellRenderer(new RuleCellRenderer());

      messages = new JTextArea();
      messages.setForeground( Color.red );
      messages.setFont(new Font("TimesRoman", Font.BOLD, 14));
      messages.setText( "Please enter the next grammar rule." +
          "\nWhen all the rules are entered,\nclick the 'Submit Rules' button." + 
          "\nBe sure to leave a space between symbols!" );            
      messages.setEditable( false );
      messages.setMargin(new Insets(5,5,5,5));
          
      test = new JLabel("Enter each grammar rule in the following two text fields:");
      leftLabel = new JLabel("left side:");
      rightLabel = new JLabel("right side:");
      leftField = new JTextField("", 15);
      rightField = new JTextField("", 50);
      enterRule = new JButton("Enter Rule");
      editRule = new JButton("Edit Rule");
      insertRule = new JButton("Insert Rule");
      deleteRule = new JButton("Delete Rule");
      submit = new JButton("Submit Rules");

      leftField.setNextFocusableComponent(rightField);
      rightField.setNextFocusableComponent(enterRule);
      enterRule.setNextFocusableComponent(insertRule);
      insertRule.setNextFocusableComponent(editRule);
      editRule.setNextFocusableComponent(deleteRule);
      deleteRule.setNextFocusableComponent(submit);
      submit.setNextFocusableComponent(leftField);

      menu = new JMenu();
      JMenuItem save = new JMenuItem("Save Gammar");
      save.addActionListener(this);
      menu.add(save);

      enterRule.addActionListener(this);
      editRule.addActionListener(this);
      insertRule.addActionListener(this);
      deleteRule.addActionListener(this);
      submit.addActionListener(this);

       //This is way cool!
      leftField.addKeyListener( new KeyAdapter()
            {  public void keyTyped(KeyEvent evt)
               {  
                  if (evt.getKeyChar() == ' ' ) evt.consume();
               }
            } );

      this.addKeyListener( new KeyAdapter()
            {  
               public void keyPressed(KeyEvent evt)
               {
                  if (evt.getKeyCode() == KeyEvent.VK_ENTER)
                     actionPerformed( new ActionEvent(getFocusOwner(), 0, "") );
               } 
            } );
       
      JPanel entryPanel = new JPanel();
      JPanel buttonPanel = new JPanel();
      //JPanel menuPanel = new JPanel();
      JPanel textPanel = new JPanel();

      GridBagLayout paneLayout = new GridBagLayout();
      GridBagLayout entryLayout = new GridBagLayout();
      GridBagLayout buttonLayout = new GridBagLayout();

      GridBagConstraints constraints = new GridBagConstraints();
      pane.setLayout(paneLayout);
      entryPanel.setLayout(entryLayout);
      buttonPanel.setLayout(buttonLayout);
      //menuPanel.setLayout(entryLayout);
      textPanel.setLayout(buttonLayout); 
      
      JScrollPane scrollRuleList = new JScrollPane( getRuleList );
      scrollRuleList.setMinimumSize(new Dimension(600, 300));
      JScrollPane scrollMessages = new JScrollPane( messages );
      scrollMessages.setMinimumSize(new Dimension(175,100));
      
      constraints.gridx = 0;  constraints.gridy = 0;
      constraints.weighty = 1.0;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      desc = new JLabel("This is the Grammar's English Description:     ");
      textPanel.add(desc, constraints);
      
      constraints.gridx = 1;  constraints.gridy = 0;
      constraints.weighty = 1.0;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      description = new JTextArea("", 100, 2000);
      description.setEditable(true);
      description.setLineWrap(true);
      description.setWrapStyleWord(true);
      description.setMargin(new Insets(10,5,5,5));
      JScrollPane descScroll = new JScrollPane(description);
      descScroll.setMinimumSize(new Dimension(350, 50));
      
      textPanel.add(descScroll, constraints);
      
      constraints.insets.left = 5; constraints.insets.right = 5;
      constraints.insets.top = 3; constraints.insets.bottom = 3;
      constraints.gridx = 0;  constraints.gridy = 0;
      constraints.weighty = 1.0;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      pane.add(scrollRuleList, constraints);
     
      constraints.gridy = 1;
      constraints.weighty = 0;
      pane.add(test, constraints);
      
      
      
      
      // construct entryPanel
      constraints.gridx = 0; constraints.gridy = 0;
      
      entryPanel.add(leftLabel, constraints);
      constraints.gridx = 1;
      constraints.weightx = .25;
      entryPanel.add(leftField, constraints);
      constraints.gridx = 2; constraints.weightx = 0;
      entryPanel.add(rightLabel, constraints);
      constraints.gridx = 3; constraints.weightx = .75;
      entryPanel.add(rightField, constraints);

      constraints.gridx = 0; constraints.gridy = 2;
      pane.add(entryPanel, constraints);

      // construct buttonPanel
      constraints.gridx = 0; constraints.gridy = 0;
      buttonPanel.add(enterRule, constraints);
      constraints.gridy = 1;
      buttonPanel.add(editRule, constraints);
      constraints.gridx = 1; constraints.gridy = 0;
      buttonPanel.add(insertRule, constraints);
      constraints.gridx = 1; constraints.gridy = 1;
      buttonPanel.add(deleteRule, constraints);
      constraints.gridx = 2; constraints.gridy = 0;
      constraints.gridheight = 3;
      constraints.fill = GridBagConstraints.BOTH; 
      constraints.weightx = 1.0; constraints.weighty = 1.0;
      buttonPanel.add(scrollMessages, constraints);
      constraints.gridx = 3; constraints.gridheight = 2;
      constraints.weightx = 0.0; constraints.weighty = 0.0; 
      buttonPanel.add(submit, constraints);

      constraints.gridx = 0; constraints.gridy = 3;
      pane.add(buttonPanel, constraints);
      //test2.getContentPane().add(pane);

      constraints.gridx = 0;
      constraints.gridy = 5;
      
      pane.add(textPanel, constraints);

      requestFocus();
      leftField.requestFocus();
      
      
      
      //System.out.println("Size is " + grammarVector.size());
   }

   public Grammar showDialog()
   {
      show(); 
      test.show();
      return userGrammar;

   }

   
   public Grammar showDialog(Grammar g)
   {
      int numrules = g.get_num_rules();
      for(int i = 0; i < numrules; i++)
      {
         listModel.addElement( g.getRule(i) );
         grammarVector.add( g.getRule(i) );
      }
      description.setText(g.getTitle());
      show();
      
      //System.out.println("Number of rules is " + userGrammar.get_num_rules());
      return userGrammar;
   }


     
   public void actionPerformed(ActionEvent e)
   {
      Object source = e.getSource();

      // if enterRule button is clicked
      if (source == enterRule)
      {
         prevSubmit = false;
         processRule();
         getRuleList.clearSelection();
         leftField.requestFocus();
         
      }

      // if editRule button is clicked
      if (source == editRule)
      {
         prevSubmit = false;
         if ( getRuleList.getSelectedIndex() == -1 )
         {
            JOptionPane.showMessageDialog( getContentPane() , "You must first select the rule to edit" +
               "\nin the above list by clicking on it." +
               "\nThen click the 'Edit Rule' button again.");
            messages.setText("You must first select the rule to edit" +
               "\nin the above list by clicking on it." +
               "\nThen click the 'Edit Rule' button again.");
         }
         else
         {
            
            messages.setText("Click the 'Enter Rule' button when\n" +
               "you are finished editing this rule.");
            ruleIndex = getRuleList.getSelectedIndex();
            editMode = true;
            Rule tempRule = (Rule)grammarVector.get(ruleIndex);

//          System.out.println( tempRule.toString() );

            leftField.setText( tempRule.getLeftside() );
            String rs = tempRule.getRightSym(0).getNameSymbol();
            for (int i = 1; i < tempRule.getNumRSymbols(); i++)
               rs = rs + " " + tempRule.getRightSym(i).getNameSymbol();
            rightField.setText( rs );
            leftField.requestFocus();
         }         
      }

      // if insert rule button is clicked
      if (source == insertRule)
      {
         prevSubmit = false;
         if ( getRuleList.getSelectedIndex() == -1 )
         {
            JOptionPane.showMessageDialog( getContentPane() , "You must indicate where you would" +
               "\nlike this rule inserted. Select the" +
               "\nlocation in the list above.\nThen click 'Insert Rule' again");
            messages.setText("You must indicate where you would" +
               "\nlike this rule inserted. Select the" +
               "\nlocation in the list above.\nThen click 'Insert Rule' again");
         }
         else
         {
            ruleIndex = getRuleList.getSelectedIndex();
            insertMode = true;
            processRule();
            leftField.requestFocus();
            getRuleList.clearSelection();
         }


      } 

      // if delete rule button is clicked
      if (source == deleteRule)
      {
         prevSubmit = false;
         if ( getRuleList.getSelectedIndex() == -1 )
         {
            JOptionPane.showMessageDialog( getContentPane() , "You must indicate which rule above to\n" +
               "delete by clicking on it.\nThen click 'Delete Rule' again.");
            messages.setText("You must indicate which rule above to\n" +
               "delete by clicking on it.\nThen click 'Delete Rule' again.");
            
         }
         else
         {
            ruleIndex = getRuleList.getSelectedIndex();
            grammarVector.removeElementAt( ruleIndex );
            findTerminals();
            listModel.remove( ruleIndex );
            messages.setText( "Please enter the next grammar rule.\n"
               + "Click 'Submit Rules' when all rules are entered.");            
            leftField.requestFocus(); 
         }         
      } 


      // if Submit Rules button is clicked
      if (source == submit)
      {
         if (grammarVector.size() != 0)
         {
         if (description.getText().equals(""))
         {
             JOptionPane.showMessageDialog( getContentPane() , "Grammar must have an English Description!");
             messages.setText("Grammar must have an English Description!");
         }
         else if (prevSubmit == false) 
         {
            startSymbol = ((Rule)grammarVector.get(0)).getLeftside();
            JOptionPane.showMessageDialog( getContentPane() , "Please double check the rules above."
               + "\nIf okay, click 'Submit Rules' again."
               + "\nThe start symbol for this grammar \nis '" + startSymbol + "'");
            messages.setText("Please double check the rules above."
               + "\nIf okay, click 'Submit Rules' again."
               + "\nThe start symbol for this grammar \nis '" + startSymbol + "'");
            prevSubmit = true;
         }
         else 
         {
               
            int numRules = grammarVector.size();
            userGrammar = new Grammar( numRules );
            userGrammar.setStart( startSymbol );
            userGrammar.setTitle(description.getText());
            
            for (int i = 0; i < numRules; i++) 
            {
               userGrammar.setRule(i, (Rule)grammarVector.get(i));
            }
            //if (userGrammar.isGrammarRegular())
            //{
               System.out.println("Number of rules is " + userGrammar.get_num_rules());
               setVisible(false);
            //}
            /*else
            {
                JOptionPane.showMessageDialog( getContentPane() , "Grammar is not regular!\n" + 
                                 "All rules must be either:\n" + 
                                 "[nonTerm] --> term [nonTerm],\n" + 
                                 "[nonTerm] --> term, or\n" + 
                                 "[nonTerm] --> lambda");
                messages.setText("Grammar is not regular!\n" + 
                                 "All rules must be either:\n" + 
                                 "[nonTerm] --> term [nonTerm],\n" + 
                                 "[nonTerm] --> term, or\n" + 
                                 "[nonTerm] --> lambda");
            }*/
         }
         }
         else
         {
            JOptionPane.showMessageDialog( getContentPane() , "Grammar must have a Start Symbol!");
            messages.setText("Grammar must have a Start Symbol!");
         }
            /*
            if (prevSubmit == false) {
               startSymbol = ((Rule)grammarVector.get(0)).getLeftside();
               messages.setText("Please double check the rules above."
                  + "\nIf okay, click 'Submit Rules' again."
                  + "\nThe start symbol for this grammar \nis '" + startSymbol + "'");
               prevSubmit = true;
            }
            else {
               int numRules = grammarVector.size();
               userGrammar = new Grammar( numRules );
               userGrammar.setStart( startSymbol );
               userGrammar.setTitle("Grammar input by user");

               for (int i = 0; i < numRules; i++) {
                  userGrammar.setRule( i, (Rule)grammarVector.get(i) );
               }

               System.out.println("Number of rules is " + userGrammar.get_num_rules());
               setVisible(false);
            }*/
     
      }         
   }

   private void findTerminals()
   {
      Symbol[] tempSymbols;
      int numRSymbols;
      int numRules = grammarVector.size();
      String rSymbolName;
      for (int i = 0; i < numRules; i++)
      {
         Rule tempRule = (Rule)grammarVector.get(i);
         numRSymbols = tempRule.getNumRSymbols();
         for (int j = 0; j < numRSymbols; j++)
         {
            rSymbolName = ( tempRule.getRightSym(j) ).getNameSymbol() ;
            tempRule.setRightSymbol( j, rSymbolName, true );
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals( ((Rule)grammarVector.get(k)).getLeftside() ) )
               {
                  tempRule.setRightSymbol(j, rSymbolName, false);
                  break;
               }
            }
         }
         grammarVector.setElementAt( tempRule, i );
      }
   }
   
   // This method added by Brad Pascoe on 6/23/03
   // It determines if the entered Grammar is regular or not.
   public boolean isGrammarRegular()
   {
      Symbol[] tempSymbols;
      int numRSymbols;
      int numRules = grammarVector.size();
      String rSymbolName;
      boolean found = false;
      
      for (int i = 0; i < numRules; i++)
      {
         Rule tempRule = (Rule)grammarVector.get(i);
         numRSymbols = tempRule.getNumRSymbols();
         
         if (numRSymbols == 1)
         {
            rSymbolName = (tempRule.getRightSym(0)).getNameSymbol();
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals( ((Rule)grammarVector.get(k)).getLeftside() ) )
               {
                  return false;
               }
            }
         }
         else if (numRSymbols == 2)
         {
            rSymbolName = (tempRule.getRightSym(0)).getNameSymbol();             
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals(((Rule)grammarVector.get(k)).getLeftside()))
               {
                  return false;
               }
            }
            
            found = false;
            rSymbolName = (tempRule.getRightSym(1)).getNameSymbol();
            for (int k = 0; k < numRules; k++)
            {
               if (rSymbolName.equals(((Rule)grammarVector.get(k)).getLeftside()))
               {
                  found = true;
               }
            }
            if (!found)
            {
                return false;
            }
         }
         else
         {
             return false;
         }
      }
      return true;
   }

   private void processRule()
   {
      Rule userRule = new Rule();
      Symbol[] tempSymbols = new Symbol[SYMBOLS];
      int symbolNum = 0;
      StringTokenizer t;

      leftString = leftField.getText();
      rightString = rightField.getText();
      t = new StringTokenizer( rightString );

      if (leftString.equals(""))
      {
         JOptionPane.showMessageDialog( getContentPane() , "The rule's leftside cannot be empty!");
         messages.setText("The rule's leftside cannot be empty!");
      }
      else
      {         
          
         while ( t.hasMoreTokens() )
         {
            tempSymbols[symbolNum] = new Symbol();
            tempSymbols[symbolNum].setNameSymbol( t.nextToken() );
            symbolNum++;
         }
      
         if ( symbolNum == 0 )
         {
            tempSymbols[0] = new Symbol();
            tempSymbols[symbolNum].setNameSymbol( "lambda" );
            symbolNum = 1;
         }

         Symbol[] rightSymbols = new Symbol[symbolNum];
         for (int i = 0; i < symbolNum; i++ )
         {
            rightSymbols[i] = tempSymbols[i];
         }

         userRule.setLeftside( leftString );
         userRule.setRightside( rightSymbols );


         // check rule to make sure it is not a duplicate
         boolean match = false;
         for (int i = 0; i < grammarVector.size(); i++)
         {
            if ( userRule.toString().equals(((Rule)grammarVector.get(i)).toString())
                  && !( editMode && i==ruleIndex) )
            {
               match = true;
               break;
            }
         } 
        
         if (match == true)
         {
            messages.setText("This rule cannot be added since it" +
                  "\nis a DUPLICATE of another rule in the list.");
            return;
         }

         if (editMode)
         {
            grammarVector.setElementAt(userRule, ruleIndex);
            findTerminals();
            listModel.setElementAt( userRule, ruleIndex );
            editMode = false;
         }
         else if (insertMode)
         {
            grammarVector.insertElementAt( userRule, ruleIndex );
            findTerminals();
            listModel.add( ruleIndex, userRule );
            insertMode = false;  
         } 
         else
         {
            grammarVector.add(userRule);
            findTerminals();
            listModel.addElement( userRule );
            getRuleList.ensureIndexIsVisible( listModel.size() - 1 );
         }

         leftField.setText("");
         rightField.setText("");
         messages.setText("Please enter the next grammar rule.\n" +
            "When all rules are entered,\nclick the 'Submit Rules' button.");
      }
   }


   //=====================================================================
   //Inner class, myWindowAdapter
   //
   //=====================================================================
   class myWindowAdapter extends WindowAdapter
   {  
      public myWindowAdapter()
      {}

      public void windowClosing(WindowEvent e)
      {
         if (grammarVector.size() == 0)
         {
            setVisible(false);
         }
         else
         {  
            String string = "If you close this window prior to submitting your" +
                  "\nfinalized grammar, your work will not be saved." +
                  "\nAre you sure you wish to close this window?" ;
            int n = JOptionPane.showConfirmDialog( getContentPane() , string, "", 
                  JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE );
            if (n == JOptionPane.YES_OPTION )
            { 
               setVisible(false);
            }
            // else if n == JOptionPane.NO_OPTION, do nothing!
         }
       }
    }  	
}



class RuleCellRenderer implements ListCellRenderer
{  public Component getListCellRendererComponent
      (final JList list, final Object value,
      final int index, final boolean isSelected,
      final boolean cellHasFocus)
   {
      return new JPanel()
         {  public void paintComponent(Graphics g)
            {
               super.paintComponent(g);

               Rule rule = (Rule)value;             
               Font font = new Font("Helvetica", Font.PLAIN, 12);
               Font font2 = new Font("Helvetica", Font.ITALIC, 12);
               FontMetrics fm = g.getFontMetrics(font);
               FontMetrics fm2 = g.getFontMetrics(font2);
               g.setFont(font);
               int currentx = 5;
               int currenty = fm.getAscent();
               
               g.setColor(isSelected
                  ? list.getSelectionBackground()
                  : list.getBackground());
               g.fillRect(0, 0, getWidth(), getHeight());
               g.setColor(isSelected
                  ? list.getSelectionForeground()
                  : list.getForeground());
               
               int myIndex = index + 1;
               String string = new String("[" + myIndex + "]  ");
               g.drawString (string, currentx, currenty);
               currentx += fm.stringWidth(string);

               string = rule.getLeftside();
               g.setColor(Color.black);               
               g.drawString(string, currentx, currenty);
               currentx += fm.stringWidth(string);

               string = new String(" --> ");
               g.drawString(string, currentx, currenty);
               currentx += fm.stringWidth(string);

               for (int i = 0; i < rule.getNumRSymbols(); i++)
               {
                  g.setColor(Color.black);
                  string = new String( (rule.getRightSym(i)).getNameSymbol() + " " );
                  if ( (rule.getRightSym(i)).getIsTerminal() )
                  {
                     g.setFont(font);
                     g.setColor(Color.blue);
                     g.drawString(string, currentx, currenty);
                     currentx += fm.stringWidth(string);
                  }
                  else
                  {
                     g.setFont(font);
                     g.setColor(Color.black);
                     g.drawString(string, currentx, currenty);
                     currentx += fm.stringWidth(string);
                  }
               }
            }

            public Dimension getPreferredSize()
            {
               Font font = new Font("Helvetica", Font.PLAIN, 12);
               Graphics g = getGraphics();
               FontMetrics fm = getFontMetrics(font);
               String ruleString = ((Rule)value).toString();             
                 
               return new Dimension( fm.stringWidth(ruleString),
                  fm.getHeight() );
            }
         };
   }
}


   
