


class Rule {
 	public String leftside;
 	public int numRSymbols;
 	public Symbol[] rightSymbols;

	public Rule()
	{
  		numRSymbols = 0;
   		leftside = "";
	}


	public String toString()
	{
	   String rule = (leftside + " --> ");
       for (int i = 0; i < numRSymbols; i++)
       {
          rule = rule + " " + rightSymbols[i].getNameSymbol();
       }
       return rule;
    }


	public void setNumRSymbols(int n)
	{
   		numRSymbols = n;
  		for (int i = 0; i < n; i++)
  		{
      		rightSymbols[i] = new Symbol();
   		}
	}     

	public void setLeftside(String l)
	{   leftside = l;  }


	public void setRightside(Symbol[] r)
	{
        rightSymbols = r;
        numRSymbols = r.length;
	}

    public void setRightSymbol(int symNum, String symName, boolean isTerm)
    {
       (rightSymbols[symNum]).setSymbol(symName, isTerm);
    }

    public String getLeftside()
    {
       return leftside;
    }

    public Symbol[] getRightside()
    {
       return rightSymbols;
    }

    public Symbol getRightSym(int symNum)
    {
       return rightSymbols[symNum];
    }

    public int getNumRSymbols()
    {
       return numRSymbols;
    }
}  



class Symbol {
   public String nameSymbol;
   public boolean isTerminal;
   
   public Symbol()
   { 
      nameSymbol = "";
      isTerminal = false;
   }
	
   public Symbol(String name, boolean term)
   {
      nameSymbol = name;
      isTerminal = term;
   }

   public void setSymbol(String name, boolean term)
   {
      nameSymbol = name;
      isTerminal = term;
   }

   public void setIsTerminal(boolean term)
   {        }

   public void setNameSymbol(String name)
   {
      nameSymbol = name;
   }

   public boolean getIsTerminal()
   {
      return isTerminal;
   }

   public String getNameSymbol()
   {
      return nameSymbol;
   }
}   
