/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public QueuedExecutor(Channel queue) {
        this.queue_ = queue;
        this.runLoop_ = new RunLoop();
    }

    public QueuedExecutor() {
        this(new BoundedLinkedQueue());
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        }
    }

    public void execute(Runnable command) throws InterruptedException {
        this.restart();
        this.queue_.put(command);
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    while (true) {
                        Runnable task = (Runnable)QueuedExecutor.this.queue_.take();
                        task.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    QueuedExecutor.this.clearThread();
                }
            }
            catch (Throwable throwable) {
                QueuedExecutor.this.clearThread();
                throw throwable;
            }
        }
    }
}

