/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;

public class WaitFreeQueue
implements Channel {
    protected final Node head_;
    protected final Node tail_;

    public WaitFreeQueue() {
        Node dummy = new Node(null);
        this.head_ = new Node(null);
        this.tail_ = new Node(null);
        this.head_.next = dummy;
        this.tail_.next = dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) throws InterruptedException {
        Node node = new Node(x);
        while (true) {
            long lastDotCount;
            Node lastDotNext;
            long tailDotCount;
            Node tailDotNext;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.tail_;
            synchronized (node2) {
                tailDotNext = this.tail_.next;
                tailDotCount = this.tail_.count;
            }
            Node node3 = tailDotNext;
            synchronized (node3) {
                lastDotNext = tailDotNext.next;
                lastDotCount = tailDotNext.count;
            }
            if (!this.tail_.pointerEquals(tailDotNext, tailDotCount)) continue;
            if (lastDotNext == null) {
                if (!tailDotNext.commit(lastDotNext, lastDotCount, node, lastDotCount + 1L)) continue;
                this.tail_.commit(tailDotNext, tailDotCount, node, tailDotCount + 1L);
                return;
            }
            this.tail_.commit(tailDotNext, tailDotCount, lastDotNext, tailDotCount + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object extract() throws InterruptedException {
        Object x;
        while (true) {
            long tailDotCount;
            Node tailDotNext;
            long headDotCount;
            Node headDotNext;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.head_;
            synchronized (node) {
                headDotNext = this.head_.next;
                headDotCount = this.head_.count;
            }
            Node node2 = this.tail_;
            synchronized (node2) {
                tailDotNext = this.tail_.next;
                tailDotCount = this.tail_.count;
            }
            Node first = headDotNext.next;
            if (!this.head_.pointerEquals(headDotNext, headDotCount)) continue;
            if (headDotNext == tailDotNext) {
                if (first == null) {
                    return null;
                }
                this.tail_.commit(tailDotNext, tailDotCount, first, tailDotCount + 1L);
                continue;
            }
            x = first.value;
            if (this.head_.commit(headDotNext, headDotCount, first, headDotCount + 1L)) break;
        }
        first.value = null;
        return x;
    }

    public Object take() throws InterruptedException {
        Object x;
        while ((x = this.extract()) == null) {
            Thread.sleep(0L);
        }
        return x;
    }

    public Object poll(long msecs) throws InterruptedException {
        Object x = this.extract();
        if (x != null || msecs <= 0L) {
            return x;
        }
        long startTime = System.currentTimeMillis();
        Thread.sleep(0L);
        while ((x = this.extract()) == null) {
            if (System.currentTimeMillis() - startTime >= msecs) {
                return null;
            }
            Thread.sleep(0L);
        }
        return x;
    }

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        this.insert(x);
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        this.insert(x);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Node first;
        block8: {
            while (true) {
                Node tailDotNext;
                long headDotCount;
                Node headDotNext;
                if (Thread.interrupted()) {
                    return null;
                }
                Node node = this.head_;
                synchronized (node) {
                    headDotNext = this.head_.next;
                    headDotCount = this.head_.count;
                }
                Node node2 = this.tail_;
                synchronized (node2) {
                    tailDotNext = this.tail_.next;
                    long tailDotCount = this.tail_.count;
                }
                first = headDotNext.next;
                if (!this.head_.pointerEquals(headDotNext, headDotCount)) continue;
                if (headDotNext != tailDotNext) break block8;
                if (first == null) break;
            }
            return null;
        }
        return first.value;
    }

    protected static final class Node {
        protected Object value;
        protected Node next = null;
        protected long count = 0L;

        protected Node(Object x) {
            this.value = x;
        }

        protected final synchronized boolean pointerEquals(Node assumedNext, long assumedCount) {
            return assumedNext == this.next && assumedCount == this.count;
        }

        protected final synchronized boolean commit(Node assumedNext, long assumedCount, Node newNext, long newCount) {
            boolean success;
            boolean bl = success = this.next == assumedNext && this.count == assumedCount;
            if (success) {
                this.next = newNext;
                this.count = newCount;
            }
            return success;
        }
    }
}

