/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.Site;
import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public final class CanvasUtilities {
    private static final int m00 = 0;
    private static final int m10 = 1;
    private static final int m01 = 2;
    private static final int m11 = 3;
    private static final int m02 = 4;
    private static final int m12 = 5;
    private static boolean _transformRectangularShapeIsBroken = true;

    private CanvasUtilities() {
    }

    public static Shape clone(Shape s) {
        if (s instanceof RectangularShape) {
            return (RectangularShape)((RectangularShape)s).clone();
        }
        return new GeneralPath(s);
    }

    public static Shape computeCompositeShape(Iterator i) {
        if (!i.hasNext()) {
            return new Rectangle2D.Double();
        }
        Figure f = (Figure)i.next();
        GeneralPath shape = new GeneralPath(f.getShape());
        while (i.hasNext()) {
            f = (Figure)i.next();
            shape.append(f.getShape(), false);
        }
        return shape;
    }

    public static Rectangle2D computeSiteBounds(Iterator i) {
        double y2;
        double x2;
        Site f = (Site)i.next();
        double x1 = x2 = f.getX();
        double y1 = y2 = f.getY();
        while (i.hasNext()) {
            f = (Site)i.next();
            double x = f.getX();
            double y = f.getY();
            if (x < x1) {
                x1 = x;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (!(y > y2)) continue;
            y2 = y;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public static Rectangle2D computeCompositeBounds(Iterator i) {
        if (!i.hasNext()) {
            return new Rectangle2D.Double();
        }
        Figure f = (Figure)i.next();
        Rectangle2D b = f.getBounds();
        Rectangle2D.Double bounds = new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        while (i.hasNext()) {
            f = (Figure)i.next();
            Rectangle2D.union(bounds, f.getBounds(), bounds);
        }
        return bounds;
    }

    public static AffineTransform computeTransform(RectangularShape r, RectangularShape s) {
        AffineTransform at = new AffineTransform();
        at.translate(s.getX(), s.getY());
        at.scale(s.getWidth() / r.getWidth(), s.getHeight() / r.getHeight());
        at.translate(-r.getX(), -r.getY());
        return at;
    }

    public static Point2D getCenterPoint(Rectangle2D r) {
        return new Point2D.Double(r.getCenterX(), r.getCenterY());
    }

    public static Point2D getCenterPoint(Figure f) {
        return CanvasUtilities.getCenterPoint(f.getBounds());
    }

    /*
     * WARNING - void declaration
     */
    public static Point2D getLocation(Rectangle2D r, int location) {
        void var4_3;
        void var2_2;
        switch (location) {
            case 0: {
                double x = r.getCenterX();
                double y = r.getCenterY();
                break;
            }
            case 1: {
                double x = r.getCenterX();
                double y = r.getMinY();
                break;
            }
            case 2: {
                double x = r.getMaxX();
                double y = r.getMinY();
                break;
            }
            case 3: {
                double x = r.getMaxX();
                double y = r.getCenterY();
                break;
            }
            case 4: {
                double x = r.getMaxX();
                double y = r.getMaxY();
                break;
            }
            case 5: {
                double x = r.getCenterX();
                double y = r.getMaxY();
                break;
            }
            case 6: {
                double x = r.getMinX();
                double y = r.getMaxY();
                break;
            }
            case 7: {
                double x = r.getMinX();
                double y = r.getCenterY();
                break;
            }
            case 8: {
                double x = r.getMinX();
                double y = r.getMinY();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown location constant: " + location);
            }
        }
        return new Point2D.Double((double)var2_2, (double)var4_3);
    }

    public static boolean isOrthogonal(AffineTransform at) {
        int t = at.getType();
        return (t & 0x38) == 0;
    }

    public static Figure pick(Iterator i, Rectangle2D region) {
        while (i.hasNext()) {
            Figure picked;
            Figure f = (Figure)i.next();
            if (f instanceof FigureContainer && (picked = ((FigureContainer)((Object)f)).pick(region)) != null) {
                return picked;
            }
            if (!f.hit(region)) continue;
            return f;
        }
        return null;
    }

    public static Iterator pickIter(Iterator i, Rectangle2D region) {
        Rectangle2D rl = region;
        return new FilteredIterator(i, new Filter(rl){
            Rectangle2D _region;
            private final /* synthetic */ Rectangle2D val$rl;
            {
                this._region = this.val$rl = val$rl;
            }

            public boolean accept(Object o) {
                Figure f = (Figure)o;
                return f.hit(this._region);
            }
        });
    }

    public static int reverseDirection(int direction) {
        switch (direction) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unknown direction constant: " + direction);
    }

    public static Shape transform(RectangularShape r, AffineTransform at) {
        if (_transformRectangularShapeIsBroken) {
            Rectangle2D bounds = at.createTransformedShape(r).getBounds2D();
            r.setFrame(bounds);
            return r;
        }
        if ((at.getType() & 7) != 0) {
            double x = r.getX();
            double y = r.getY();
            double w = r.getWidth();
            double h = r.getHeight();
            double xdash = 0.0;
            double ydash = 0.0;
            double wdash = 0.0;
            double hdash = 0.0;
            double[] m = new double[6];
            at.getMatrix(m);
            switch (at.getType()) {
                case 3: 
                case 5: {
                    xdash = x * m[0] + m[4];
                    ydash = y * m[3] + m[5];
                    wdash = w * m[0];
                    hdash = h * m[3];
                    break;
                }
                case 2: 
                case 4: {
                    xdash = x * m[0];
                    ydash = y * m[3];
                    wdash = w * m[0];
                    hdash = h * m[3];
                    break;
                }
                case 1: {
                    xdash = x + m[4];
                    ydash = y + m[5];
                    wdash = w;
                    hdash = h;
                    break;
                }
                case 0: {
                    xdash = x;
                    ydash = y;
                    wdash = w;
                    hdash = h;
                }
            }
            r.setFrame(xdash, ydash, wdash, hdash);
            return r;
        }
        return at.createTransformedShape(r);
    }

    public static Shape transform(Shape s, AffineTransform at) {
        if (s instanceof RectangularShape) {
            return CanvasUtilities.transform((RectangularShape)s, at);
        }
        if (s instanceof Polygon2D) {
            ((Polygon2D)s).transform(at);
            return s;
        }
        if (s instanceof Polyline2D) {
            ((Polyline2D)s).transform(at);
            return s;
        }
        if (s instanceof GeneralPath) {
            ((GeneralPath)s).transform(at);
            return s;
        }
        return at.createTransformedShape(s);
    }

    public static void translate(Figure f, double distance, int direction) {
        Point2D.Double p = new Point2D.Double();
        CanvasUtilities.translate(p, distance, direction);
        f.translate(p.x, p.y);
    }

    public static Point2D translate(Point2D p, double distance, int direction) {
        if (p instanceof Point2D.Double) {
            return CanvasUtilities.translate((Point2D.Double)p, distance, direction);
        }
        return CanvasUtilities.translate((Point2D.Float)p, distance, direction);
    }

    public static Point2D translate(Point2D.Double p, double distance, int direction) {
        switch (direction) {
            case 1: {
                p.y -= distance;
                break;
            }
            case 2: {
                p.y -= distance;
                p.x += distance;
                break;
            }
            case 3: {
                p.x += distance;
                break;
            }
            case 4: {
                p.y += distance;
                p.x += distance;
                break;
            }
            case 5: {
                p.y += distance;
                break;
            }
            case 6: {
                p.y += distance;
                p.x -= distance;
                break;
            }
            case 7: {
                p.x -= distance;
                break;
            }
            case 8: {
                p.y -= distance;
                p.x -= distance;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction constant: " + direction);
            }
        }
        return p;
    }

    public static Point2D translate(Point2D.Float p, double distance, int direction) {
        switch (direction) {
            case 1: {
                p.y -= (float)distance;
                break;
            }
            case 2: {
                p.y -= (float)distance;
                p.x += (float)distance;
                break;
            }
            case 3: {
                p.x += (float)distance;
                break;
            }
            case 4: {
                p.y += (float)distance;
                p.x += (float)distance;
                break;
            }
            case 5: {
                p.y += (float)distance;
                break;
            }
            case 6: {
                p.y += (float)distance;
                p.x -= (float)distance;
                break;
            }
            case 7: {
                p.x -= (float)distance;
                break;
            }
            case 8: {
                p.y -= (float)distance;
                p.x -= (float)distance;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction constant: " + direction);
            }
        }
        return p;
    }

    public static Shape translate(Shape s, double x, double y) {
        if (s instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)s;
            r.setFrame(x + r.getX(), y + r.getY(), r.getWidth(), r.getHeight());
            return r;
        }
        if (s instanceof Polygon2D) {
            ((Polygon2D)s).translate(x, y);
            return s;
        }
        if (s instanceof Polyline2D) {
            ((Polyline2D)s).translate(x, y);
            return s;
        }
        if (s instanceof GeneralPath) {
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            ((GeneralPath)s).transform(at);
            return s;
        }
        AffineTransform at1 = AffineTransform.getTranslateInstance(x, y);
        return at1.createTransformedShape(s);
    }
}

