/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.AbstractFigure;
import diva.canvas.AbstractFigureContainer;
import diva.canvas.BasicZList;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.TransformContext;
import diva.canvas.ZList;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class CompositeFigure
extends AbstractFigureContainer {
    private Rectangle2D _cachedBounds = null;
    private ZList _children;
    private TransformContext _transformContext = new TransformContext(this);

    public CompositeFigure() {
        this._children = new BasicZList();
    }

    public CompositeFigure(ZList zlist) {
        this._children = zlist;
    }

    public void add(Figure f) {
        this._children.add(f);
        ((AbstractFigure)f).setParent(this);
        f.repaint();
    }

    public void add(int index, Figure f) {
        this._children.add(index, f);
        ((AbstractFigure)f).setParent(this);
        f.repaint();
    }

    public boolean contains(Figure f) {
        return this._children.contains(f);
    }

    public Iterator figures() {
        return this._children.figures();
    }

    public Iterator figuresFromBack() {
        return this._children.figuresFromBack();
    }

    public Iterator figuresFromFront() {
        return this._children.figuresFromFront();
    }

    public Figure get(int index) {
        return this._children.get(index);
    }

    public Rectangle2D getBounds() {
        if (this._cachedBounds == null) {
            AffineTransform at = this._transformContext.getTransform();
            Shape bounds = at.createTransformedShape(this._children.getBounds());
            this._cachedBounds = bounds.getBounds2D();
        }
        return this._cachedBounds;
    }

    public ZList getChildren() {
        return this._children;
    }

    public int getFigureCount() {
        return this._children.getFigureCount();
    }

    public Shape getShape() {
        return this.getBounds();
    }

    public TransformContext getTransformContext() {
        return this._transformContext;
    }

    public int indexOf(Figure f) {
        return this._children.indexOf(f);
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        this._transformContext.push(g);
        Iterator i = this._children.figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g);
        }
        this._transformContext.pop(g);
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (!this.isVisible()) {
            return;
        }
        this._transformContext.push(g);
        AffineTransform t = this._transformContext.getInverseTransform();
        if (!t.isIdentity()) {
            region = CanvasUtilities.isOrthogonal(t) ? (Rectangle2D)CanvasUtilities.transform(region, t) : t.createTransformedShape(region).getBounds2D();
        }
        Iterator i = this.figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g, region);
        }
        this._transformContext.pop(g);
    }

    public Figure pick(Rectangle2D region) {
        AffineTransform at = this._transformContext.getInverseTransform();
        region = at.createTransformedShape(region).getBounds();
        return CanvasUtilities.pick(this._children.getIntersectedFigures(region).figuresFromFront(), region);
    }

    public void remove(Figure f) {
        f.repaint();
        f.setParent(null);
        this._children.remove(f);
    }

    public void remove(int index) {
        this._children.get(index).repaint();
        this._children.get(index).setParent(null);
        this._children.remove(index);
    }

    public void repaint(DamageRegion d) {
        d.checkCacheValid(this._transformContext);
        this._cachedBounds = null;
        super.repaint(d);
    }

    public void setIndex(int index, Figure f) {
        this._children.setIndex(index, f);
        f.repaint();
    }

    protected void swapChild(Figure child, Figure replacement) {
        this._children.set(this._children.indexOf(child), replacement);
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._cachedBounds = null;
        this._transformContext.preConcatenate(at);
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._cachedBounds = null;
        this._transformContext.translate(x, y);
        this.repaint();
    }
}

