/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.AbstractFigureContainer;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.util.NullIterator;
import diva.util.UnitIterator;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class FigureDecorator
extends AbstractFigureContainer {
    private Figure _child = null;

    public boolean contains(Figure f) {
        return f == this._child;
    }

    public Iterator figures() {
        if (this._child == null) {
            return new NullIterator();
        }
        return new UnitIterator(this._child);
    }

    public Iterator figuresFromBack() {
        return this.figures();
    }

    public Iterator figuresFromFront() {
        return this.figures();
    }

    public int getFigureCount() {
        if (this._child == null) {
            return 0;
        }
        return 1;
    }

    public Rectangle2D getBounds() {
        if (this._child == null) {
            return new Rectangle2D.Double();
        }
        return this._child.getBounds();
    }

    public Figure getChild() {
        return this._child;
    }

    public FigureContainer getContainer() {
        if (this.getParent() instanceof FigureDecorator) {
            return ((FigureDecorator)this.getParent()).getContainer();
        }
        return (FigureContainer)this.getParent();
    }

    public Shape getShape() {
        if (this._child == null) {
            return new Rectangle2D.Double();
        }
        return this._child.getBounds();
    }

    public Figure getDecoratedFigure() {
        if (this._child instanceof FigureDecorator) {
            return ((FigureDecorator)this._child).getDecoratedFigure();
        }
        return this._child;
    }

    public boolean hit(Rectangle2D r) {
        return this._child.hit(r);
    }

    public abstract FigureDecorator newInstance(Figure var1);

    public void paint(Graphics2D g) {
        if (this._child != null) {
            this._child.paint(g);
        }
    }

    public void setChild(Figure f) {
        if (this._child != null) {
            this._child.repaint();
            this._child.setParent(null);
        }
        this._child = f;
        if (this._child != null) {
            this._child.setParent(this);
            this._child.repaint();
        }
    }

    protected void swapChild(Figure child, Figure replacement) {
        this._child = replacement;
    }

    public void transform(AffineTransform at) {
        if (this._child != null) {
            this._child.transform(at);
        }
    }
}

