/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasPane;
import diva.canvas.DamageRegion;
import diva.canvas.GraphicsPane;
import diva.canvas.event.LayerEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class JCanvas
extends JComponent {
    private BufferedImage _offscreen = null;
    private CanvasPane _canvasPane = null;
    private boolean _workaroundClearRectBug = this._checkForClearRectBug();

    public JCanvas() {
        this.setCanvasPane(new GraphicsPane());
        this.enableEvents(48L);
    }

    public JCanvas(CanvasPane pane) {
        this.setCanvasPane(pane);
        this.enableEvents(48L);
    }

    public CanvasPane getCanvasPane() {
        return this._canvasPane;
    }

    public void paint(Graphics g) {
        boolean paintAll;
        Rectangle clip = g.getClipBounds();
        Dimension d = this.getSize();
        boolean bl = paintAll = clip.x == 0 && clip.y == 0 && clip.width == d.width && clip.height == d.height;
        if (!this.isDoubleBuffered()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(Color.white);
            if (this._workaroundClearRectBug) {
                g2d.clearRect(0, 0, clip.width, clip.height);
            } else {
                g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
            }
            if (paintAll) {
                this._canvasPane.paint(g2d);
            } else {
                this._canvasPane.paint(g2d, clip);
            }
        } else {
            if (this._offscreen == null || this._offscreen.getWidth() != clip.width || this._offscreen.getHeight() != clip.height) {
                this._offscreen = null;
                this._offscreen = new BufferedImage(clip.width, clip.height, 1);
            }
            Graphics2D g2d = this._offscreen.createGraphics();
            g2d.setBackground(Color.white);
            if (this._workaroundClearRectBug) {
                g2d.clearRect(0, 0, clip.width, clip.height);
            } else {
                g2d.clearRect(clip.x, clip.y, clip.width, clip.height);
            }
            if (paintAll) {
                this._canvasPane.paint(g2d);
            } else {
                g2d.translate(-clip.x, -clip.y);
                this._canvasPane.paint(g2d, clip);
            }
            g.drawImage(this._offscreen, clip.x, clip.y, null);
        }
        super.paint(g);
    }

    public void repaint(DamageRegion d) {
        d.apply(this);
    }

    public void setCanvasPane(CanvasPane pane) {
        if (this._canvasPane != null) {
            this._canvasPane.setCanvas(null);
        }
        this._canvasPane = pane;
        if (pane != null) {
            pane.setCanvas(this);
        }
    }

    public void setDoubleBuffered(boolean flag) {
        super.setDoubleBuffered(flag);
        if (!this.isDoubleBuffered()) {
            this._offscreen = null;
        }
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        if (this._canvasPane != null) {
            Dimension size = this.getSize();
            Point2D.Double s = new Point2D.Double(size.width, size.height);
            this._canvasPane.setSize(s);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        this.internalProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this.internalProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseMotionEvent(e);
        }
    }

    private void internalProcessMouseEvent(MouseEvent e) {
        LayerEvent layerevent = null;
        if (this._canvasPane == null) {
            return;
        }
        layerevent = new LayerEvent(e);
        AffineTransform at = this._canvasPane.getTransformContext().getInverseTransform();
        if (!at.isIdentity()) {
            layerevent.transform(at);
        }
        this._canvasPane.dispatchEvent(layerevent);
    }

    private boolean _checkForClearRectBug() {
        return System.getProperty("java.version").equals("1.2beta4");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._canvasPane.setEnabled(enabled);
    }
}

