/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasLayer;
import diva.canvas.DamageRegion;
import diva.canvas.VisibleComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class OverlayLayer
extends CanvasLayer
implements VisibleComponent {
    private ArrayList _shapes = new ArrayList();
    private Stroke _stroke;
    private Paint _paint;
    private boolean _visible = true;

    public OverlayLayer() {
        this.setStroke(new BasicStroke());
        this.setPaint(Color.lightGray);
    }

    public OverlayLayer(Stroke s, Paint p) {
        this.setStroke(s);
        this.setPaint(p);
    }

    public void add(Shape s) {
        this._shapes.add(s);
    }

    public void clear() {
        this._shapes.clear();
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public Paint getPaint() {
        return this._paint;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        g.setStroke(this._stroke);
        g.setPaint(this._paint);
        Iterator i = this.shapes();
        while (i.hasNext()) {
            Shape s = (Shape)i.next();
            g.draw(s);
        }
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (!this.isVisible()) {
            return;
        }
        g.setStroke(this._stroke);
        g.setPaint(this._paint);
        Iterator i = this.shapes();
        while (i.hasNext()) {
            Shape s = (Shape)i.next();
            if (!s.intersects(region)) continue;
            g.draw(s);
        }
    }

    public void remove(Shape s) {
        this._shapes.remove(s);
    }

    public void repaint(Rectangle2D region) {
        double x = region.getX();
        double y = region.getY();
        double w = region.getWidth();
        double h = region.getHeight();
        float lineWidth = ((BasicStroke)this._stroke).getLineWidth();
        this.repaint(DamageRegion.createDamageRegion(this.getTransformContext(), x - (double)lineWidth, y - (double)lineWidth, w + (double)(2.0f * lineWidth), h + (double)(2.0f * lineWidth)));
    }

    public void repaint(Shape shape) {
        Shape s = this._stroke.createStrokedShape(shape);
        Rectangle bounds = s.getBounds();
        this.repaint(DamageRegion.createDamageRegion(this.getTransformContext(), bounds));
    }

    public Iterator shapes() {
        return this._shapes.iterator();
    }

    public void setStroke(Stroke s) {
        this._stroke = s;
        this.repaint();
    }

    public void setPaint(Paint p) {
        this._paint = p;
        this.repaint();
    }

    public void setVisible(boolean flag) {
        this._visible = flag;
    }
}

