/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractFigure;
import diva.canvas.Site;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorEnd;
import diva.canvas.toolbox.LabelFigure;
import diva.util.java2d.PaintedPath;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class AbstractConnector
extends AbstractFigure
implements Connector {
    private ConnectorEnd _headEnd = null;
    private ConnectorEnd _tailEnd = null;
    private Site _headSite = null;
    private Site _tailSite = null;
    private String _label;
    private LabelFigure _labelFigure;
    private PaintedPath _paintedPath;

    public AbstractConnector(Site tail, Site head) {
        this._tailSite = tail;
        this._headSite = head;
        this._paintedPath = new PaintedPath(null);
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = (Rectangle2D)this._paintedPath.getBounds().clone();
        if (this._headEnd != null) {
            Rectangle2D.union(bounds, this._headEnd.getBounds(), bounds);
        }
        if (this._tailEnd != null) {
            Rectangle2D.union(bounds, this._tailEnd.getBounds(), bounds);
        }
        if (this._labelFigure != null) {
            Rectangle2D.union(bounds, this._labelFigure.getBounds(), bounds);
        }
        return bounds;
    }

    public float[] getDashArray() {
        return this._paintedPath.getDashArray();
    }

    public ConnectorEnd getHeadEnd() {
        return this._headEnd;
    }

    public Site getHeadSite() {
        return this._headSite;
    }

    public String getLabel() {
        return this._label;
    }

    public LabelFigure getLabelFigure() {
        return this._labelFigure;
    }

    public float getLineWidth() {
        return this._paintedPath.getLineWidth();
    }

    protected PaintedPath getPaintedPath() {
        return this._paintedPath;
    }

    public ConnectorEnd getTailEnd() {
        return this._tailEnd;
    }

    public Shape getShape() {
        return this._paintedPath.shape;
    }

    public Stroke getStroke() {
        return this._paintedPath.stroke;
    }

    public Paint getStrokePaint() {
        return this._paintedPath.strokePaint;
    }

    public Site getTailSite() {
        return this._tailSite;
    }

    public void headMoved() {
        this.repaint();
        this.reroute();
        this.repaint();
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        boolean hit = this.intersects(r);
        if (this._labelFigure != null) {
            boolean bl = hit = hit || this._labelFigure.hit(r);
        }
        if (this._headEnd != null) {
            boolean bl = hit = hit || r.intersects(this._headEnd.getBounds());
        }
        if (this._tailEnd != null) {
            hit = hit || r.intersects(this._tailEnd.getBounds());
        }
        return hit;
    }

    public void paint(Graphics2D g) {
        this._paintedPath.paint(g);
        if (this._headEnd != null) {
            this._headEnd.paint(g);
        }
        if (this._tailEnd != null) {
            this._tailEnd.paint(g);
        }
        if (this._labelFigure != null) {
            this._labelFigure.paint(g);
        }
    }

    public abstract void repositionLabel();

    public void reroute() {
        this.repaint();
        this.route();
        this.repaint();
    }

    public abstract void route();

    public void setDashArray(float[] dashArray) {
        this._paintedPath.setDashArray(dashArray);
        this.repaint();
    }

    public void setHeadEnd(ConnectorEnd e) {
        this._headEnd = e;
        this.reroute();
    }

    public void setHeadSite(Site s) {
        this._headSite = s;
        this.headMoved();
    }

    public void setLabel(String label) {
        this._label = label;
        if (this._labelFigure == null) {
            this._labelFigure = new LabelFigure(label);
        } else {
            this._labelFigure.setString(label);
        }
        this.repositionLabel();
    }

    public void setLineWidth(float lineWidth) {
        this.repaint();
        this._paintedPath.setLineWidth(lineWidth);
        this.repaint();
    }

    public void setStroke(Stroke s) {
        this._paintedPath.setStroke(s);
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this._paintedPath.strokePaint = p;
        this.repaint();
    }

    public void setTailEnd(ConnectorEnd e) {
        this._tailEnd = e;
        this.reroute();
    }

    public void setTailSite(Site s) {
        this._tailSite = s;
        this.tailMoved();
    }

    public void tailMoved() {
        this.repaint();
        this.reroute();
        this.repaint();
    }

    public void transform(AffineTransform at) {
    }

    public abstract void translate(double var1, double var3);
}

