/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.connector.ConnectorEnd;
import diva.util.java2d.Polygon2D;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Blob
implements ConnectorEnd {
    public static final int BLOB_CIRCLE = 47;
    public static final int BLOB_DIAMOND = 48;
    private int _style;
    private double _unit = 8.0;
    private boolean _filled = true;
    private double _originX = 0.0;
    private double _originY = 0.0;
    private double _normal = 0.0;
    private Shape _shape = null;
    private boolean _shapeValid = false;
    public Stroke stroke = new BasicStroke(1.5f);

    public Blob() {
        this(0.0, 0.0, 0.0, 47);
    }

    public Blob(int style) {
        this(0.0, 0.0, 0.0, style);
    }

    public Blob(double x, double y, double normal, int style) {
        this._originX = x;
        this._originY = y;
        this._normal = normal;
        this._style = style;
        this.reshape();
    }

    public Rectangle2D getBounds() {
        if (this._filled) {
            return this._shape.getBounds2D();
        }
        Shape s = this.stroke.createStrokedShape(this._shape);
        return s.getBounds2D();
    }

    public void getConnection(Point2D p) {
        if (!this._shapeValid) {
            this.reshape();
        }
        switch (this._style) {
            case 47: {
                p.setLocation(this._originX + 2.0 * this._unit, this._originY);
                break;
            }
            case 48: {
                p.setLocation(this._originX + 3.0 * this._unit, this._originY);
            }
        }
        AffineTransform at = new AffineTransform();
        at.setToRotation(this._normal, this._originX, this._originY);
        at.transform(p, p);
    }

    public void getOrigin(Point2D p) {
        p.setLocation(this._originX, this._originY);
    }

    public double getSizeUnit() {
        return this._unit;
    }

    public int getStyle() {
        return this._style;
    }

    public boolean isFilled() {
        return this._filled;
    }

    public void paint(Graphics2D g) {
        if (!this._shapeValid) {
            this.reshape();
        }
        if (this._filled) {
            g.fill(this._shape);
        } else {
            g.draw(this._shape);
        }
    }

    public void reshape() {
        AffineTransform at = new AffineTransform();
        at.setToRotation(this._normal, this._originX, this._originY);
        switch (this._style) {
            case 47: {
                this._shape = new Ellipse2D.Double(this._originX, this._originY - this._unit, 2.0 * this._unit, 2.0 * this._unit);
                break;
            }
            case 48: {
                Polygon2D.Float polygon = new Polygon2D.Float();
                ((Polygon2D)polygon).moveTo(this._originX, this._originY);
                ((Polygon2D)polygon).lineTo(this._originX + 1.5 * this._unit, this._originY - this._unit);
                ((Polygon2D)polygon).lineTo(this._originX + 3.0 * this._unit, this._originY);
                ((Polygon2D)polygon).lineTo(this._originX + 1.5 * this._unit, this._originY + this._unit);
                ((Polygon2D)polygon).lineTo(this._originX, this._originY);
                polygon.closePath();
                this._shape = polygon;
            }
        }
        this._shape = at.createTransformedShape(this._shape);
    }

    public void setFilled(boolean flag) {
        this._filled = flag;
    }

    public void setNormal(double angle) {
        this._normal = angle;
        this._shapeValid = false;
    }

    public void setOrigin(double x, double y) {
        this.translate(x - this._originX, y - this._originY);
    }

    public void setSizeUnit(double s) {
        this._unit = s;
        this._shapeValid = false;
    }

    public void setStyle(int s) {
        this._style = s;
        this._shapeValid = false;
    }

    public void translate(double x, double y) {
        this._originX += x;
        this._originY += y;
        if (this._shapeValid) {
            if (this._shape instanceof Polygon2D) {
                ((Polygon2D)this._shape).translate(x, y);
            } else {
                AffineTransform at = AffineTransform.getTranslateInstance(x, y);
                this._shape = at.createTransformedShape(this._shape);
            }
        }
    }
}

