/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasPane;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.manipulator.GrabHandle;
import diva.canvas.manipulator.Manipulator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ConnectorInteractor
extends DragInteractor {
    private double _prevX = 0.0;
    private double _prevY = 0.0;
    private Connector _connector = null;
    private GrabHandle _handle = null;
    private ConnectorManipulator _manipulator;
    private Figure _target = null;
    private ArrayList _connectorListeners = new ArrayList();

    public ConnectorInteractor(ConnectorManipulator m) {
        this._manipulator = m;
    }

    public void addConnectorListener(ConnectorListener l) {
        this._connectorListeners.add(l);
    }

    private void attach(Site site) {
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            this._connector.setHeadSite(site);
        } else {
            this._connector.setTailSite(site);
        }
        this._handle.setSite(site);
        this._handle.repaint();
    }

    private void debug(Object o) {
        System.out.println("ConnectorInteractor: " + o);
    }

    private void detach(double x, double y) {
        AutonomousSite newSite = new AutonomousSite(this._connector.getTransformContext(), x, y);
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            this._connector.setHeadSite(newSite);
        } else {
            this._connector.setTailSite(newSite);
        }
        this._handle.setSite(newSite);
        this._handle.repaint();
    }

    private Site findSite(Figure f, double x, double y) {
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            return this._manipulator._connectorTarget.getHeadSite(f, x, y);
        }
        return this._manipulator._connectorTarget.getTailSite(f, x, y);
    }

    private Site findSite(Site s, double x, double y) {
        if (this._handle.getSite() == this._connector.getHeadSite()) {
            return this._manipulator._connectorTarget.getHeadSite(s, x, y);
        }
        return this._manipulator._connectorTarget.getTailSite(s, x, y);
    }

    private void fireConnectorEvent(int id) {
        int end = this._handle.getSite() == this._connector.getHeadSite() ? 21 : 22;
        ConnectorEvent event = new ConnectorEvent(id, this._connector.getLayer(), this._target, this._connector, end);
        Iterator i = this._connectorListeners.iterator();
        while (i.hasNext()) {
            ConnectorListener l = (ConnectorListener)i.next();
            switch (id) {
                case 12: {
                    l.connectorDragged(event);
                    break;
                }
                case 13: {
                    l.connectorDropped(event);
                    break;
                }
                case 14: {
                    l.connectorSnapped(event);
                    break;
                }
                case 15: {
                    l.connectorUnsnapped(event);
                    break;
                }
                case 16: {
                    l.connectorGrabbed(event);
                }
            }
        }
    }

    public Connector getConnector() {
        return this._connector;
    }

    public GrabHandle getHandle() {
        return this._handle;
    }

    public Figure getTarget() {
        return this._target;
    }

    public void mousePressed(LayerEvent event) {
        super.mousePressed(event);
        this.fireConnectorEvent(16);
    }

    public void mouseReleased(LayerEvent event) {
        super.mouseReleased(event);
        this.fireConnectorEvent(13);
    }

    public void removeConnectorListener(ConnectorListener l) {
        this._connectorListeners.remove(l);
    }

    public void setup(LayerEvent e) {
        this._handle = (GrabHandle)e.getFigureSource();
        this._target = this._handle.getSite().getFigure();
        this._connector = (Connector)((Manipulator)this._handle.getParent()).getChild();
    }

    public void translate(LayerEvent e, double dx, double dy) {
        double x = e.getLayerX();
        double y = e.getLayerY();
        double h = this._manipulator.getSnapHalo();
        Rectangle2D.Double mouseRect = new Rectangle2D.Double(x - h, y - h, 2.0 * h, 2.0 * h);
        if (this._target != null) {
            if (this._target.intersects(mouseRect)) {
                Site current = this._handle.getSite();
                Site snap = this.findSite(current, x, y);
                if (snap != null && snap != current) {
                    this.attach(snap);
                    this.fireConnectorEvent(14);
                }
            } else {
                this.detach(x, y);
                this.fireConnectorEvent(15);
                this._target = null;
            }
        } else {
            CanvasComponent component = this._connector.getTransformContext().getComponent();
            FigureContainer container = component instanceof CanvasPane ? (FigureContainer)((Object)this._connector.getLayer()) : (FigureContainer)component;
            Iterator i = container.figuresFromFront();
            while (i.hasNext()) {
                Site snap;
                Figure t = (Figure)i.next();
                if (t instanceof ConnectorManipulator) continue;
                if (t instanceof FigureDecorator) {
                    t = ((FigureDecorator)t).getDecoratedFigure();
                }
                if (!t.hit(mouseRect) || t.getInteractor() == null || (snap = this.findSite(t, x, y)) == null) continue;
                this._target = t;
                this.attach(snap);
                this.fireConnectorEvent(14);
                break;
            }
            if (this._target == null) {
                this._handle.getSite().translate(dx, dy);
                this._connector.reroute();
                this.fireConnectorEvent(12);
            }
        }
    }
}

