/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.event;

import diva.canvas.CanvasLayer;
import diva.canvas.event.EventAcceptor;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerEventMulticaster;
import diva.canvas.event.LayerListener;
import diva.canvas.event.LayerMotionListener;
import diva.canvas.interactor.Interactor;
import java.awt.AWTEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class EventLayer
extends CanvasLayer
implements EventAcceptor {
    private boolean _enabled = true;
    private boolean _consuming = true;
    private Interactor _currentInteractor;
    private ArrayList _interactors = new ArrayList();
    private transient LayerListener layerListener = null;
    private transient LayerMotionListener layerMotionListener = null;

    public void addInteractor(Interactor i) {
        this._interactors.add(i);
    }

    public void addLayerListener(LayerListener l) {
        this.layerListener = LayerEventMulticaster.add(this.layerListener, l);
    }

    public void addLayerMotionListener(LayerMotionListener l) {
        this.layerMotionListener = LayerEventMulticaster.add(this.layerMotionListener, l);
    }

    public void dispatchEvent(AWTEvent event) {
        if (event instanceof LayerEvent) {
            this.processLayerEvent((LayerEvent)event);
        } else {
            System.out.println("Bad event: " + event);
        }
    }

    public Iterator interactors() {
        return this._interactors.iterator();
    }

    public boolean isConsuming() {
        return this._consuming;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    protected void processLayerEvent(LayerEvent event) {
        int id;
        if (!this.isEnabled()) {
            return;
        }
        if (this.layerListener != null) {
            id = event.getID();
            switch (id) {
                case 501: {
                    this.layerListener.mousePressed(event);
                    break;
                }
                case 506: {
                    this.layerListener.mouseDragged(event);
                    break;
                }
                case 502: {
                    this.layerListener.mouseReleased(event);
                }
            }
        }
        if (this.layerMotionListener != null) {
            id = event.getID();
            switch (id) {
                case 503: {
                    this.layerMotionListener.mouseMoved(event);
                    break;
                }
                case 505: {
                    this.layerMotionListener.mouseExited(event);
                    break;
                }
                case 504: {
                    this.layerMotionListener.mouseEntered(event);
                }
            }
        }
        Iterator i = this._interactors.iterator();
        while (i.hasNext()) {
            int id2 = event.getID();
            Interactor interactor = (Interactor)i.next();
            switch (id2) {
                case 501: {
                    if (interactor.accept(event)) {
                        this._currentInteractor = interactor;
                        this._currentInteractor.mousePressed(event);
                        break;
                    }
                    this._currentInteractor = null;
                    break;
                }
                case 506: {
                    if (this._currentInteractor == null) break;
                    this._currentInteractor.mouseDragged(event);
                    break;
                }
                case 502: {
                    if (this._currentInteractor != null) {
                        this._currentInteractor.mouseDragged(event);
                    }
                    this._currentInteractor = null;
                    break;
                }
                case 503: {
                    if (!interactor.accept(event)) break;
                    interactor.mouseMoved(event);
                }
            }
        }
    }

    public void removeInteractor(Interactor i) {
        this._interactors.remove(i);
    }

    public void removeLayerListener(LayerListener l) {
        this.layerListener = LayerEventMulticaster.remove(this.layerListener, l);
    }

    public void removeLayerMotionListener(LayerMotionListener l) {
        this.layerMotionListener = LayerEventMulticaster.remove(this.layerMotionListener, l);
    }

    public void setConsuming(boolean flag) {
        this._consuming = flag;
    }

    public void setEnabled(boolean flag) {
        this._enabled = flag;
    }
}

