/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.selection;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.manipulator.Manipulator;
import diva.canvas.selection.BasicSelectionModel;
import diva.canvas.selection.BasicSelectionRenderer;
import diva.canvas.selection.SelectionModel;
import diva.canvas.selection.SelectionRenderer;
import java.util.Iterator;

public class SelectionInteractor
extends CompositeInteractor {
    public static final int ONE_SELECTED = 4;
    public static final int MANY_SELECTED = 8;
    public static final int NEWLY_SELECTED = 16;
    public static final int ALREADY_SELECTED = 32;
    public static final int SELECTED = 64;
    private int _state;
    private SelectionModel _selection;
    private SelectionRenderer _renderer;
    private MouseFilter _selectionFilter = MouseFilter.selectionFilter;
    private MouseFilter _toggleFilter = MouseFilter.alternateSelectionFilter;

    public SelectionInteractor() {
        this.setSelectionRenderer(new BasicSelectionRenderer());
        this.setSelectionModel(new BasicSelectionModel());
    }

    public SelectionInteractor(SelectionModel model) {
        this.setSelectionRenderer(new BasicSelectionRenderer());
        this.setSelectionModel(model);
    }

    public boolean accept(LayerEvent e) {
        return this._selectionFilter.accept(e) || this._toggleFilter.accept(e) || super.accept(e);
    }

    public MouseFilter getSelectionFilter() {
        return this._selectionFilter;
    }

    public SelectionModel getSelectionModel() {
        return this._selection;
    }

    public SelectionRenderer getSelectionRenderer() {
        return this._renderer;
    }

    public MouseFilter getToggleFilter() {
        return this._toggleFilter;
    }

    public void mousePressed(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Figure figure = event.getFigureSource();
        int _state = 0;
        if (this._selection.getSelectionCount() == 1) {
            _state = 4;
        } else if (this._selection.getSelectionCount() > 1) {
            _state = 8;
        }
        if (_state != 0) {
            _state = this._selection.containsSelection(figure) ? (_state |= 0x20) : (_state |= 0x10);
        }
        boolean isSelected = false;
        if (this._selectionFilter.accept(event)) {
            if (!this._selection.containsSelection(figure)) {
                this._selection.clearSelection();
                this._selection.addSelection(figure);
            }
            isSelected = true;
        } else if (this._toggleFilter.accept(event)) {
            if (this._selection.containsSelection(figure)) {
                this._selection.removeSelection(figure);
            } else {
                this._selection.addSelection(figure);
                isSelected = true;
            }
        }
        if (this._selection.getSelectionCount() > 0 && this._selection.containsSelection(figure)) {
            Object[] target = this._selection.getSelectionAsArray();
            Iterator i = this.interactors();
            while (i.hasNext()) {
                Interactor interactor = (Interactor)i.next();
                if (!(interactor instanceof DragInteractor)) continue;
                ((DragInteractor)interactor).setTargetArray(target);
            }
        }
        super.mousePressed(event);
    }

    public void setSelectionModel(SelectionModel model) {
        if (this._selection != null) {
            this._selection.clearSelection();
        }
        this._selection = model;
    }

    public void setSelectionFilter(MouseFilter f) {
        this._selectionFilter = f;
    }

    public void setPrototypeDecorator(FigureDecorator decorator) {
        this._renderer = new BasicSelectionRenderer(decorator);
    }

    public void setSelectionManipulator(Manipulator manipulator) {
        this._renderer = new BasicSelectionRenderer(manipulator);
    }

    public void setSelectionRenderer(SelectionRenderer r) {
        this._renderer = r;
    }

    public void setToggleFilter(MouseFilter f) {
        this._toggleFilter = f;
    }
}

