/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.manipulator.ShapedFigure;
import diva.util.java2d.PaintedShape;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class BasicFigure
extends AbstractFigure
implements ShapedFigure {
    private Composite _composite = AlphaComposite.SrcOver;
    private PaintedShape _paintedShape;

    public BasicFigure(Shape shape) {
        this._paintedShape = new PaintedShape(shape);
    }

    public BasicFigure(Shape shape, float lineWidth) {
        this._paintedShape = new PaintedShape(shape, null, lineWidth);
    }

    public BasicFigure(Shape shape, Paint fill) {
        this._paintedShape = new PaintedShape(shape, fill);
    }

    public BasicFigure(Shape shape, Paint fill, float lineWidth) {
        this._paintedShape = new PaintedShape(shape, fill, lineWidth);
    }

    public Rectangle2D getBounds() {
        return this._paintedShape.getBounds();
    }

    public Composite getComposite() {
        return this._composite;
    }

    public Paint getFillPaint() {
        return this._paintedShape.fillPaint;
    }

    public float getLineWidth() {
        return this._paintedShape.getLineWidth();
    }

    public Shape getShape() {
        return this._paintedShape.shape;
    }

    public Stroke getStroke() {
        return this._paintedShape.getStroke();
    }

    public Paint getStrokePaint() {
        return this._paintedShape.strokePaint;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        return this._paintedShape.hit(r);
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._composite != null) {
            g.setComposite(this._composite);
        }
        this._paintedShape.paint(g);
    }

    public void setComposite(Composite c) {
        this._composite = c;
        this.repaint();
    }

    public void setFillPaint(Paint p) {
        this._paintedShape.fillPaint = p;
        this.repaint();
    }

    public void setLineWidth(float lineWidth) {
        this.repaint();
        this._paintedShape.setLineWidth(lineWidth);
        this.repaint();
    }

    public void setShape(Shape s) {
        this.repaint();
        this._paintedShape.shape = s;
        this.repaint();
    }

    public void setStroke(BasicStroke s) {
        this.repaint();
        this._paintedShape.stroke = s;
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this._paintedShape.strokePaint = p;
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._paintedShape.shape = CanvasUtilities.transform(this._paintedShape.shape, at);
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._paintedShape.shape = CanvasUtilities.translate(this._paintedShape.shape, x, y);
        this.repaint();
    }
}

