/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class BasicHighlighter
extends FigureDecorator {
    private Composite _composite = null;
    private float _halo;
    private Paint _paint;

    public BasicHighlighter() {
        this._paint = Color.yellow;
        this._halo = 4.0f;
    }

    public BasicHighlighter(Paint paint, float halo) {
        this._paint = paint;
        this._halo = halo;
    }

    public BasicHighlighter(Paint paint, float halo, Composite composite) {
        this._paint = paint;
        this._halo = halo;
        this._composite = composite;
    }

    public Composite getComposite() {
        return this._composite;
    }

    public Rectangle2D getBounds() {
        Rectangle2D b = this.getChild().getBounds();
        Rectangle2D.Double bounds = new Rectangle2D.Double(b.getX() - (double)this._halo, b.getY() - (double)this._halo, b.getWidth() + (double)(2.0f * this._halo), b.getHeight() + (double)(2.0f * this._halo));
        return bounds;
    }

    public float getHalo() {
        return this._halo;
    }

    public Paint getPaint() {
        return this._paint;
    }

    public boolean hit(Rectangle2D region) {
        return false;
    }

    public FigureDecorator newInstance(Figure f) {
        return new BasicHighlighter(this._paint, this._halo, this._composite);
    }

    public void paint(Graphics2D g) {
        if (this._composite != null) {
            g.setComposite(this._composite);
        }
        g.setPaint(this._paint);
        Rectangle2D bounds = this.getChild().getBounds();
        double x = bounds.getX() - (double)this._halo;
        double y = bounds.getY() - (double)this._halo;
        double w = bounds.getWidth() + (double)(2.0f * this._halo);
        double h = bounds.getHeight() + (double)(2.0f * this._halo);
        g.fill(new Rectangle2D.Double(x, y, w, h));
        this.getChild().paint(g);
    }

    public void repaint(DamageRegion d) {
        this.repaint();
    }

    public void repaint() {
        Rectangle2D bounds = this.getChild().getBounds();
        double x = bounds.getX() - (double)this._halo;
        double y = bounds.getY() - (double)this._halo;
        double w = bounds.getWidth() + (double)(2.0f * this._halo);
        double h = bounds.getHeight() + (double)(2.0f * this._halo);
        this.getParent().repaint(DamageRegion.createDamageRegion(this.getTransformContext(), x, y, w, h));
    }
}

