/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.util.java2d.PaintedObject;
import diva.util.java2d.PaintedPath;
import diva.util.java2d.PaintedShape;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class GraphicsParser {
    public static PaintedObject createPaintedObject(String type, String attributes) {
        HashMap hm = new HashMap();
        GraphicsParser.hashAttributes(attributes, hm);
        return GraphicsParser.createPaintedObject(type, hm);
    }

    public static PaintedObject createPaintedObject(String type, HashMap attributes) {
        double[] coords = GraphicsParser.parseCoordString((String)attributes.get("coords"));
        if (type.equals("rectangle")) {
            PaintedShape ps = new PaintedShape(new Rectangle2D.Double(coords[0], coords[1], coords[2], coords[3]));
            GraphicsParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("ellipse")) {
            PaintedShape ps = new PaintedShape(new Ellipse2D.Double(coords[0], coords[1], coords[2], coords[3]));
            GraphicsParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("polygon")) {
            Polygon2D.Double poly = new Polygon2D.Double();
            ((Polygon2D)poly).moveTo(coords[0], coords[1]);
            for (int i = 2; i < coords.length; i += 2) {
                ((Polygon2D)poly).lineTo(coords[i], coords[i + 1]);
            }
            poly.closePath();
            PaintedShape ps = new PaintedShape(poly);
            GraphicsParser.processPaintedShapeAttributes(ps, attributes);
            return ps;
        }
        if (type.equals("line")) {
            Shape s;
            if (coords.length == 4) {
                s = new Line2D.Double(coords[0], coords[1], coords[2], coords[3]);
            } else {
                Polyline2D.Double poly = new Polyline2D.Double();
                ((Polyline2D)poly).moveTo(coords[0], coords[1]);
                for (int i = 2; i < coords.length; i += 2) {
                    ((Polyline2D)poly).lineTo(coords[i], coords[i + 1]);
                }
                s = poly;
            }
            PaintedPath pp = new PaintedPath(s);
            GraphicsParser.processPaintedPathAttributes(pp, attributes);
            return pp;
        }
        return null;
    }

    public static void hashAttributes(String s, Map map) {
        StreamTokenizer t = new StreamTokenizer(new StringReader(s));
        t.whitespaceChars(61, 61);
        t.ordinaryChars(48, 57);
        t.ordinaryChar(46);
        String key = "Unknown";
        String val = "Unknown";
        while (true) {
            int ttype = 0;
            try {
                ttype = t.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ttype == -1) break;
            switch (ttype) {
                case -3: {
                    key = t.sval;
                }
            }
            try {
                ttype = t.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ttype == -1) break;
            switch (ttype) {
                case -3: {
                    val = t.sval;
                }
            }
            map.put(key, val);
        }
    }

    private static Color lookupColor(String s) {
        if (s.equals("red")) {
            return Color.red;
        }
        if (s.equals("blue")) {
            return Color.blue;
        }
        if (s.equals("green")) {
            return Color.green;
        }
        if (s.equals("yellow")) {
            return Color.yellow;
        }
        if (s.equals("magenta")) {
            return Color.magenta;
        }
        if (s.equals("black")) {
            return Color.black;
        }
        return Color.black;
    }

    private static double[] parseCoordString(String s) {
        double[] temp;
        double[] result = new double[4];
        int i = 0;
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            result[i++] = Double.parseDouble(t.nextToken());
            if (i != result.length) continue;
            temp = new double[2 * result.length];
            System.arraycopy(result, 0, temp, 0, result.length);
            result = temp;
        }
        temp = new double[i];
        System.arraycopy(result, 0, temp, 0, i);
        result = temp;
        return result;
    }

    private static void processPaintedShapeAttributes(PaintedShape ps, Map attributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = (String)attributes.get(key);
            if (key.equals("fill")) {
                ps.fillPaint = GraphicsParser.lookupColor(val);
                continue;
            }
            if (key.equals("outline")) {
                ps.strokePaint = GraphicsParser.lookupColor(val);
                continue;
            }
            if (!key.equals("width")) continue;
            ps.setLineWidth(Float.parseFloat(val));
        }
    }

    private static void processPaintedPathAttributes(PaintedPath pp, Map attributes) {
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String val = (String)attributes.get(key);
            if (key.equals("fill")) {
                pp.strokePaint = GraphicsParser.lookupColor(val);
                continue;
            }
            if (!key.equals("width")) continue;
            pp.setLineWidth(Float.parseFloat(val));
        }
    }
}

