/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import diva.canvas.manipulator.ShapedFigure;
import diva.util.java2d.PaintedPath;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class PathFigure
extends AbstractFigure
implements ShapedFigure {
    private Composite _composite = AlphaComposite.SrcOver;
    private PaintedPath _paintedPath;

    public PathFigure(Shape shape) {
        this._paintedPath = new PaintedPath(shape);
    }

    public PathFigure(Shape shape, float lineWidth) {
        this._paintedPath = new PaintedPath(shape, lineWidth);
    }

    public PathFigure(Shape shape, Paint paint, float lineWidth) {
        this._paintedPath = new PaintedPath(shape, lineWidth);
        this._paintedPath.strokePaint = paint;
    }

    public Rectangle2D getBounds() {
        return this._paintedPath.getBounds();
    }

    public Composite getComposite() {
        return this._composite;
    }

    public float getLineWidth() {
        return this._paintedPath.getLineWidth();
    }

    public Shape getShape() {
        return this._paintedPath.shape;
    }

    public Stroke getStroke() {
        return this._paintedPath.getStroke();
    }

    public Paint getStrokePaint() {
        return this._paintedPath.strokePaint;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        return this._paintedPath.hit(r);
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        if (this._composite != null) {
            g.setComposite(this._composite);
        }
        this._paintedPath.paint(g);
    }

    public void setComposite(Composite c) {
        this._composite = c;
        this.repaint();
    }

    public void setLineWidth(float lineWidth) {
        this.repaint();
        this._paintedPath.setLineWidth(lineWidth);
        this.repaint();
    }

    public void setShape(Shape s) {
        this.repaint();
        this._paintedPath.shape = s;
        this.repaint();
    }

    public void setStroke(BasicStroke s) {
        this.repaint();
        this._paintedPath.stroke = s;
        this.repaint();
    }

    public void setStrokePaint(Paint p) {
        this._paintedPath.strokePaint = p;
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._paintedPath.shape = CanvasUtilities.transform(this._paintedPath.shape, at);
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._paintedPath.shape = CanvasUtilities.translate(this._paintedPath.shape, x, y);
        this.repaint();
    }
}

