/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.CanvasUtilities;
import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.GraphicsPane;
import diva.canvas.ZList;
import diva.canvas.connector.Connector;
import diva.graph.BasicEdgeRenderer;
import diva.graph.BasicNodeRenderer;
import diva.graph.CompositeNodeFigure;
import diva.graph.EdgeRenderer;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.graph.NodeRenderer;
import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.RandomIncrLayout;
import diva.graph.model.CompositeNode;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphModel;
import diva.graph.model.GraphUtilities;
import diva.graph.model.Node;
import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.ProxyIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GraphView
implements LayoutTarget {
    protected HashMap _viewMapping = new HashMap();
    private GraphModel _model;
    private EdgeRenderer _edgeRenderer = new BasicEdgeRenderer();
    private NodeRenderer _nodeRenderer = new BasicNodeRenderer();
    private GraphController _controller;
    private GraphicsPane _pane;
    private double _layoutPercentage = 0.8;
    private IncrementalLayout _incrLayout = new RandomIncrLayout(this);

    public void addEdgeFigureToLayer(Figure f) {
        this._pane.getForegroundLayer().add(f);
        ZList zl = this._pane.getForegroundLayer().getFigures();
        zl.setIndex(0, f);
        f.repaint();
    }

    public void addEdgeMapping(Edge e, Connector ef) {
        if (this._viewMapping.containsKey(e)) {
            if (this._viewMapping.get(e) != ef) {
                throw new IllegalStateException("Edge " + e + "does not map to figure " + ef);
            }
            ef.setUserObject(e);
        } else {
            ef.setUserObject(e);
            this._viewMapping.put(e, ef);
        }
    }

    public void addNodeFigureToLayer(Figure nf) {
        this._pane.getForegroundLayer().add(nf);
    }

    protected void addNodeFigureToParent(Figure nf) {
        Node n = (Node)nf.getUserObject();
        CompositeNode cn = (CompositeNode)n.getParent();
        CompositeFigure cnf = (CompositeFigure)this.getNodeFigure(cn);
        cnf.add(nf);
        try {
            nf.transform(cnf.getTransformContext().getTransform().createInverse());
        }
        catch (Exception e) {
            this.debug("error: " + e);
            System.exit(-1);
        }
    }

    public void addNodeMapping(Node n, Figure nf) {
        if (this._viewMapping.containsKey(n)) {
            if (this._viewMapping.get(n) != nf) {
                throw new IllegalStateException("Node " + n + "does not map to figure " + nf);
            }
            nf.setUserObject(n);
        } else {
            nf.setUserObject(n);
            this._viewMapping.put(n, nf);
        }
    }

    public void clear() {
        Iterator i = this._viewMapping.values().iterator();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            this._pane.getForegroundLayer().remove(f);
        }
        this._viewMapping.clear();
    }

    private void debug(String s) {
        System.err.println("GraphView: " + s);
    }

    public Rectangle2D getBounds(Node n) {
        Figure f = this.getNodeFigure(n);
        return f.getBounds();
    }

    public Connector getEdgeFigure(Edge e) {
        return (Connector)this._viewMapping.get(e);
    }

    public EdgeRenderer getEdgeRenderer() {
        return this._edgeRenderer;
    }

    public GraphController getGraphController() {
        return this._controller;
    }

    public GraphModel getGraphModel() {
        return this._model;
    }

    public GraphicsPane getGraphicsPane() {
        return this._pane;
    }

    public IncrementalLayout getIncrLayout() {
        return this._incrLayout;
    }

    public double getLayoutPercentage() {
        return this._layoutPercentage;
    }

    public Figure getNodeFigure(Node n) {
        return (Figure)this._viewMapping.get(n);
    }

    public NodeRenderer getNodeRenderer() {
        return this._nodeRenderer;
    }

    public Rectangle2D getViewport(Graph g) {
        CompositeNode n;
        CompositeNodeFigure f;
        if (g == this._model.getGraph()) {
            Point2D p = this._pane.getSize();
            double borderPercentage = (1.0 - this.getLayoutPercentage()) / 2.0;
            double x = borderPercentage * p.getX();
            double y = borderPercentage * p.getY();
            double w = this.getLayoutPercentage() * p.getX();
            double h = this.getLayoutPercentage() * p.getY();
            return new Rectangle2D.Double(x, y, w, h);
        }
        if (g instanceof CompositeNode && (f = (CompositeNodeFigure)this.getNodeFigure(n = (CompositeNode)g)) != null) {
            Rectangle2D r = f.getBackgroundFigure().getBounds();
            return new Rectangle2D.Double(0.0, 0.0, r.getWidth(), r.getHeight());
        }
        throw new IllegalArgumentException("Unknown graph.  Cannot determine viewport.");
    }

    public Iterator recursivelyIntersectingNodes(Rectangle2D r) {
        ZList zl = this._pane.getForegroundLayer().getFigures();
        ArrayList results = new ArrayList();
        this.recursiveIntersectSub(results, zl, r);
        return results.iterator();
    }

    private void recursiveIntersectSub(List results, ZList zl, Rectangle2D r) {
        Iterator i = zl.getIntersectedFigures(r).figuresFromFront();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            Object o = f.getUserObject();
            if (o instanceof Node) {
                results.add(o);
            }
            if (!(f instanceof CompositeFigure)) continue;
            CompositeFigure cf = (CompositeFigure)f;
            AffineTransform at = cf.getTransformContext().getTransform();
            try {
                at = at.createInverse();
            }
            catch (NoninvertibleTransformException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            Rectangle2D r2 = (Rectangle2D)r.clone();
            r2 = CanvasUtilities.transform(r2, at).getBounds();
            this.recursiveIntersectSub(results, cf.getChildren(), r2);
        }
    }

    public Iterator intersectingNodes(Rectangle2D r) {
        ZList zlist = this._pane.getForegroundLayer().getFigures();
        Iterator i = zlist.getIntersectedFigures(r).figuresFromFront();
        FilteredIterator j = new FilteredIterator(i, new Filter(){

            public boolean accept(Object o) {
                Figure f = (Figure)o;
                return f.getUserObject() instanceof Node;
            }
        });
        return new ProxyIterator(j){

            public Object next() {
                Figure nf = (Figure)super.next();
                return (Node)nf.getUserObject();
            }
        };
    }

    public Iterator intersectingEdges(Rectangle2D r) {
        ZList zlist = this._pane.getForegroundLayer().getFigures();
        Iterator i = zlist.getIntersectedFigures(r).figuresFromFront();
        FilteredIterator j = new FilteredIterator(i, new Filter(){

            public boolean accept(Object o) {
                return o instanceof Connector;
            }
        });
        return new ProxyIterator(j){

            public Object next() {
                Connector ef = (Connector)super.next();
                return (Edge)ef.getUserObject();
            }
        };
    }

    public boolean isNodeVisible(Node n) {
        Figure nf = this.getNodeFigure(n);
        return nf != null && nf.isVisible() && nf.getParent() != null;
    }

    public boolean isEdgeVisible(Edge e) {
        Connector ef = this.getEdgeFigure(e);
        return ef != null && ef.isVisible() && ef.getParent() != null;
    }

    public void placeNodeFigure(Figure nf, double x, double y) {
        Rectangle2D bounds = nf.getBounds();
        double xdash = x - bounds.getWidth() / 2.0;
        double ydash = y - bounds.getHeight() / 2.0;
        nf.translate(xdash - bounds.getX(), ydash - bounds.getY());
    }

    public void removeEdgeFigure(Connector ef) {
        this._model.disconnectEdge((Edge)ef.getUserObject());
    }

    public void removeEdgeMapping(Edge e, Figure ef) {
        if (!this._viewMapping.containsKey(e)) {
            throw new IllegalStateException("Edge " + e + "does not map to any figure");
        }
        if (this._viewMapping.get(e) != ef) {
            throw new IllegalArgumentException("Edge " + e + "does not map to figure " + ef);
        }
        ef.setUserObject(null);
        this._viewMapping.remove(e);
    }

    public void removeNodeFigure(Figure nf) {
        GraphUtilities.purgeNode(this._model.getGraphImpl(), (Node)nf.getUserObject());
    }

    public void removeNodeMapping(Node n, Figure nf) {
        if (!this._viewMapping.containsKey(n)) {
            throw new IllegalStateException("Node " + n + "does not map to any figure");
        }
        if (this._viewMapping.get(n) != nf) {
            throw new IllegalArgumentException("Node " + n + "does not map to figure " + nf);
        }
        nf.setUserObject(null);
        this._viewMapping.remove(n);
    }

    public void route(Edge e) {
        Connector ef = this.getEdgeFigure(e);
        ef.route();
    }

    public void setGraphController(GraphController c) {
        this._controller = c;
    }

    public void setGraphModel(GraphModel model) {
        this._model = model;
    }

    public final void setGraphPane(GraphPane pane) {
        this._pane = pane;
    }

    public void setEdgeRenderer(EdgeRenderer er) {
        this._edgeRenderer = er;
    }

    public void setNodeRenderer(NodeRenderer nr) {
        this._nodeRenderer = nr;
    }

    public void setIncrLayout(IncrementalLayout l) {
        this._incrLayout = l;
    }

    public void setLayoutPercentage(double d) {
        if (d <= 0.0 || d > 1.0) {
            String err = "Layout percentage must be between 0 and 1";
            throw new IllegalArgumentException(err);
        }
        this._layoutPercentage = d;
    }

    public void translate(Node n, double dx, double dy) {
        Figure nf = this.getNodeFigure(n);
        nf.translate(dx, dy);
    }
}

