/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.canvas.connector.Connector;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.graph.GraphController;
import diva.graph.GraphView;
import diva.graph.model.CompositeNode;
import diva.graph.model.Edge;
import diva.graph.model.Node;
import java.util.Iterator;

public class NodeDragInteractor
extends DragInteractor {
    private GraphController _controller;

    public NodeDragInteractor(GraphController c) {
        this._controller = c;
    }

    public void translate(LayerEvent e, double x, double y) {
        Iterator i = this.targets();
        while (i.hasNext()) {
            Figure t = (Figure)i.next();
            if (!(t.getUserObject() instanceof Edge)) {
                t.translate(x, y);
            }
            if (!(t.getUserObject() instanceof Node)) continue;
            this.routeNode((Node)t.getUserObject());
        }
    }

    private void routeNode(Node n) {
        Connector c;
        GraphView v = this._controller.getGraphView();
        Iterator ins = n.inEdges();
        while (ins.hasNext()) {
            c = v.getEdgeFigure((Edge)ins.next());
            if (c == null) continue;
            c.reroute();
        }
        Iterator outs = n.outEdges();
        while (outs.hasNext()) {
            c = v.getEdgeFigure((Edge)outs.next());
            if (c == null) continue;
            c.reroute();
        }
        if (n instanceof CompositeNode) {
            this.routeRecursive((CompositeNode)n);
        }
    }

    private void routeRecursive(CompositeNode cn) {
        Iterator i = cn.nodes();
        while (i.hasNext()) {
            this.routeNode((Node)i.next());
        }
    }
}

