/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.layout.RandomLayout;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphAdapter;
import diva.graph.model.GraphEvent;
import diva.graph.model.Node;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RandomIncrLayout
extends GraphAdapter
implements IncrementalLayout {
    private RandomLayout _global = new RandomLayout();
    private LayoutTarget _target;
    private static final int NUM_ITER = 10;

    public RandomIncrLayout(LayoutTarget target) {
        this._target = target;
    }

    private void debug(String s) {
        System.out.println("RandomIncrLayout: " + s);
    }

    public void nodeAdded(GraphEvent evt) {
        Node n = (Node)evt.getTarget();
        if (this._target.isNodeVisible(n)) {
            Rectangle2D vp = this._target.getViewport(n.getParent());
            Rectangle2D bounds = this._target.getBounds(n);
            for (int i = 0; i < 10; ++i) {
                double x = vp.getX() + Math.abs(Math.random()) * vp.getWidth();
                double y = vp.getY() + Math.abs(Math.random()) * vp.getHeight();
                LayoutUtilities.place(this._target, n, x, y);
                bounds = this._target.getBounds(n);
                boolean overlap = false;
                Iterator j = this._target.intersectingNodes(bounds);
                while (j.hasNext()) {
                    Node n2 = (Node)j.next();
                    if (n == n2) continue;
                    overlap = false;
                }
                if (!overlap) break;
            }
        }
    }

    public void edgeHeadChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        if (this._target.isEdgeVisible(e)) {
            this._target.route(e);
        }
    }

    public void edgeTailChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        if (this._target.isEdgeVisible(e)) {
            this._target.route(e);
        }
    }

    public void structureChanged(GraphEvent evt) {
        Graph g = (Graph)evt.getTarget();
        this._global.layout(this._target, g);
    }
}

