/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.BasicNode;
import diva.graph.model.Edge;
import diva.graph.model.Node;
import diva.util.BasicPropertyContainer;
import java.io.Serializable;

public class BasicEdge
extends BasicPropertyContainer
implements Edge,
Serializable {
    private BasicNode _head = null;
    private Object _semanticObject = null;
    private BasicNode _tail = null;
    private boolean _directed = true;
    private double _weight = 1.0;

    public BasicEdge() {
        this((Object)null);
    }

    public BasicEdge(Object userObject) {
        this(userObject, null, null);
    }

    public BasicEdge(BasicNode tail, BasicNode head) {
        this(null, tail, head);
    }

    public BasicEdge(Object userObject, BasicNode tail, BasicNode head) {
        this.setSemanticObject(userObject);
        this.attach(tail, head);
    }

    public void attach(BasicNode tail, BasicNode head) {
        this.setTail(tail);
        this.setHead(head);
    }

    public void detach() {
        this.setTail(null);
        this.setHead(null);
    }

    public Node getHead() {
        return this._head;
    }

    public Node getTail() {
        return this._tail;
    }

    public double getWeight() {
        return this._weight;
    }

    public Object getSemanticObject() {
        return this._semanticObject;
    }

    public boolean isDirected() {
        return this._directed;
    }

    public void setDirected(boolean val) {
        this._directed = val;
    }

    public void setHead(BasicNode n) {
        BasicNode prevHead = (BasicNode)this.getHead();
        if (prevHead != null) {
            prevHead.getInEdgeSet().remove(this);
        }
        this._head = n;
        if (this._head != null) {
            this._head.getInEdgeSet().add(this);
        }
    }

    public void setTail(BasicNode n) {
        BasicNode prevTail = (BasicNode)this.getTail();
        if (prevTail != null) {
            prevTail.getOutEdgeSet().remove(this);
        }
        this._tail = n;
        if (this._tail != null) {
            this._tail.getOutEdgeSet().add(this);
        }
    }

    public void setWeight(double weight) {
        this._weight = weight;
    }

    public void setSemanticObject(Object o) {
        this._semanticObject = o;
    }

    public String toString() {
        Object o = this.getSemanticObject();
        if (o != null) {
            return "BasicEdge[" + o.toString() + "]";
        }
        return super.toString();
    }
}

