/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.BasicNode;
import diva.graph.model.IndexedGraph;
import diva.graph.model.Node;
import diva.util.BasicPropertyContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class BasicGraph
extends BasicPropertyContainer
implements IndexedGraph,
Serializable {
    private Object _semanticObject = null;
    private ArrayList _nodes;

    public BasicGraph() {
        this((Object)null);
    }

    public BasicGraph(Object userObject) {
        this.setSemanticObject(userObject);
        this._nodes = new ArrayList();
    }

    public BasicGraph(int n) {
        this((Object)null);
        this._nodes = new ArrayList(n);
    }

    public void add(BasicNode n) {
        this._nodes.add(n);
        n.setParent(this);
    }

    public boolean contains(Node n) {
        return this._nodes.contains(n);
    }

    public void clear() {
        while (this.getNodeCount() > 0) {
            BasicNode n = (BasicNode)this.getNode(0);
            this.delete(n);
        }
    }

    public void delete(BasicNode n) {
        n.getInEdgeSet().clear();
        n.getOutEdgeSet().clear();
        this.remove(n);
    }

    public int getNodeCount() {
        return this._nodes.size();
    }

    public Node getNode(int i) {
        return (Node)this._nodes.get(i);
    }

    public int getIndex(Node n) {
        return this._nodes.indexOf(n);
    }

    public Object getSemanticObject() {
        return this._semanticObject;
    }

    public Iterator nodes() {
        return this._nodes.iterator();
    }

    public void remove(BasicNode n) {
        int index = this._nodes.indexOf(n);
        this._nodes.remove(index);
    }

    public void removeAll() {
        this._nodes.clear();
    }

    public void setSemanticObject(Object o) {
        this._semanticObject = o;
    }

    public String toString() {
        Object o = this.getSemanticObject();
        if (o != null) {
            return "BasicGraph[" + o.toString() + "]";
        }
        return super.toString();
    }
}

