/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphImpl;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;
import diva.util.Filter;
import diva.util.FilteredIterator;
import diva.util.IteratorAdapter;
import diva.util.ProxyIterator;
import java.util.Iterator;

public final class GraphUtilities {
    private GraphUtilities() {
    }

    public static final Iterator inNodes(Node n) {
        return new ProxyIterator(n.inEdges()){

            public Object next() {
                Edge e = (Edge)super.next();
                return e.getTail();
            }
        };
    }

    public static final Iterator outNodes(Node n) {
        return new ProxyIterator(n.outEdges()){

            public Object next() {
                Edge e = (Edge)super.next();
                return e.getHead();
            }
        };
    }

    public static final void purgeNode(GraphImpl impl, Node n) {
        Edge e;
        Iterator i = n.outEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            impl.setEdgeTail(e, null);
            impl.setEdgeHead(e, null);
        }
        i = n.inEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            impl.setEdgeTail(e, null);
            impl.setEdgeHead(e, null);
        }
        impl.removeNode(n);
    }

    public static final void purgeNode(GraphModel m, Node n) {
        Edge e;
        Iterator i = n.outEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            m.disconnectEdge(e);
        }
        i = n.inEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            m.disconnectEdge(e);
        }
        m.removeNode(n);
    }

    public static final void setAllVisited(Graph g, boolean visited) {
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            n.setVisited(visited);
        }
    }

    public static final boolean checkConsistency(Graph g) {
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Edge e;
            Node n = (Node)i.next();
            Iterator j = n.outEdges();
            while (j.hasNext()) {
                e = (Edge)j.next();
                if (e != null && e.getHead() != null) continue;
                return false;
            }
            j = n.inEdges();
            while (j.hasNext()) {
                e = (Edge)j.next();
                if (e != null && e.getTail() != null) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean checkContainment(Graph g) {
        if (!GraphUtilities.checkConsistency(g)) {
            return false;
        }
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Edge e;
            Node n = (Node)i.next();
            if (n.getParent() != g) {
                return false;
            }
            Iterator j = n.outEdges();
            while (j.hasNext()) {
                e = (Edge)j.next();
                if (e.getHead().getParent() == g) continue;
                return false;
            }
            j = n.inEdges();
            while (j.hasNext()) {
                e = (Edge)j.next();
                if (e.getTail().getParent() == g) continue;
                return false;
            }
        }
        return true;
    }

    public static final Iterator localEdges(Graph g) {
        return new EdgeIterator(g, new LocalEdgeFilter(g));
    }

    private static final class LocalEdgeFilter
    implements Filter {
        private Graph _graph;

        public LocalEdgeFilter(Graph g) {
            this._graph = g;
        }

        public boolean accept(Object o) {
            if (o instanceof Edge) {
                Edge e = (Edge)o;
                return e.getHead() != null && e.getHead().getParent() == this._graph && e.getTail() != null && e.getTail().getParent() == this._graph;
            }
            return false;
        }
    }

    public static final class EdgeIterator
    extends IteratorAdapter {
        private Iterator _nodeIter;
        private Iterator _edgeIter;
        private Filter _filter;
        private Object _nextEdge;

        public EdgeIterator(Graph g) {
            this._nodeIter = g.nodes();
        }

        public EdgeIterator(Graph g, Filter f) {
            this._nodeIter = g.nodes();
            this._filter = f;
        }

        public boolean hasNext() {
            if (this._nextEdge != null) {
                return true;
            }
            this.getNext();
            return this._nextEdge != null;
        }

        public Object next() {
            if (this._nextEdge == null) {
                this.getNext();
            }
            Object result = this._nextEdge;
            this._nextEdge = null;
            return result;
        }

        private void getNext() {
            while (this._nextEdge == null) {
                if (this._edgeIter == null) {
                    if (!this._nodeIter.hasNext()) break;
                    Iterator outEdges = ((Node)this._nodeIter.next()).outEdges();
                    this._edgeIter = this._filter == null ? outEdges : new FilteredIterator(outEdges, this._filter);
                }
                if (this._edgeIter.hasNext()) {
                    this._nextEdge = this._edgeIter.next();
                    continue;
                }
                this._edgeIter = null;
            }
        }
    }
}

