/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.schematic;

import diva.graph.model.CompositeNode;
import diva.graph.model.Edge;
import diva.graph.model.GraphEvent;
import diva.graph.model.GraphListener;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;
import diva.graph.schematic.SchematicEvent;
import diva.graph.schematic.SchematicListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SchematicModel {
    private ArrayList _listeners;
    private HashMap _mapping = new HashMap();
    GraphModel _graphModel = null;

    public SchematicModel() {
        this(new GraphModel());
    }

    public SchematicModel(GraphModel m) {
        this._graphModel = m;
        this._graphModel.addGraphListener(new LocalGraphListener());
    }

    public void addSchematicListener(SchematicListener l) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(l);
    }

    public void removeSchematicListener(SchematicListener l) {
        this._listeners.remove(l);
    }

    public void addComponent(Object component, Object network) {
        CompositeNode n;
        CompositeNode c = (CompositeNode)this._mapping.get(component);
        if (c == null) {
            c = this._graphModel.createCompositeNode(component);
            this._mapping.put(component, c);
        }
        if ((n = (CompositeNode)this._mapping.get(network)) == null) {
            this._graphModel.addNode(c);
        } else {
            this._graphModel.addNode(c, n);
        }
    }

    public void removeComponent(Object component) {
        CompositeNode c = (CompositeNode)this._mapping.get(component);
        this._graphModel.removeNode(c);
        this._mapping.remove(component);
    }

    public void addPort(Object port, Object component) {
        CompositeNode c;
        Node p = (Node)this._mapping.get(port);
        if (p == null) {
            p = this._graphModel.createNode(port);
            this._mapping.put(port, p);
        }
        if ((c = (CompositeNode)this._mapping.get(component)) == null) {
            this._graphModel.addNode(p);
        } else {
            this._graphModel.addNode(p, c);
        }
    }

    public void removePort(Object port) {
        Node p = (Node)this._mapping.get(port);
        this._graphModel.removeNode(p);
        this._mapping.remove(port);
    }

    public void connectWire(Object wire, Object tailPort, Object headPort) {
        Node tp = (Node)this._mapping.get(tailPort);
        Node hp = (Node)this._mapping.get(headPort);
        Edge w = (Edge)this._mapping.get(wire);
        if (w == null) {
            w = this._graphModel.createEdge(wire);
            this._mapping.put(wire, w);
        }
        this._graphModel.connectEdge(w, tp, hp);
    }

    public void disconnectWire(Object wire) {
        Edge w = (Edge)this._mapping.get(wire);
        this._graphModel.disconnectEdge(w);
        this._mapping.remove(wire);
    }

    private class LocalGraphListener
    implements GraphListener {
        private LocalGraphListener() {
        }

        public void nodeAdded(GraphEvent evt) {
            Node n = (Node)evt.getTarget();
            Object what = n.getSemanticObject();
            SchematicModel.this._mapping.put(what, n);
            Object whatParent = SchematicModel.this._mapping.get(n.getParent());
            int id = n instanceof CompositeNode ? 0 : 2;
            SchematicEvent e = new SchematicEvent(id, SchematicModel.this, what, whatParent);
            this.dispatchSchematicEvent(e);
        }

        public void nodeRemoved(GraphEvent evt) {
            Node n = (Node)evt.getTarget();
            Object what = n.getSemanticObject();
            int id = n instanceof CompositeNode ? 1 : 3;
            SchematicModel.this._mapping.remove(what);
            SchematicEvent e = new SchematicEvent(id, SchematicModel.this, what);
            this.dispatchSchematicEvent(e);
        }

        public void edgeHeadChanged(GraphEvent evt) {
            this.edgeUpdated(evt);
        }

        public void edgeTailChanged(GraphEvent evt) {
            this.edgeUpdated(evt);
        }

        private void edgeUpdated(GraphEvent evt) {
            SchematicEvent eout;
            Edge e = (Edge)evt.getTarget();
            Object what = e.getSemanticObject();
            if (e.getHead() == null || e.getTail() == null) {
                eout = new SchematicEvent(5, SchematicModel.this, what);
                SchematicModel.this._mapping.remove(what);
            } else {
                Object whatTail = e.getTail().getSemanticObject();
                Object whatHead = e.getHead().getSemanticObject();
                eout = new SchematicEvent(4, SchematicModel.this, what, whatTail, whatHead);
                SchematicModel.this._mapping.put(what, e);
            }
            this.dispatchSchematicEvent(eout);
        }

        public void structureChanged(GraphEvent evt) {
            System.err.println("UNEXPECTED EVENT: " + evt);
            System.exit(-1);
        }

        private void dispatchSchematicEvent(SchematicEvent evt) {
            if (SchematicModel.this._listeners != null) {
                switch (evt.getID()) {
                    case 0: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).componentAdded(evt);
                        }
                        break;
                    }
                    case 1: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).componentRemoved(evt);
                        }
                        break;
                    }
                    case 2: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).portAdded(evt);
                        }
                        break;
                    }
                    case 3: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).portRemoved(evt);
                        }
                        break;
                    }
                    case 4: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).wireConnected(evt);
                        }
                        break;
                    }
                    case 5: {
                        Iterator i = SchematicModel.this._listeners.iterator();
                        while (i.hasNext()) {
                            ((SchematicListener)i.next()).wireDisconnected(evt);
                        }
                        break;
                    }
                }
            }
        }
    }
}

