/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PaintedObject;
import diva.util.java2d.PaintedPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class PaintedShape
implements PaintedObject {
    public BasicStroke stroke;
    public Paint fillPaint;
    public Shape shape;
    public Paint strokePaint;

    public PaintedShape(Shape shape) {
        this.shape = shape;
        this.strokePaint = Color.black;
        this.setLineWidth(1.0f);
    }

    public PaintedShape(Shape shape, Paint fillPaint) {
        this.shape = shape;
        this.fillPaint = fillPaint;
    }

    public PaintedShape(Shape shape, Paint fillPaint, float lineWidth) {
        this.shape = shape;
        this.fillPaint = fillPaint;
        this.strokePaint = Color.black;
        this.setLineWidth(lineWidth);
    }

    public Rectangle2D getBounds() {
        if (this.stroke == null) {
            return this.shape.getBounds2D();
        }
        return this.stroke.createStrokedShape(this.shape).getBounds2D();
    }

    public float getLineWidth() {
        if (this.stroke == null) {
            return 0.0f;
        }
        return this.stroke.getLineWidth();
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public boolean hit(Rectangle2D r) {
        if (this.fillPaint != null) {
            return this.shape.intersects(r);
        }
        return this.shape.intersects(r);
    }

    public void paint(Graphics2D g) {
        if (this.fillPaint != null) {
            g.setPaint(this.fillPaint);
            g.fill(this.shape);
        }
        if (this.stroke != null && this.strokePaint != null) {
            g.setStroke(this.stroke);
            g.setPaint(this.strokePaint);
            g.draw(this.shape);
        }
    }

    public void setLineWidth(float lineWidth) {
        if ((double)lineWidth <= 0.0) {
            this.stroke = null;
        } else if (this.stroke == null || lineWidth != this.stroke.getLineWidth()) {
            this.stroke = PaintedPath.getStroke(lineWidth);
        }
    }
}

