/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PaintedObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class PaintedString
implements PaintedObject {
    private String _string;
    private static Font _defaultFont = new Font("Serif", 0, 16);
    private Font _font;
    private Paint _fillPaint = Color.black;
    private AffineTransform _transform = new AffineTransform();
    private Shape _shape;
    private Rectangle2D _bounds;

    public PaintedString() {
        this("");
    }

    public PaintedString(String s) {
        this._string = s;
        this._font = _defaultFont;
        this.update();
    }

    public PaintedString(String s, Font f) {
        this._string = s;
        this._font = f;
        this.update();
    }

    public PaintedString(String s, String face, int style, int size) {
        this._string = s;
        this._font = new Font(face, style, size);
        this.update();
    }

    public Rectangle2D getBounds() {
        return this._bounds;
    }

    public Font getFont() {
        return this._font;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    public String getFontName() {
        return this._font.getFontName();
    }

    public int getStyle() {
        return this._font.getStyle();
    }

    public int getSize() {
        return this._font.getSize();
    }

    public Shape getShape() {
        return this._bounds;
    }

    public String getString() {
        return this._string;
    }

    public void paint(Graphics2D g) {
        if (this.getString() != null) {
            g.setPaint(this._fillPaint);
            g.fill(this._shape);
        }
    }

    public void setFillPaint(Paint p) {
        this._fillPaint = p;
    }

    public void setFont(Font f) {
        this._font = f;
        this.update();
    }

    public void setFontName(String s) {
        this.setFont(new Font(s, this._font.getStyle(), this._font.getSize()));
    }

    public void setStyle(int style) {
        this.setFont(new Font(this._font.getFontName(), style, this._font.getSize()));
    }

    public void setSize(int size) {
        this.setFont(new Font(this._font.getFontName(), this._font.getStyle(), size));
    }

    public void setString(String s) {
        this._string = s;
        this.update();
    }

    public void setTransform(AffineTransform at) {
        this.update();
    }

    public void transform(AffineTransform at) {
        this._transform.preConcatenate(at);
        this.update();
    }

    public void translate(double x, double y) {
        this._transform.translate(x, y);
        this.update();
    }

    private void update() {
        FontRenderContext frc = new FontRenderContext(this._transform, true, false);
        GlyphVector gv = this._font.createGlyphVector(frc, this._string);
        this._bounds = gv.getVisualBounds();
        this._shape = gv.getOutline();
    }
}

