/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import fsa.FigureMover;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Timer;

public class AnimationManager
implements ActionListener {
    Semaphore _lock;
    Timer _timer;
    Vector _animations = new Vector();

    public AnimationManager() {
        this._lock = new Semaphore(1L);
        this._timer = new Timer(50, this);
    }

    public void start() {
        try {
            this._lock.acquire();
        }
        catch (InterruptedException ie) {
            System.out.println("Interrupted Exception!");
            ie.printStackTrace();
        }
        this._timer.start();
        try {
            this._lock.acquire();
        }
        catch (InterruptedException ie) {
            System.out.println("Interrupted Exception!");
            ie.printStackTrace();
        }
        this._lock.release();
    }

    public void actionPerformed(ActionEvent ae) {
        boolean allDone = true;
        Iterator animations = this._animations.iterator();
        while (animations.hasNext()) {
            FigureMover animation = (FigureMover)animations.next();
            animation.step();
            if (!animation.isDone()) continue;
            animations.remove();
        }
        if (this._animations.isEmpty()) {
            this._timer.stop();
            this._lock.release();
        }
    }

    public void addAnimationObject(FigureMover fm) {
        try {
            this._lock.acquire();
        }
        catch (InterruptedException ie) {
            System.out.println("Interrupted Exception!");
            ie.printStackTrace();
        }
        this._animations.addElement(fm);
        this._lock.release();
    }

    public void removeAnimationObject(FigureMover fm) {
        try {
            this._lock.acquire();
        }
        catch (InterruptedException ie) {
            System.out.println("Interrupted Exception!");
            ie.printStackTrace();
        }
        this._animations.removeElement(fm);
        this._lock.release();
    }
}

