/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import diva.canvas.FigureLayer;
import diva.graph.GraphView;
import fsa.AnimationManager;
import fsa.AnimationPath;
import fsa.FSAGraphController;
import fsa.FSAGraphPane;
import fsa.FSAPanel;
import fsa.FigureMover;
import fsa.LightPanel;
import fsa.Tape;
import fsa.TransitionConnector;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;

class FSAAnimator {
    AnimateAction _animateAction;
    AnimationControlPanel _animationControlPanel;
    FigureLayer _animationLayer;
    AnimationManager _animationManager;
    FSAGraphController _controller;
    FSAGraphPane _graphPane;
    FSAPanel _fsaPanel;
    GraphView _graphView;
    LightPanel _lightPanel;
    Semaphore _steppingLock;
    StateMachine _machine;
    StepAction _stepAction;
    CancelAction _cancelAction;
    Tape _ioTape;
    Vector _deadMovers;
    Vector _movers;
    Vector _newMovers;
    boolean _stopFlag;

    public FSAAnimator(FSAPanel fp, StateMachine machine, GraphView graphView) {
        this._fsaPanel = fp;
        this._animationManager = new AnimationManager();
        this._controller = (FSAGraphController)graphView.getGraphController();
        this._graphView = graphView;
        this._graphPane = (FSAGraphPane)this._graphView.getGraphicsPane();
        this._animationLayer = this._graphPane.getAnimationLayer();
        this._ioTape = new Tape(true);
        this._ioTape.setLeftLimited(true);
        this._lightPanel = new LightPanel();
        this._machine = machine;
        this._movers = new Vector();
        this._deadMovers = new Vector();
        this._newMovers = new Vector();
        this._stepAction = new StepAction();
        this._cancelAction = new CancelAction();
        this._steppingLock = new Semaphore(1L);
        this._animateAction = new AnimateAction();
        this._animationControlPanel = new AnimationControlPanel();
    }

    public Action getAnimateAction() {
        return this._animateAction;
    }

    public Action getStepAction() {
        return this._stepAction;
    }

    public LightPanel getLightPanel() {
        return this._lightPanel;
    }

    public Tape getIOTape() {
        return this._ioTape;
    }

    public JPanel getAnimationControlPanel() {
        return this._animationControlPanel;
    }

    void killMovers() {
        Iterator iterator = this._movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            iterator.remove();
            this._deadMovers.addElement(mover);
        }
    }

    boolean moverInFinalState(Vector movers) {
        boolean inFinalState = false;
        Iterator iterator = this._movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            State state = mover.getState();
            if (!state.isFinalState()) continue;
            inFinalState = true;
            mover.setColor(Color.green);
        }
        return inFinalState;
    }

    void colorMovers(Vector movers, Color color) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.setColor(color);
        }
    }

    void demoteMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.demote();
        }
    }

    void clearMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.detach();
        }
        movers.clear();
    }

    AnimationPath getAnimationPath(Transition transition) {
        State state = transition.getDestination();
        TransitionConnector figure = this._controller.getEdgeFigure(transition);
        return figure.getAnimationPath();
    }

    FigureMover createMover(State state) {
        FigureMover mover = new FigureMover();
        mover.setLocation(this._controller.getStateFigure(state));
        mover.setState(state);
        mover.setLayer(this._animationLayer);
        mover.attach();
        return mover;
    }

    void handleEmptyTransitions() {
        Vector newMovers = new Vector(this._movers);
        do {
            ListIterator<FigureMover> movers = newMovers.listIterator();
            while (movers.hasNext()) {
                FigureMover mover = (FigureMover)movers.next();
                movers.remove();
                State state = mover.getState();
                Iterator transitions = this._machine.transitionFunction(state, StateMachine.EMPTY_SYMBOL);
                if (transitions == null) continue;
                while (transitions.hasNext()) {
                    Transition transition = (Transition)transitions.next();
                    FigureMover newMover = this.createMover(state);
                    this.prepareAnimation(newMover, transition);
                    movers.add(newMover);
                    this._movers.add(newMover);
                }
            }
            this.animateMovers(newMovers);
        } while (!newMovers.isEmpty());
    }

    void prepareAnimation(FigureMover mover, Transition transition) {
        mover.setState(transition.getDestination());
        mover.setPath(this.getAnimationPath(transition));
    }

    void animateMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            this._animationManager.addAnimationObject(mover);
        }
        this._animationManager.start();
    }

    class AnimationControlPanel
    extends JPanel {
        JButton _stepButton;
        JButton _cancelButton;

        public AnimationControlPanel() {
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            c.gridwidth = 0;
            this._stepButton = new JButton("Step");
            this._stepButton.addActionListener(FSAAnimator.this._stepAction);
            this._stepButton.setEnabled(false);
            gridbag.setConstraints(this._stepButton, c);
            this.add(this._stepButton);
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(FSAAnimator.this._cancelAction);
            this._cancelButton.setEnabled(false);
            gridbag.setConstraints(this._cancelButton, c);
            this.add(this._cancelButton);
        }

        public void setStepButtonEnabled(boolean enabled) {
            this._stepButton.setEnabled(enabled);
        }

        public void setCancelButtonEnabled(boolean enabled) {
            this._cancelButton.setEnabled(enabled);
        }
    }

    class AnimationThread
    extends Thread {
        AnimationThread() {
        }

        public void run() {
            FSAAnimator.this._fsaPanel.enterRunMode();
            FSAAnimator.this._lightPanel.allLightsOff();
            FSAAnimator.this._controller.enterExecuteMode();
            FSAAnimator.this._ioTape.moveHeadHome();
            FSAAnimator.this._lightPanel.runningLightOn();
            FSAAnimator.this._animationControlPanel.setStepButtonEnabled(true);
            FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(true);
            FigureMover mover = FSAAnimator.this.createMover(FSAAnimator.this._machine.getStartState());
            FSAAnimator.this._movers.addElement(mover);
            FSAAnimator.this.handleEmptyTransitions();
            try {
                FSAAnimator.this._steppingLock.acquire();
                FSAAnimator.this._steppingLock.acquire();
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted Exception!");
                ie.printStackTrace();
            }
            while (!FSAAnimator.this._movers.isEmpty() && !FSAAnimator.this._stopFlag) {
                FSAAnimator.this.clearMovers(FSAAnimator.this._deadMovers);
                Character symbol = FSAAnimator.this._ioTape.getSymbolAtHead();
                if (symbol != null) {
                    ListIterator<FigureMover> movers = FSAAnimator.this._movers.listIterator();
                    while (movers.hasNext()) {
                        mover = (FigureMover)movers.next();
                        State state = mover.getState();
                        Iterator transitions = FSAAnimator.this._machine.transitionFunction(state, symbol);
                        if (transitions.hasNext()) {
                            Transition transition = (Transition)transitions.next();
                            FSAAnimator.this.prepareAnimation(mover, transition);
                            while (transitions.hasNext()) {
                                transition = (Transition)transitions.next();
                                mover = FSAAnimator.this.createMover(state);
                                FSAAnimator.this.prepareAnimation(mover, transition);
                                movers.add(mover);
                            }
                            continue;
                        }
                        movers.remove();
                        FSAAnimator.this._deadMovers.addElement(mover);
                    }
                    FSAAnimator.this.colorMovers(FSAAnimator.this._deadMovers, Color.gray);
                    FSAAnimator.this.demoteMovers(FSAAnimator.this._deadMovers);
                    if (!FSAAnimator.this._movers.isEmpty()) {
                        FSAAnimator.this.animateMovers(FSAAnimator.this._movers);
                        FSAAnimator.this._ioTape.moveHeadRight();
                    } else {
                        FSAAnimator.this._lightPanel.rejectedLightOn();
                    }
                    FSAAnimator.this.handleEmptyTransitions();
                } else {
                    FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(false);
                    if (FSAAnimator.this.moverInFinalState(FSAAnimator.this._movers)) {
                        FSAAnimator.this._lightPanel.acceptedLightOn();
                    } else {
                        FSAAnimator.this._lightPanel.rejectedLightOn();
                    }
                    FSAAnimator.this.killMovers();
                }
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(true);
                try {
                    FSAAnimator.this._steppingLock.acquire();
                }
                catch (InterruptedException ie) {
                    System.out.println("Interrupted Exception!");
                    ie.printStackTrace();
                }
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(false);
            }
            if (FSAAnimator.this._stopFlag) {
                FSAAnimator.this.killMovers();
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(false);
                FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(false);
            }
            FSAAnimator.this.clearMovers(FSAAnimator.this._deadMovers);
            FSAAnimator.this._lightPanel.allLightsOff();
            FSAAnimator.this._controller.enterEditMode();
            FSAAnimator.this._stopFlag = false;
            FSAAnimator.this._steppingLock.release();
            FSAAnimator.this._fsaPanel.exitRunMode();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            FSAAnimator.this._stopFlag = true;
            if (FSAAnimator.this._steppingLock.permits() == 0L) {
                FSAAnimator.this._steppingLock.release();
            }
            FSAAnimator.this._fsaPanel.exitRunMode();
        }
    }

    class StepAction
    extends AbstractAction {
        StepAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (FSAAnimator.this._steppingLock.permits() == 0L) {
                FSAAnimator.this._steppingLock.release();
            }
        }
    }

    class AnimateAction
    extends AbstractAction {
        AnimateAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            new AnimationThread().start();
        }
    }
}

