/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.Figure;
import diva.canvas.connector.AbstractConnector;
import diva.canvas.connector.Connector;
import diva.graph.GraphView;
import diva.graph.model.Edge;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;
import fsa.FSAGraphController;
import fsa.StateFigure;
import fsa.TransitionConnector;
import fsa.machine.State;
import fsa.machine.StateEvent;
import fsa.machine.StateListener;
import fsa.machine.StatePropertyEvent;
import fsa.machine.Transition;
import fsa.machine.TransitionEvent;
import fsa.machine.TransitionListener;
import fsa.machine.TransitionMovedEvent;
import java.awt.geom.Point2D;

public class FSAGUIProxy
implements StateListener,
TransitionListener {
    FSAGraphController _controller;

    public FSAGUIProxy(FSAGraphController controller) {
        this._controller = controller;
    }

    public void stateAdded(StateEvent se) {
        GraphModel graphModel = this._controller.getGraphModel();
        GraphView graphView = this._controller.getGraphView();
        State state = se.getState();
        String label = state.getProperty("label");
        Point2D position = state.getPosition();
        Node node = graphModel.createNode(state);
        state.setUserObject(node);
        StateFigure nodeFigure = (StateFigure)graphView.getNodeRenderer().render(node);
        nodeFigure.setInteractor(this._controller.getNodeInteractor());
        graphView.addNodeFigureToLayer(nodeFigure);
        graphView.placeNodeFigure(nodeFigure, position.getX(), position.getY());
        graphView.addNodeMapping(node, nodeFigure);
        graphModel.addNode(node);
        if (label != null) {
            nodeFigure.setLabelString(label);
        }
    }

    public void stateRemoved(StateEvent se) {
        this._controller.getSelectionModel().clearSelection();
        GraphModel graphModel = this._controller.getGraphModel();
        GraphView graphView = this._controller.getGraphView();
        State state = se.getState();
        Node node = (Node)state.getUserObject();
        graphModel.removeNode(node);
    }

    public void stateDescriptionChanged(StateEvent se) {
    }

    public void startStateChange(StateEvent se) {
        GraphView graphView = this._controller.getGraphView();
        State state = se.getState();
        Node node = (Node)state.getUserObject();
        StateFigure stateFigure = (StateFigure)graphView.getNodeFigure(node);
        if (state.isStartState()) {
            if (state.isFinalState()) {
                stateFigure.setStateType(38);
            } else {
                stateFigure.setStateType(36);
            }
        } else if (state.isFinalState()) {
            stateFigure.setStateType(37);
        } else {
            stateFigure.setStateType(35);
        }
    }

    public void finalStateChange(StateEvent se) {
        GraphView graphView = this._controller.getGraphView();
        State state = se.getState();
        Node node = (Node)state.getUserObject();
        StateFigure stateFigure = (StateFigure)graphView.getNodeFigure(node);
        if (state.isFinalState()) {
            if (state.isStartState()) {
                stateFigure.setStateType(38);
            } else {
                stateFigure.setStateType(37);
            }
        } else if (state.isStartState()) {
            stateFigure.setStateType(36);
        } else {
            stateFigure.setStateType(35);
        }
    }

    public void statePropertyChanged(StatePropertyEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("x") || propertyName.equals("y")) {
            GraphModel graphModel = this._controller.getGraphModel();
            GraphView graphView = this._controller.getGraphView();
            State state = e.getState();
            Point2D position = state.getPosition();
            Node node = (Node)state.getUserObject();
            Figure nodeFigure = graphView.getNodeFigure(node);
            graphView.placeNodeFigure(nodeFigure, position.getX(), position.getY());
        } else if (propertyName.equals("label")) {
            State state = e.getState();
            GraphView graphView = this._controller.getGraphView();
            Node node = (Node)state.getUserObject();
            StateFigure figure = (StateFigure)graphView.getNodeFigure(node);
            figure.setLabelString(state.getProperty("label"));
        }
    }

    public void transitionAdded(TransitionEvent e) {
        Transition transition = e.getTransition();
        Edge edge = (Edge)transition.getUserObject();
        if (edge == null) {
            GraphView view = this._controller.getGraphView();
            GraphModel model = this._controller.getGraphModel();
            Node tailNode = (Node)transition.getSource().getUserObject();
            Node headNode = (Node)transition.getDestination().getUserObject();
            edge = model.createEdge(transition);
            model.connectEdge(edge, tailNode, headNode);
            transition.setUserObject(edge);
            TransitionConnector ef = (TransitionConnector)view.getEdgeFigure(edge);
            ef.setLabel(transition.getSymbolSet().getFormattedSymbolString());
            State tailState = (State)tailNode.getSemanticObject();
            State headState = (State)headNode.getSemanticObject();
            TransitionConnector oppConnector = this._controller.getOppositeConnector(tailState, headState);
            if (oppConnector != null) {
                ef.setIsArc(true);
                oppConnector.setIsArc(true);
            }
        }
    }

    public void transitionRemoved(TransitionEvent e) {
        Transition transition = e.getTransition();
        Edge edge = (Edge)transition.getUserObject();
        if (edge != null) {
            this._controller.getSelectionModel().clearSelection();
            GraphModel model = this._controller.getGraphModel();
            GraphView view = this._controller.getGraphView();
            Connector edgeFigure = view.getEdgeFigure(edge);
            model.disconnectEdge(edge);
            TransitionConnector oppConn = this._controller.getOppositeConnector(transition.getSource(), transition.getDestination());
            if (oppConn != null) {
                oppConn.setIsArc(false);
            }
        }
    }

    public void transitionMoved(TransitionMovedEvent e) {
    }

    public void transitionSymbolsChanged(TransitionEvent e) {
        Transition transition = e.getTransition();
        Edge edge = (Edge)transition.getUserObject();
        GraphView view = this._controller.getGraphView();
        AbstractConnector connector = (AbstractConnector)view.getEdgeFigure(edge);
        connector.setLabel(transition.getSymbolSet().getFormattedSymbolString());
    }
}

