/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.FSAFileNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.tree.TreeNode;

public class FSAJarFileNode
extends FSAFileNode {
    Hashtable _childHash = null;
    JarEntry _jarEntry = null;
    JarFile _jarFile = null;
    FSAJarFileNode _parent = null;
    String _name;
    Vector _children = null;

    public FSAJarFileNode(JarFile jFile) {
        this._jarFile = jFile;
        this._jarEntry = new JarEntry("/");
        this._children = new Vector();
        this._childHash = new Hashtable();
        this._name = "/";
        Enumeration<JarEntry> entries = this._jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (entry.isDirectory()) {
                name = name.substring(0, name.length() - 1);
            }
            StringTokenizer tokenizer = new StringTokenizer(name, "/");
            this.addNode(entry, tokenizer);
        }
    }

    protected FSAJarFileNode(FSAJarFileNode parent, JarEntry entry, String name) {
        this._parent = parent;
        this._jarEntry = entry;
        this._jarFile = this._parent.getJarFile();
        this._name = name;
        if (this._jarEntry.isDirectory()) {
            this._children = new Vector();
            this._childHash = new Hashtable();
        } else {
            this._children = null;
            this._childHash = null;
        }
    }

    protected void addNode(JarEntry entry, StringTokenizer tokenizer) {
        String name = tokenizer.nextToken();
        FSAJarFileNode child = (FSAJarFileNode)this._childHash.get(name);
        if (child == null) {
            child = new FSAJarFileNode(this, entry, name);
            this._children.addElement(child);
            this._childHash.put(name, child);
        }
        if (tokenizer.hasMoreTokens()) {
            child.addNode(entry, tokenizer);
        }
    }

    public boolean isLeaf() {
        return !this._jarEntry.isDirectory();
    }

    public boolean getAllowsChildren() {
        return this._jarEntry.isDirectory();
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this._children.elementAt(index);
    }

    public int getChildCount() {
        return this._children.size();
    }

    public int getIndex(TreeNode node) {
        return this._children.indexOf(node);
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public Enumeration children() {
        return this._children.elements();
    }

    public String toString() {
        return this._name;
    }

    public InputStream getInputStream() {
        if (this.isLeaf()) {
            try {
                return this._jarFile.getInputStream(this._jarEntry);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public JarFile getJarFile() {
        return this._jarFile;
    }
}

