/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.SymbolChangeException;
import fsa.SymbolSet;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public final class FSAOperations {
    public static StateMachine makeDeterministic(StateMachine nfsa) {
        State state;
        HashMap n2dMap = new HashMap();
        HashSet stateSets = new HashSet();
        StateMachine dfsa = new StateMachine();
        Vector stateSetQueue = new Vector();
        SymbolSet alphabet = nfsa.getAlphabet();
        try {
            dfsa.getAlphabet().addSymbols(nfsa.getAlphabet().getSymbolArray());
        }
        catch (SymbolChangeException e) {
            System.exit(1);
        }
        State nfsaStartState = nfsa.getStartState();
        State dfsaStartState = new State();
        dfsa.addState(dfsaStartState);
        dfsaStartState.setStartState(true);
        HashSet startStateSet = new HashSet();
        startStateSet.add(nfsaStartState);
        Iterator states = FSAOperations.getEmptyTransitionSet(nfsaStartState);
        while (states.hasNext()) {
            state = (State)states.next();
            startStateSet.add(state);
        }
        dfsaStartState.setFinalState(FSAOperations.hasFinalState(startStateSet));
        n2dMap.put(startStateSet, dfsaStartState);
        stateSets.add(startStateSet);
        stateSetQueue.add(startStateSet);
        while (!stateSetQueue.isEmpty()) {
            startStateSet = (HashSet)stateSetQueue.remove(0);
            State startState = (State)n2dMap.get(startStateSet);
            Iterator symbols = alphabet.getSymbols();
            while (symbols.hasNext()) {
                State endState;
                Transition transition;
                Character symbol = (Character)symbols.next();
                if (symbol.equals(StateMachine.EMPTY_SYMBOL)) continue;
                HashSet<State> endStateSet = new HashSet<State>();
                states = startStateSet.iterator();
                while (states.hasNext()) {
                    state = (State)states.next();
                    Iterator transitions = nfsa.transitionFunction(state, symbol);
                    while (transitions.hasNext()) {
                        transition = (Transition)transitions.next();
                        endState = transition.getDestination();
                        endStateSet.add(endState);
                        Iterator emptyStates = FSAOperations.getEmptyTransitionSet(endState);
                        while (emptyStates.hasNext()) {
                            State emptyState = (State)emptyStates.next();
                            endStateSet.add(emptyState);
                        }
                    }
                }
                if (endStateSet.isEmpty()) continue;
                if (!stateSets.contains(endStateSet)) {
                    endState = new State();
                    dfsa.addState(endState);
                    endState.setFinalState(FSAOperations.hasFinalState(endStateSet));
                    n2dMap.put(endStateSet, endState);
                    stateSets.add(endStateSet);
                    stateSetQueue.add(endStateSet);
                } else {
                    endState = (State)n2dMap.get(endStateSet);
                }
                if (dfsa.transitionExists(startState, endState)) {
                    transition = dfsa.getTransition(startState, endState);
                } else {
                    transition = new Transition(startState, endState);
                    dfsa.addTransition(transition);
                }
                try {
                    transition.getSymbolSet().addSymbol(symbol);
                }
                catch (SymbolChangeException e) {
                    System.exit(1);
                }
            }
        }
        return dfsa;
    }

    protected static Iterator getEmptyTransitionSet(State startState) {
        StateMachine fsa = startState.getOwner();
        Vector<State> stateQueue = new Vector<State>();
        HashSet<State> stateSet = new HashSet<State>();
        stateSet.add(startState);
        stateQueue.add(startState);
        while (!stateQueue.isEmpty()) {
            State state = (State)stateQueue.remove(0);
            Iterator transitions = fsa.transitionFunction(state, StateMachine.EMPTY_SYMBOL);
            while (transitions.hasNext()) {
                Transition transition = (Transition)transitions.next();
                State destination = transition.getDestination();
                if (stateSet.contains(destination)) continue;
                stateQueue.add(destination);
                stateSet.add(destination);
            }
        }
        return stateSet.iterator();
    }

    protected static boolean hasFinalState(HashSet stateSet) {
        Iterator states = stateSet.iterator();
        while (states.hasNext()) {
            State state = (State)states.next();
            if (!state.isFinalState()) continue;
            return true;
        }
        return false;
    }

    public static StateMachine complement(StateMachine fsa) {
        StateMachine comp_fsa = FSAOperations.copy(fsa);
        Iterator states = comp_fsa.getStates();
        while (states.hasNext()) {
            State state;
            state.setFinalState(!(state = (State)states.next()).isFinalState());
        }
        return comp_fsa;
    }

    public static StateMachine copy(StateMachine fsa) {
        HashMap<State, State> statesMap = new HashMap<State, State>();
        StateMachine copy_fsa = new StateMachine();
        Character[] symbols = fsa.getAlphabet().getSymbolArray();
        try {
            copy_fsa.getAlphabet().addSymbols(symbols);
        }
        catch (SymbolChangeException sce) {
            System.exit(1);
        }
        Iterator states = fsa.getStates();
        while (states.hasNext()) {
            State state = (State)states.next();
            State newState = new State();
            statesMap.put(state, newState);
            copy_fsa.addState(newState);
            newState.setPosition(state.getPosition());
            if (state.isStartState()) {
                newState.setStartState(true);
            }
            if (!state.isFinalState()) continue;
            newState.setFinalState(true);
        }
        Iterator transitions = fsa.getTransitions();
        while (transitions.hasNext()) {
            Transition transition = (Transition)transitions.next();
            State startState = transition.getSource();
            State endState = transition.getDestination();
            Transition newTransition = new Transition((State)statesMap.get(startState), (State)statesMap.get(endState));
            symbols = transition.getSymbolSet().getSymbolArray();
            try {
                newTransition.getSymbolSet().addSymbols(symbols);
            }
            catch (SymbolChangeException sce) {
                System.exit(1);
            }
            copy_fsa.addTransition(newTransition);
        }
        return copy_fsa;
    }

    public static void addDeadState(StateMachine fsa) {
        State deadState = new State();
        fsa.addState(deadState);
        Transition deadLoop = new Transition(deadState, deadState);
        try {
            deadLoop.getSymbolSet().addSymbols(fsa.getAlphabet().getSymbolArray());
            deadLoop.getSymbolSet().removeSymbol(StateMachine.EMPTY_SYMBOL);
        }
        catch (SymbolChangeException sce) {
            System.exit(1);
        }
        fsa.addTransition(deadLoop);
        Iterator states = fsa.getStates();
        SymbolSet deadSymbols = new SymbolSet(null);
        while (states.hasNext()) {
            State state = (State)states.next();
            if (state == deadState) continue;
            Iterator symbols = fsa.getAlphabet().getSymbols();
            while (symbols.hasNext()) {
                Character symbol = (Character)symbols.next();
                if (symbol.equals(StateMachine.EMPTY_SYMBOL) || fsa.transitionFunction(state, symbol).hasNext()) continue;
                try {
                    deadSymbols.addSymbol(symbol);
                }
                catch (SymbolChangeException sce) {
                    System.exit(1);
                }
            }
            if (!deadSymbols.isEmpty()) {
                Transition transition = new Transition(state, deadState);
                try {
                    transition.getSymbolSet().addSymbols(deadSymbols.getSymbolArray());
                }
                catch (SymbolChangeException sce) {
                    System.exit(1);
                }
                fsa.addTransition(transition);
            }
            try {
                deadSymbols.clear();
            }
            catch (SymbolChangeException sce) {
                System.exit(1);
            }
        }
    }

    public static StateMachine intersect(StateMachine fsa1, StateMachine fsa2) {
        Vector<State> pair;
        State state2;
        State state1;
        HashMap<Vector<State>, State> statesMap = new HashMap<Vector<State>, State>();
        StateMachine intersection = new StateMachine();
        SymbolSet alphabet = intersection.getAlphabet();
        try {
            alphabet.addSymbols(fsa1.getAlphabet().getSymbolArray());
            alphabet.addSymbols(fsa2.getAlphabet().getSymbolArray());
        }
        catch (SymbolChangeException sce) {
            System.exit(1);
        }
        Iterator states1 = fsa1.getStates();
        while (states1.hasNext()) {
            state1 = (State)states1.next();
            Iterator states2 = fsa2.getStates();
            while (states2.hasNext()) {
                state2 = (State)states2.next();
                pair = new Vector<State>();
                pair.add(state1);
                pair.add(state2);
                State newState = new State();
                intersection.addState(newState);
                statesMap.put(pair, newState);
                if (state1.isStartState() && state2.isStartState()) {
                    newState.setStartState(true);
                }
                if (!state1.isFinalState() || !state2.isFinalState()) continue;
                newState.setFinalState(true);
            }
        }
        Iterator symbols = alphabet.getSymbols();
        while (symbols.hasNext()) {
            Character symbol = (Character)symbols.next();
            Iterator pairs = statesMap.keySet().iterator();
            while (pairs.hasNext()) {
                Transition transition;
                pair = (Vector<State>)pairs.next();
                state1 = (State)pair.elementAt(0);
                state2 = (State)pair.elementAt(1);
                State source = (State)statesMap.get(pair);
                Iterator dests = fsa1.transitionFunction(state1, symbol);
                if (!dests.hasNext()) continue;
                State dest1 = ((Transition)dests.next()).getDestination();
                dests = fsa2.transitionFunction(state2, symbol);
                if (!dests.hasNext()) continue;
                State dest2 = ((Transition)dests.next()).getDestination();
                pair = new Vector<State>();
                pair.add(dest1);
                pair.add(dest2);
                State dest = (State)statesMap.get(pair);
                dests = intersection.transitionFunction(source, symbol);
                if (dests.hasNext()) {
                    transition = (Transition)dests.next();
                } else {
                    transition = new Transition(source, dest);
                    intersection.addTransition(transition);
                }
                try {
                    transition.getSymbolSet().addSymbol(symbol);
                }
                catch (SymbolChangeException sce) {
                    System.exit(1);
                }
            }
        }
        return intersection;
    }

    public static String getIntersectString(StateMachine fsa1, StateMachine fsa2) {
        StateMachine dfsa1 = fsa1.isDeterministic() ? FSAOperations.makeDeterministic(fsa1) : fsa1;
        StateMachine dfsa2 = fsa2.isDeterministic() ? FSAOperations.makeDeterministic(fsa2) : fsa2;
        StateMachine intersection = FSAOperations.intersect(dfsa1, dfsa2);
        return FSAOperations.getAcceptedString(intersection);
    }

    public static String getAcceptedString(StateMachine fsa) {
        State startState = fsa.getStartState();
        if (startState.isFinalState()) {
            return "";
        }
        HashSet<State> visitedStates = new HashSet<State>();
        visitedStates.add(startState);
        StringBuffer returnValue = FSAOperations.getAcceptedString(fsa, startState, visitedStates);
        if (returnValue != null) {
            return returnValue.toString();
        }
        return null;
    }

    protected static StringBuffer getAcceptedString(StateMachine fsa, State fromState, HashSet visitedStates) {
        if (fromState.isFinalState()) {
            return new StringBuffer();
        }
        Iterator transitions = fsa.getTransitionsStartingFrom(fromState);
        while (transitions.hasNext()) {
            StringBuffer acceptedString;
            Transition transition = (Transition)transitions.next();
            State nextState = transition.getDestination();
            if (visitedStates.contains(nextState)) continue;
            visitedStates.add(nextState);
            Character symbol = FSAOperations.getRealSymbol(transition.getSymbolSet());
            if (symbol == null || (acceptedString = FSAOperations.getAcceptedString(fsa, nextState, visitedStates)) == null) continue;
            return acceptedString.insert(0, symbol);
        }
        return null;
    }

    protected static Character getRealSymbol(SymbolSet symbolSet) {
        Iterator symbols = symbolSet.getSymbols();
        while (symbols.hasNext()) {
            Character symbol = (Character)symbols.next();
            if (StateMachine.EMPTY_SYMBOL.equals(symbol)) continue;
            return symbol;
        }
        return null;
    }

    public static StateMachine union(StateMachine fsa1, StateMachine fsa2) {
        HashMap statesMap = new HashMap();
        return null;
    }
}

