/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.FigureLayer;
import diva.canvas.event.EventLayer;
import diva.graph.GraphPane;
import diva.graph.GraphView;
import diva.graph.JGraph;
import fsa.BasicWindow;
import fsa.ExampleFileFilter;
import fsa.FSAAnimator;
import fsa.FSAFile;
import fsa.FSAFileChooser;
import fsa.FSAGraphPane;
import fsa.FSAOperations;
import fsa.LightPanel;
import fsa.SymbolChangeException;
import fsa.SymbolDialog;
import fsa.SymbolPanel;
import fsa.SymbolSet;
import fsa.Tape;
import fsa.ToolTipInteractor;
import fsa.machine.StateMachine;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class FSAPanel
extends JApplet {
    private boolean _isApplet = true;
    private char[] _symbolArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '~', '!', '@', '$', '%', '^', '&', '*', '(', ')', '+', '=', '{', '}', '[', ']', '|', '\\', '<', '>', '?', '/', '_', '-', '.', ':', ';', ','};
    private Frame _parentFrame;
    private FSAAnimator _animator;
    private FSAFile _fsaFile;
    private FSAFile _targetFile;
    private FSAFileChooser _fsaFileChooser;
    private GraphPane _graphPane;
    private GraphView _graphView;
    private JFileChooser _fileChooser;
    private JGraph _jGraph;
    private JToolBar _toolbar;
    private StateMachine _machine;
    private StateMachine _targetMachine;
    private String _fileName;
    private SymbolDialog _alphabetDialog;
    private SymbolDialog _transitionDialog;
    private SymbolPanel _alphabetPanel;
    private SymbolPanel _transitionPanel;
    private SymbolSet _possibleSymbols;
    private Tape _ioTape;
    private Action _loadAction = new AbstractAction(){

        public void actionPerformed(ActionEvent se) {
            int value = FSAPanel.this._fileChooser.showOpenDialog(FSAPanel.this);
            if (value == 0) {
                FSAPanel.this._fileName = FSAPanel.this._fileChooser.getSelectedFile().getAbsolutePath();
                try {
                    FileInputStream fis = new FileInputStream(FSAPanel.this._fileName);
                    FSAPanel.this._fsaFile.loadFile(fis);
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FSAPanel.this._alphabetPanel.refreshSelections();
                FSAPanel.this.repaint();
            }
        }
    };
    private Action _saveAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            if (FSAPanel.this._fileName == null) {
                FSAPanel.this._saveAsAction.actionPerformed(ae);
            } else {
                try {
                    FileOutputStream fos = new FileOutputStream(FSAPanel.this._fileName);
                    FSAPanel.this._fsaFile.saveFile(fos);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private Action _saveAsAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            int value = FSAPanel.this._fileChooser.showSaveDialog(FSAPanel.this);
            if (value == 0) {
                FSAPanel.this._fileName = FSAPanel.this._fileChooser.getSelectedFile().getAbsolutePath();
                try {
                    FileOutputStream fos = new FileOutputStream(FSAPanel.this._fileName);
                    FSAPanel.this._fsaFile.saveFile(fos);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private Action _editAlphabetAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            FSAPanel.this._alphabetDialog = new SymbolDialog(FSAPanel.this._parentFrame, "Alphabet", FSAPanel.this._alphabetPanel);
            FSAPanel.this._alphabetDialog.setSize(300, 300);
            FSAPanel.this._alphabetDialog.show();
        }
    };
    private Action _clearAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            FSAPanel.this._machine.reset();
            FSAPanel.this._alphabetPanel.refreshSelections();
        }
    };
    private Action _compareAction = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            StateMachine attempt = FSAOperations.copy(FSAPanel.this._machine);
            StateMachine target = FSAOperations.copy(FSAPanel.this._targetMachine);
            if (!attempt.isDeterministic()) {
                attempt = FSAOperations.makeDeterministic(attempt);
            }
            SymbolSet attempt_alphabet = attempt.getAlphabet();
            SymbolSet target_alphabet = target.getAlphabet();
            try {
                attempt_alphabet.addSymbols(target_alphabet);
                target_alphabet.addSymbols(attempt_alphabet);
            }
            catch (SymbolChangeException sce) {
                System.out.println("Inconceivable!");
                sce.printStackTrace();
            }
            FSAOperations.addDeadState(attempt);
            FSAOperations.addDeadState(target);
            StateMachine target_complement = FSAOperations.complement(target);
            String istring = FSAOperations.getIntersectString(attempt, target_complement);
            if (istring != null) {
                String message = "Your FSA accepts the string \"" + istring + "\" which is not part of the language.";
                JOptionPane.showMessageDialog(null, message);
                return;
            }
            StateMachine attempt_complement = FSAOperations.complement(attempt);
            istring = FSAOperations.getIntersectString(attempt_complement, target);
            if (istring != null) {
                String message = "Your FSA does not accept the string \"" + istring + "\" which is part of the language.";
                JOptionPane.showMessageDialog(null, message);
                return;
            }
            String message = "Congratulations. Your FSA is correct!";
            JOptionPane.showMessageDialog(null, message);
        }
    };

    public FSAPanel() {
        if (!this._isApplet) {
            ExampleFileFilter filter = new ExampleFileFilter("fsa", "FSA File");
            this._fileChooser = new JFileChooser(System.getProperty("user.dir"));
            this._fileChooser.setFileFilter(filter);
        }
    }

    public FSAPanel(boolean isApplet) {
        this._isApplet = isApplet;
        if (!this._isApplet) {
            ExampleFileFilter filter = new ExampleFileFilter("fsa", "FSA File");
            this._fileChooser = new JFileChooser(System.getProperty("user.dir"));
            this._fileChooser.setFileFilter(filter);
        }
    }

    public void init() {
        GridBagLayout gbl = new GridBagLayout();
        Container parent = this;
        this._fileName = null;
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        this._parentFrame = (Frame)parent;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(gbl);
        this._machine = new StateMachine();
        this._transitionPanel = new SymbolPanel(this._machine.getAlphabet(), new SymbolSet(this));
        this._transitionDialog = new SymbolDialog(this._parentFrame, "Select Symbol(s) for Transition", this._transitionPanel);
        this._transitionDialog.setSize(300, 300);
        this._graphPane = new FSAGraphPane(this._machine, this._transitionDialog);
        this._graphView = this._graphPane.getGraphView();
        this._jGraph = new JGraph();
        this._jGraph.setGraphPane(this._graphPane);
        ToolTipManager.sharedInstance().registerComponent(this._jGraph);
        EventLayer background = this._graphPane.getBackgroundEventLayer();
        FigureLayer foreground = this._graphPane.getForegroundLayer();
        background.addInteractor(new ToolTipInteractor(foreground));
        this._animator = new FSAAnimator(this, this._machine, this._graphView);
        LightPanel lightPanel = this._animator.getLightPanel();
        this._ioTape = this._animator.getIOTape();
        this._toolbar = new JToolBar();
        this._toolbar.setFloatable(false);
        if (!this._isApplet) {
            this._toolbar.add(this._loadAction).setText("Load");
            this._toolbar.add(this._saveAction).setText("Save");
            this._toolbar.add(this._saveAsAction).setText("Save as");
        }
        this._toolbar.add(this._animator.getAnimateAction()).setText("Run");
        this._toolbar.add(this._clearAction).setText("Clear");
        this._toolbar.addSeparator();
        this._toolbar.add(this._editAlphabetAction).setText("Alphabet");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbl.setConstraints(this._toolbar, gbc);
        contentPane.add(this._toolbar);
        gbc.gridy = 1;
        gbl.setConstraints(this._ioTape, gbc);
        contentPane.add(this._ioTape);
        gbc.fill = 1;
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.gridheight = 3;
        gbc.weighty = 1.0;
        gbl.setConstraints(this._jGraph, gbc);
        contentPane.add(this._jGraph);
        gbc.fill = 0;
        gbc.gridx = -1;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbl.setConstraints(lightPanel, gbc);
        contentPane.add(lightPanel);
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JPanel animationControlPanel = this._animator.getAnimationControlPanel();
        gbl.setConstraints(animationControlPanel, gbc);
        contentPane.add(animationControlPanel);
        this._fsaFile = new FSAFile(this._machine);
        if (this._isApplet) {
            String path = this.getParameter("FSAFile");
            Class<?> myClass = this.getClass();
            InputStream is = null;
            try {
                if (path != null) {
                    is = myClass.getResourceAsStream(path);
                }
                if (is != null) {
                    this._fsaFile.loadFile(is);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            path = this.getParameter("TargetFile");
            try {
                this._targetFile = null;
                this._targetMachine = null;
                if (path != null) {
                    is = myClass.getResourceAsStream(path);
                }
                if (is != null) {
                    this._targetMachine = new StateMachine();
                    this._targetFile = new FSAFile(this._targetMachine);
                    this._targetFile.loadFile(is);
                    if (!this._targetMachine.isDeterministic()) {
                        this._targetMachine = FSAOperations.makeDeterministic(this._targetMachine);
                    }
                    this._toolbar.add(this._compareAction).setText("Compare");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._possibleSymbols = new SymbolSet((Object)this, this._symbolArray);
        this._ioTape.setAllowedSymbols(this._machine.getAlphabet());
        this._alphabetPanel = new SymbolPanel(this._possibleSymbols, this._machine.getAlphabet());
        this._alphabetDialog = new SymbolDialog(this._parentFrame, "Alphabet", this._alphabetPanel);
        this._alphabetDialog.setSize(300, 300);
    }

    public void readFromFile(String fileName) {
        this._alphabetPanel.refreshSelections();
    }

    public static void main(String[] args) {
        BasicWindow window = new BasicWindow("FSA Simulator");
        window.setSize(600, 400);
        Container contentPane = window.getContentPane();
        FSAPanel fp = new FSAPanel(false);
        contentPane.add(fp);
        fp.init();
        window.setVisible(true);
    }

    public void enterRunMode() {
        this._jGraph.setEnabled(false);
        Component[] c = this._toolbar.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].setEnabled(false);
        }
        this._ioTape.setEnabled(false);
    }

    public void exitRunMode() {
        this._jGraph.setEnabled(true);
        Component[] c = this._toolbar.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].setEnabled(true);
        }
        this._ioTape.setEnabled(true);
    }
}

