/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.Figure;
import diva.canvas.connector.PerimeterTarget;
import diva.graph.model.Node;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;

public class StatePerimeterTarget
extends PerimeterTarget {
    int _end;
    Transition _transition = null;
    State _state = null;

    public void setInfo(Transition transition, int end) {
        this._transition = transition;
        this._state = null;
        this._end = end;
    }

    public void setInfo(State state, int end) {
        this._state = state;
        this._transition = null;
        this._end = end;
    }

    public void unsetInfo() {
        this._transition = null;
        this._state = null;
    }

    public boolean accept(Figure f) {
        if (f.getUserObject() instanceof Node) {
            Node node = (Node)f.getUserObject();
            if (this._transition != null) {
                StateMachine machine = this._transition.getOwner();
                State targetState = (State)node.getSemanticObject();
                State tailState = this._transition.getSource();
                State headState = this._transition.getDestination();
                switch (this._end) {
                    case 21: {
                        if (targetState == headState) break;
                        return !machine.transitionExists(tailState, targetState);
                    }
                    case 22: {
                        if (targetState == tailState) break;
                        return !machine.transitionExists(targetState, headState);
                    }
                }
            } else if (this._state != null) {
                StateMachine machine = this._state.getOwner();
                State targetState = (State)node.getSemanticObject();
                switch (this._end) {
                    case 21: {
                        return !machine.transitionExists(this._state, targetState);
                    }
                    case 22: {
                        return !machine.transitionExists(targetState, this._state);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

