/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.ActionAdapter;
import fsa.SymbolChangeException;
import fsa.SymbolEvent;
import fsa.SymbolListener;
import fsa.SymbolSet;
import fsa.SymbolUser;
import fsa.VetoableSymbolEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class SymbolPanel
extends JPanel
implements SymbolListener {
    ActionAdapter action;
    ActionAdapter okAction;
    ActionAdapter cancelAction;
    JButton okButton;
    JButton cancelButton;
    JPanel buttonPanel;
    JPanel selectionPanel;
    Dimension maxSize;
    SymbolUser availableSymbols;
    TreeMap symbolButtons;
    SymbolSet selectedSymbols;
    TreeSet added;
    TreeSet removed;
    Insets margins = new Insets(0, 0, 0, 0);

    public SymbolPanel(SymbolUser symbols, SymbolSet selected) {
        this.availableSymbols = symbols;
        this.selectedSymbols = selected;
        this.maxSize = new Dimension();
        this.action = new ActionAdapter(this, "toggled");
        this.okAction = new ActionAdapter(this, "finished");
        this.cancelAction = new ActionAdapter(this, "cancelled");
        this.added = new TreeSet();
        this.removed = new TreeSet();
        this.symbolButtons = new TreeMap();
        this.setLayout(new BorderLayout());
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new FlowLayout(0, 0, 0));
        this.setupButtons();
        this.add((Component)this.selectionPanel, "Center");
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this.okAction);
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.cancelAction);
        this.buttonPanel.add(this.cancelButton);
        this.add((Component)this.buttonPanel, "South");
        this.availableSymbols.addSymbolListener(this);
    }

    private void setupButtons() {
        Dimension curSize = new Dimension();
        boolean sizeChanged = false;
        this.selectionPanel.removeAll();
        this.symbolButtons.clear();
        Iterator iterator = this.availableSymbols.getSymbols();
        boolean dist = false;
        while (iterator.hasNext()) {
            Character symbol = (Character)iterator.next();
            JToggleButton b = new JToggleButton(symbol.toString());
            b.setBorderPainted(false);
            b.setMargin(this.margins);
            b.addActionListener(this.action);
            if (this.selectedSymbols.contains(symbol)) {
                b.setSelected(true);
            }
            curSize = b.getPreferredSize();
            if (curSize.width > this.maxSize.width) {
                this.maxSize.width = curSize.width;
                sizeChanged = true;
            }
            if (curSize.height > this.maxSize.height) {
                this.maxSize.height = curSize.height;
                sizeChanged = true;
            }
            this.symbolButtons.put(symbol, b);
            this.selectionPanel.add(b);
        }
        this.resizeSymbolButtons();
        this.selectionPanel.validate();
    }

    public void refreshSelections() {
        Iterator iterator = this.symbolButtons.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            Character symbol = (Character)mapEntry.getKey();
            JToggleButton button = (JToggleButton)mapEntry.getValue();
            button.setSelected(this.selectedSymbols.contains(symbol));
        }
    }

    private void resizeSymbolButtons() {
        Iterator iterator = this.symbolButtons.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            JToggleButton button = (JToggleButton)mapEntry.getValue();
            button.setPreferredSize(this.maxSize);
        }
    }

    public void addOKActionListener(ActionListener al) {
        this.okButton.addActionListener(al);
    }

    public void addCancelActionListener(ActionListener al) {
        this.cancelButton.addActionListener(al);
    }

    public void setAvailableSymbols(SymbolSet symbols) {
        this.availableSymbols = symbols;
        this.setupButtons();
        this.refreshSelections();
    }

    public void setSelectedSymbols(SymbolSet selected) {
        this.selectedSymbols = selected;
        this.refreshSelections();
    }

    public void toggled(ActionEvent e) {
        JToggleButton b = (JToggleButton)e.getSource();
        Character symbol = new Character(b.getText().charAt(0));
        if (b.isSelected()) {
            if (this.selectedSymbols.contains(symbol)) {
                this.removed.remove(symbol);
            } else {
                this.added.add(symbol);
            }
        } else if (this.selectedSymbols.contains(symbol)) {
            this.removed.add(symbol);
        } else {
            this.added.remove(symbol);
        }
    }

    public void finished(ActionEvent e) {
        Character[] symbols = new Character[this.removed.size()];
        Iterator iterator = this.removed.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            symbols[i] = (Character)iterator.next();
            ++i;
        }
        this.removed.clear();
        try {
            this.selectedSymbols.removeSymbols(symbols);
        }
        catch (SymbolChangeException sce) {
            // empty catch block
        }
        symbols = new Character[this.added.size()];
        iterator = this.added.iterator();
        i = 0;
        while (iterator.hasNext()) {
            symbols[i] = (Character)iterator.next();
            ++i;
        }
        this.added.clear();
        try {
            this.selectedSymbols.addSymbols(symbols);
        }
        catch (SymbolChangeException sce) {
            // empty catch block
        }
    }

    public void cancelled(ActionEvent e) {
        this.added.clear();
        this.removed.clear();
        this.refreshSelections();
    }

    public void aboutToAddSymbols(VetoableSymbolEvent e) {
    }

    public void symbolsAdded(SymbolEvent e) {
        boolean sizeChanged = false;
        Iterator iterator = e.getSymbols();
        while (iterator.hasNext()) {
            Character symbol = (Character)iterator.next();
            JToggleButton b = new JToggleButton(symbol.toString());
            b.setBorderPainted(false);
            b.setMargin(this.margins);
            b.addActionListener(this.action);
            if (this.selectedSymbols.contains(symbol)) {
                b.setSelected(true);
            }
            Dimension curSize = b.getPreferredSize();
            if (curSize.width > this.maxSize.width) {
                this.maxSize.width = curSize.width;
                sizeChanged = true;
            }
            if (curSize.height > this.maxSize.height) {
                this.maxSize.height = curSize.height;
                sizeChanged = true;
            }
            this.symbolButtons.put(symbol, b);
            this.selectionPanel.add(b);
        }
        if (sizeChanged) {
            this.resizeSymbolButtons();
        }
        this.selectionPanel.validate();
    }

    public void aboutToRemoveSymbols(VetoableSymbolEvent e) {
    }

    public void symbolsRemoved(SymbolEvent e) {
        Iterator iterator = e.getSymbols();
        while (iterator.hasNext()) {
            JToggleButton b = (JToggleButton)this.symbolButtons.get(iterator.next());
            this.selectionPanel.remove(b);
        }
        this.selectionPanel.validate();
    }

    public SymbolUser getAvailableSymbols() {
        return this.availableSymbols;
    }

    public SymbolSet getSelectedSymbols() {
        return this.selectedSymbols;
    }
}

