 


/**
 * Write a description of class DevolopFrame here.
 * 
 * Katie Walsh
 * @version (a version number or a date)
 */


import javax.swing.*;
import javax.swing.Timer.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import javax.swing.event.*;
import java.util.Vector;
import java.io.*;
import java.util.StringTokenizer;
import java.util.List;
import java.util.Iterator;

import org.jdom.*;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

import FSAComponents.*;

public class DevelopFrame extends JFrame implements ActionListener,
                                              ChangeListener
{
    private JMenuBar menuBar;
    private JMenu openMenu,fileMenu,exerciseMenu;
    private JToolBar toolbar;
    private JButton newButton,openButton,saveButton,submitExampleButton;
    private JButton runButton,stepButton,pauseButton,clearExampleButton;
    private JButton submitButton,clearButton,submitLangButton,clearLangButton;
    private JButton enterButton, deleteButton,editButton,submitAuxButton;
    private JButton forwardArrowButton,forwardArrowButton2,backArrowButton,
                                           backArrowButton2;
    private JPanel examplePanel,runPanel,regExpressionPanel,auxRegExpPanel,
                   exercisePanel;
                                            
    private JComboBox colorBox,fontBox,fontSizeBox,fontStyleBox,expTypeBox;

    private JTabbedPane tabbedPane;
    private JFileChooser chooser;

    /*this text field is on the reg expression tabbed pane */
    private JTextField expressionField;

    //text areas below for example tabbed pane
    private JTextArea languageArea,expArea,explArea;

    //text areas below for run example tabbed pane
    private JTextArea explArea2,regExpArea,langArea;
    
    //text areas below used in reg expression tabbed pane
    private JTextArea regLanguageArea;

    /*components used in auxillary tabbed pane*/
    private JTextArea helpArea;
    private JTextField auxField,auxExpField,finalAuxField,finalAuxExpr;
    private JList exprList;
    
 
    /*fonts types, styles and size for all text areas */
    private int fontSize,fontStyle;
    private String fontType;
    private Font defaultFont = new Font("Times Roman",Font.PLAIN,12);
    private String [] colors = {"black","blue","red","green"};
    private String [] fileItems ={"Open","Save","Quit"};
    private String [] fontTypes = {"Times Roman","Serif","Dialog","Helvetica"};
    private String [] sizes = {"12","10","14","16","18"};
    private String [] fontStyles = {"Plain","Bold","Italic"};
    private String langFontStyle,exprFontStyle,explFontStyle;
    private int langFontType,exprFontType,explFontType;
    private int langFontSize,exprFontSize,explFontSize;

   /*fonts for language areas,and step areas */
    private Font languageFont; 
    private Font exprFont; 
    private Font explFont; 

  
  
    Insets toolbarInsets = new Insets(0,0,0,300);
    private boolean auxillary = false;
    private boolean example = false;  //if make example steps no that it
                              //it should be put in expression menu

    /*these two variables are to test if user has defined an ebnf and standard
      expression for a given language.  for run buttonon pop up menu will
      give the choice of which ever are true for user to choose from
    */
    private boolean standardType,ebnfType,hitOpenButton;
    private boolean standSize,ebnfSize,isStand,isEbnf;
    private boolean hitSubmitAux = false;
    private DefaultListModel model;
   
    /*vector of all regular new regualar expressions, add to 
      vector is just a safety vector that will hold all new expressions
      creates (all examples),might use to create XML doc.  every time
      user hits new icon button expression gets added to vector
    */
    private Vector exprVector = new Vector();  //might not need

    /* declare regExpression object - this object will hold all 
       attributres associated with each created expression
    */
    private RegExpression expression;

    /* timer variable */
    private Timer timer;

    /*printwriter creates XML files, write objects to file */
     private PrintWriter out;
     private File f;


    /* 
       these are the indexes that will be used to indicate where
       in vector to locate certain steps for expression area and
       explanation area
    */
    private int hitOpen = 0;
    int exprStepIndex = 0;
    int explStepIndex = 0;
    int index =0,index2 =0;
    int newExp = 1;
    int ONE_SECOND = 1000;
    int count = 0; //used for stepping thru expression in run panel
    int numClicks =0,beenHere = 0;
    int listIndex =1; //this is used to index into list of explanations
                      //set default to first explanation set
    int numExplanations =0;
    Color c = new Color(223,196,238);
    Color purple = c.darker();
   
    /*these variables are for loading an example - set in loadExample() */
    private String loadType; //either standard or ebnf
    private int standardNum,ebnfNum; //which explanation to load
   
    /*make sure user hits save button after has entered in whole expression
      if not, when trys to create new example, popup menu pops up
      to remind user
    */
    boolean hitSaveButton = false;
    private String expressionType; //used for run panel, for step exp
    private String exprTypeButton;
    
    /*these vectors are used for when user loads in a file that is
     * an example, vectors hold steps. The int index is for when an example is
     * loaded.  and the user uses the arrow buttons to go forward and
     * back will have to index into the vector that has all the steps
     */
    private Vector explanations,expressions,ebnfExplanations,ebnfExpressions;
    private int explanationIndex,expressionIndex;
    
   
    //File directory = new File("D:\\bluej");
    File directory = new File("C:\\pascoe");
    
    /*where icons are located */
    //String buttonPath = "D:\\bluej\\KatieSource";
    String buttonPath = "C:\\pascoe\\research03\\regexpsimulator\\katiesource\\developer";
    Icon 
      
       /*
       newIcon = new ImageIcon(buttonPath + "\\buttons/new.gif"),
       openIcon = new ImageIcon(buttonPath + "\\buttons/open.gif"),
       saveIcon = new ImageIcon(buttonPath + "\\buttons/disk.gif"),
       backArrowIcon = new ImageIcon(buttonPath + "\\buttons/arrow_left.gif"),
       forwardArrowIcon = new ImageIcon(buttonPath + "\\buttons/arrow.gif"),
       backArrowIcon2 = new ImageIcon(buttonPath + "\\buttons/arrow_left2.gif"),
       forwardArrowIcon2 = new ImageIcon(buttonPath + "\\buttons/arrow2.gif");
   */
       newIcon = new ImageIcon("buttons/new.gif"),
       openIcon = new ImageIcon("buttons/open.gif"),
       saveIcon = new ImageIcon("buttons/disk.gif"),
       backArrowIcon = new ImageIcon("buttons/arrow_left.gif"),
       forwardArrowIcon = new ImageIcon("buttons/arrow.gif"),
       backArrowIcon2 = new ImageIcon("buttons/arrow_left2.gif"),
       forwardArrowIcon2 = new ImageIcon("buttons/arrow2.gif");
   
   
    public DevelopFrame()
    {
       //System.out.println(System.getProperty("java.vendor.url"));
        
       setTitle("Regular Expression Developer");
       
       addWindowListener(new WindowAdapter()
       {  public void windowClosing(WindowEvent e)
          {
             System.exit(0);
          }
       });

       Toolkit tk = Toolkit.getDefaultToolkit();
       Dimension d = tk.getScreenSize();
       int height = d.height;
       int width = d.width;
       loadType = "";
       setLocation(width/5,height/5);

       setSize(666,550);

  
      /*intsantiate expression object, put all new objects into vector
        create new object when user hits new button on tool bar or
        new from file menu
      */
       expression = new RegExpression();
       expressionType = "standard";
       expression.setStandard(true);
       standardType = true;
       ebnfType = false;
       hitOpenButton = false;
       
      chooser = new JFileChooser();
      
      chooser.setCurrentDirectory(directory);
       /*for JList on auxillary expression tabbed pane */
       model = new DefaultListModel();

       /*set default fonts variables */
      
       langFontStyle = "Monospaced";
       exprFontStyle= "Times Roman";
       explFontStyle= "Times Roman";

       langFontType = Font.PLAIN;
       exprFontType = Font.PLAIN;
       explFontType = Font.PLAIN;

       langFontSize = 12;
       exprFontSize = 12;
       explFontSize = 12;

       languageFont = new Font(langFontStyle,langFontType,
                                              langFontSize);
       exprFont = new Font(exprFontStyle,exprFontType,
                                              exprFontSize);
       explFont = new Font(explFontStyle,explFontType,
                                              explFontSize);

     
       /* sets the file menu bar*/
       menuBar = new JMenuBar();
       setJMenuBar(menuBar);
       openMenu = new JMenu("Example");
       exerciseMenu = new JMenu("Exercise");
       
       openMenu.setBackground(purple);
       exerciseMenu.setBackground(purple);

       
      
       constructMenu("file",fileItems);
       menuBar.add(openMenu);
       menuBar.add(exerciseMenu);
       menuBar.setBackground(purple);
       /*set up buttons for tool bar*/
       newButton = new JButton(newIcon);
       newButton.addActionListener(this);
       newButton.setActionCommand("newButton");
       newButton.setToolTipText("new example/exercise");
 

       openButton = new JButton(openIcon);
       openButton.addActionListener(this);
       openButton.setActionCommand("openButton");
       openButton.setToolTipText("open a file");

       saveButton = new JButton(saveIcon);
       saveButton.addActionListener(this);
       saveButton.setActionCommand("saveButton");
       saveButton.setToolTipText("save regular expression");

       /* set up Jcombo boxes for font controls */
       colorBox = new JComboBox();
       fontBox = new JComboBox();
       fontSizeBox = new JComboBox();
       fontStyleBox = new JComboBox();

       colorBox.setBackground(purple);
       fontBox.setBackground(purple);
       fontSizeBox.setBackground(purple);
       fontStyleBox.setBackground(purple);

        
       /*this combo box lets user choose between standard or EBNF */
       expTypeBox = new JComboBox();
       expTypeBox.setBackground(purple);
       expTypeBox.setFont(defaultFont);

       expTypeBox.addItem("standard");
       expTypeBox.addItem("EBNF");
       
       
       /*need to get selected item to set expressionType, based on 
         what user selected in combo box
       */
       expTypeBox.addActionListener(new ActionListener(){
          public void actionPerformed(ActionEvent evt){
             
             String arg = (String)expTypeBox.getSelectedItem();
             expressionType = arg;

             /*reset these variables, which are used for forward and 
               back arrow buttons, on example tabbed pane.  user is
               chooseing another expression type, reset
             */
             index=0; index2 =0;exprStepIndex=0;explStepIndex =0;
             
             /*clear description of reg expression fields, ie
              * auxillary expressions,submit expression,
              * submit aux expression
              */
           
                /*put opening text in */
              helpArea.setText("Create auxillary expression above "
                  + "and hit enter button");
              auxField.setText("");
              auxExpField.setText("");
        
              finalAuxExpr.setText("");
              DefaultListModel model = (DefaultListModel)exprList.getModel();
              /*remove all list items*/
              model.removeAllElements();
              
              expressionField.setText("");
              

             if(expressionType.equals("standard"))
             {
                standardType = true;
                expression.setStandard(true);
              
             }
             else
             {
                ebnfType = true;
                expression.setEBNF(true);
               
             
             }
          }
       });

      
       
       /* add items to combo box's */      
       addComboBoxItems(fontBox,fontTypes);
       addComboBoxItems(fontSizeBox,sizes);
       addComboBoxItems(fontStyleBox,fontStyles);
       addComboBoxItems(colorBox,colors);

       

       /* set up tool bar */
       toolbar = new JToolBar();
      
       toolbar.setMargin(toolbarInsets);
       toolbar.add(newButton);
       toolbar.add(openButton);
       toolbar.add(saveButton);
       toolbar.add(fontBox);
       toolbar.add(fontStyleBox);
       toolbar.add(fontSizeBox);
       toolbar.add(colorBox);
       toolbar.add(expTypeBox);

       /* set up tabbed panes */
       tabbedPane = new JTabbedPane();
      
       /*functin call adds components to create an example */
    
       regExpressionPanel = addRegExpressionComponents();
       auxRegExpPanel = addAuxillaryComponents();
       examplePanel = addExamplePanelComponents();
       runPanel = addRunPanelComponents();

      
       tabbedPane.add("create example",examplePanel);
       tabbedPane.addTab("run example",runPanel);
       tabbedPane.add("create exercise",regExpressionPanel);
       tabbedPane.add("auxillary expression",auxRegExpPanel);
       tabbedPane.addChangeListener(this);

     //  when timer starts this runs, for run button 
       timer = new Timer(ONE_SECOND, new ActionListener()
       {
 
         public void actionPerformed(ActionEvent evt)
         {
            if(expressionType.equals("standard"))
            {
              if(count == expression.getExprStepSize())
              {
                 timer.stop();
                 regExpArea.setForeground(Color.red);
                 count = 0;
                 numClicks = 0; //reset

                 pauseButton.setBackground(purple);
                 stepButton.setEnabled(true);
                 runButton.setEnabled(true);
              }
              else
              {
                 
                stepExpression();
              }
            }
            else  //ebnf
            {
  
              if(count == expression.getEbnfExprStepSize())
              {
                 timer.stop();
                 regExpArea.setForeground(Color.red);
                 count = 0;
                 numClicks = 0; //reset
               
              }
              else
                stepExpression();
            }
         
      
       }});
      
       getContentPane().add(toolbar,BorderLayout.NORTH);
       getContentPane().add(tabbedPane,BorderLayout.CENTER);
      
    }

    /**************************************************************************
    when step button is pressed this function is called. It steps through 
    the expression and displays expression step at a time in text area.
   **************************************************************************/ 
   public void stepExpression()
   { 
   
       if(expressionType.equals("standard"))
       { 
           /*get the vector of all steps */
           Vector expressionStepVector = expression.getExprVector();
           Vector explanationStepVector = expression.getExplVector();
           int stepVectorSize = expressionStepVector.size();


           if(count == stepVectorSize)   //no more steps
           {

              regExpArea.setForeground(Color.red);
              count = 0;
           }

           else  //display the text  ****get from vector
           {  
               
              regExpArea.setText((String)expressionStepVector.elementAt(count));
              explArea2.setText((String)explanationStepVector.elementAt(count));
              count++;
             
           }
       }//end if standard

       else //Ebnf
       {
          /*get the vector of all steps */
           Vector expressionStepVector = expression.getEbnfExprVector();
           Vector explanationStepVector = expression.getEbnfExplVector();
           int stepVectorSize = expressionStepVector.size();


           if(count == stepVectorSize)   //no more steps
           {

              regExpArea.setForeground(Color.red);
              count = 0; //reset
           }

           else  //display the text  ****get from vector
           {  
               
              regExpArea.setText((String)expressionStepVector.elementAt(count));
              explArea2.setText((String)explanationStepVector.elementAt(count));
              count++;
             
           }
       }//end if standard
    }

/**************************************************************************/
    private JPanel addRegExpressionComponents()
    {
       GridBagLayout gbl = new GridBagLayout();
       GridBagConstraints gbc = new GridBagConstraints();

       
       expressionField= new JTextField(35);
       expressionField.setFont(new Font("Arial",Font.BOLD,12));
       submitButton = new JButton("submit");
       submitButton.addActionListener(this);
       submitButton.setActionCommand("submitexp");
       submitButton.setBackground(purple);
      

       clearButton = new JButton("clear");
       clearButton.addActionListener(this);
       clearButton.setActionCommand("clearexp");
       clearButton.setBackground(purple);
      

       submitLangButton = new JButton("submit");
       submitLangButton.addActionListener(this);
       submitLangButton.setActionCommand("submitLang");
       submitLangButton.setBackground(purple);
       
       clearLangButton = new JButton("clear");
       clearLangButton.addActionListener(this);
       clearLangButton.setActionCommand("clearlang");
       clearLangButton.setBackground(purple);
     
      
       JPanel bottomPanel = new JPanel();
       bottomPanel.setLayout(gbl);
       bottomPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("regular expression"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

      
      

      
       JLabel languageLabel = new JLabel("           Enter Language here ->",
                     SwingConstants.RIGHT);

       JLabel exprLabel = new JLabel("Enter Regular Expression: ");
       exprLabel.setLabelFor(expressionField);

      
       
       gbc.fill = GridBagConstraints.HORIZONTAL;
       gbc.anchor = GridBagConstraints.WEST;
       gbc.gridwidth = 1;
       bottomPanel.add(exprLabel,gbc);
       bottomPanel.add(Box.createHorizontalStrut(10));
       gbc.gridwidth = GridBagConstraints.REMAINDER;
       bottomPanel.add(expressionField,gbc);
      
   
       ButtonPanel buttonPanel =new ButtonPanel();
       
     
       buttonPanel.add(submitButton);
       buttonPanel.add(clearButton);

       gbc.anchor= GridBagConstraints.SOUTH;
       gbc.insets = new Insets(15,0,0,0);
       gbc.fill = GridBagConstraints.HORIZONTAL;
       gbc.gridwidth = 7;
       bottomPanel.add(buttonPanel,gbc);
 
       
       regLanguageArea = new JTextArea(5,40);
       regLanguageArea.setEditable(true);
       regLanguageArea.setLineWrap(true);
       regLanguageArea.setWrapStyleWord(true);
       regLanguageArea.setMargin(new Insets(10,5,5,5));
       regLanguageArea.setFont(defaultFont);

       languageLabel.setLabelFor(regLanguageArea);

        
        JScrollPane languageScrollPane = new JScrollPane(regLanguageArea);
        languageScrollPane.setPreferredSize(new Dimension(
                                      regLanguageArea.getPreferredSize()));

        languageScrollPane.setVerticalScrollBarPolicy(
                                      JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

        JPanel bPanel =new JPanel();
       
        bPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        bPanel.setBorder(BorderFactory.createEmptyBorder(0,110,0,0));
        
        bPanel.add(submitLangButton);
        bPanel.add(clearLangButton);

        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new BorderLayout());
        languagePanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("Language"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

       
        languagePanel.add(languageLabel,"West");
        languagePanel.add(languageScrollPane,"East");
        languagePanel.add(bPanel,"South");
         
   
        JPanel finalPanel = new JPanel();
        finalPanel.setLayout(new BoxLayout(finalPanel,BoxLayout.Y_AXIS));
        finalPanel.add(languagePanel);
        finalPanel.add(bottomPanel);
 
        return finalPanel;

    }
/************************************************************************
 *  this function just adds all the comonents that are see on the 
 *  auxillary reg expression tabbed pane
 *  **********************************************************************/
    private JPanel addAuxillaryComponents()
    {
     
       Font exprNameFont = new Font("Arial",Font.BOLD,12);
       JLabel aux = new JLabel("Enter Auxillary:");
       JLabel equals = new JLabel("=");
       JLabel regExpr = new JLabel("Enter Final regular Expression: ");
       
       enterButton = new JButton("enter");
       enterButton.addActionListener(this);
       enterButton.setActionCommand("enter");
       enterButton.setMargin(new Insets(2,5,2,5));
       enterButton.setBackground(purple);
       
  
       deleteButton = new JButton("delete");
       deleteButton.addActionListener(this);
       deleteButton.setActionCommand("delete");
       deleteButton.setBackground(purple);
      
       editButton = new JButton("edit");
       editButton.addActionListener(this);
       editButton.setActionCommand("edit");
       editButton.setBackground(purple);
       
       submitAuxButton = new JButton("submit final expression");
       submitAuxButton.addActionListener(this);
       submitAuxButton.setActionCommand("submitAux");
       submitAuxButton.setBackground(purple);

       helpArea = new JTextArea(5,25);
       helpArea.setEditable(false);
       helpArea.setLineWrap(true);
       helpArea.setWrapStyleWord(true);
       helpArea.setMargin(new Insets(5,5,5,5));
       helpArea.setForeground(Color.red);
       helpArea.setFont(exprNameFont);

       /*put opening text in */
       helpArea.setText("Create auxillary expression above "
                  + "and hit enter button.");

       JScrollPane helpScrollPane = new JScrollPane(helpArea);

       /*this text field is for the name of expression
         e.g letter = A|Bet
       */
       auxField =new JTextField(10);
       auxField.setEditable(true);
       auxField.setForeground(Color.blue);
       auxField.setFont(exprNameFont);

       /*this text field is for the def. of the expressoion from 
         above text field
       */
       auxExpField = new JTextField(30);
       auxExpField.setEditable(true);
       auxExpField.setFont(exprNameFont);
      
       /* this is for the definition of final expression */
       finalAuxExpr = new JTextField(40);
       finalAuxExpr.setEditable(true);
       finalAuxExpr.setFont(exprNameFont);

      
       /*setting up JList area */
   
       Font listFont = new Font("Arial",Font.BOLD,12);
       exprList = new JList();
       exprList.setBackground(Color.white);
       exprList.setFont(listFont);
       exprList.setFixedCellWidth(600);

       /*set default list model for JList */
      
       exprList.setModel(model);

    

       JScrollPane listScrollPane = new JScrollPane(exprList);
       
       /*set  homw many rowas are visible in JList */
       exprList.setVisibleRowCount(5);
   
        /* jList will go onto this panel */
       JPanel listPanel =new JPanel();
      
       listPanel.setLayout(new GridLayout(1,1));
       listPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("Auxillary expressions"),
                   BorderFactory.createEmptyBorder(5,10,5,10)));


       listPanel.add(listScrollPane);

       /*set up panel that will hold text fields */
       JPanel textFieldPanel = new JPanel();
    
       GridBagLayout gbl = new GridBagLayout();
       GridBagConstraints gbc = new GridBagConstraints();
       textFieldPanel.setLayout(gbl);
       textFieldPanel.setBorder(BorderFactory.createEmptyBorder(10,0,10,0));

       gbc.gridwidth =1;
       gbc.anchor = GridBagConstraints.WEST;
       gbc.fill = GridBagConstraints.HORIZONTAL;

       /*add aux label and text field */
       textFieldPanel.add(aux,gbc);
       textFieldPanel.add(Box.createHorizontalStrut(10));
       textFieldPanel.add(auxField,gbc);

       /*add = label and exp text field */
       textFieldPanel.add(Box.createHorizontalStrut(10));
       textFieldPanel.add(equals,gbc);
       textFieldPanel.add(Box.createHorizontalStrut(5));

       gbc.gridwidth = GridBagConstraints.REMAINDER;
       gbc.fill = GridBagConstraints.NONE;
       textFieldPanel.add(auxExpField,gbc);
 
       
       /* put buttons on a panel */
       JPanel buttonPanel = new JPanel();
       buttonPanel.setLayout(new GridLayout(3,1,3,3));
       buttonPanel.setBorder(BorderFactory.createEmptyBorder(5,0,5,15));
       buttonPanel.add(enterButton);
       buttonPanel.add(deleteButton);
       buttonPanel.add(editButton);

       /*final aux expression panel */
       GridBagLayout auxGbl = new GridBagLayout();
       GridBagConstraints auxGbc = new GridBagConstraints();
       JPanel auxExpressionPanel = new JPanel();
       auxExpressionPanel.setBorder(BorderFactory.createEmptyBorder(10,0,0,0));
       auxExpressionPanel.setLayout(auxGbl);

       auxGbc.gridwidth =1;
       auxGbc.anchor = GridBagConstraints.WEST;
       auxGbc.fill = GridBagConstraints.HORIZONTAL;
       auxExpressionPanel.add(regExpr,auxGbc); //add label
       auxExpressionPanel.add(Box.createHorizontalStrut(10));
     

       auxGbc.gridwidth = GridBagConstraints.REMAINDER;
       auxGbc.fill = GridBagConstraints.NONE;
       auxExpressionPanel.add(finalAuxExpr,auxGbc);

       ButtonPanel submitButtPanel = new ButtonPanel();
       submitButtPanel.add(submitAuxButton);

       auxGbc.anchor = GridBagConstraints.SOUTH;
       auxGbc.insets = new Insets(15,0,0,0);
       auxGbc.gridwidth = 7;
       auxExpressionPanel.add(submitButtPanel,auxGbc);
       
       /* set up panel to hold help text area */
       JPanel helpPanel = new JPanel();
     
       helpPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("help"),
                   BorderFactory.createEmptyBorder(5,10,5,10)));
       helpPanel.add(helpScrollPane);
      
       JPanel middlePanel = new JPanel();
       middlePanel.setLayout(new BorderLayout());
       middlePanel.add(buttonPanel,"West");
       middlePanel.add(helpPanel,"East");
       JPanel finalPanel = new JPanel();
       
       finalPanel.add(listPanel);
       finalPanel.add(textFieldPanel);
       finalPanel.add(middlePanel);
       finalPanel.add(auxExpressionPanel);
      
       return finalPanel;
    }
    
  /**********************************************************************/ 
   
    private JPanel addExamplePanelComponents()
    {
        JLabel languageLabel = new JLabel("               Enter Language ->",
                     SwingConstants.RIGHT);
     
        /*button to submit the language */
        submitExampleButton = new JButton("submit");
        submitExampleButton.setActionCommand("submitExample");
        submitExampleButton.addActionListener(this);
        submitExampleButton.setBackground(purple);
        
          /*button to clear the language */
        clearExampleButton = new JButton("clear");
        clearExampleButton.setActionCommand("clearExample");
        clearExampleButton.addActionListener(this);
        clearExampleButton.setBackground(purple);

        backArrowButton = new JButton(backArrowIcon);
        backArrowButton.addActionListener(this);
        backArrowButton.setActionCommand("backRegExp");

        forwardArrowButton = new JButton(forwardArrowIcon);
        forwardArrowButton.addActionListener(this);
        forwardArrowButton.setActionCommand("forwardRegExp");

        backArrowButton2 = new JButton(backArrowIcon2);
        backArrowButton2.addActionListener(this);
        backArrowButton2.setActionCommand("backExpl");

        forwardArrowButton2 = new JButton(forwardArrowIcon2);
        forwardArrowButton2.addActionListener(this);
        forwardArrowButton2.setActionCommand("forwardExpl");

        languageArea = new JTextArea(5,40);
        languageArea.setEditable(true);
        languageArea.setLineWrap(true);
        languageArea.setWrapStyleWord(true);
        languageArea.setMargin(new Insets(10,5,5,5));

        languageLabel.setLabelFor(languageArea);

        explArea = new JTextArea(5,18);
        explArea.setEditable(true);
        explArea.setLineWrap(true);
        explArea.setWrapStyleWord(true);
        explArea.setMargin(new Insets(5,5,5,5));
        explArea.setFont(explFont);

      

        expArea = new JTextArea(5,30);
        expArea.setEditable(true);
        expArea.setLineWrap(true);
        expArea.setWrapStyleWord(true);
        expArea.setMargin(new Insets(5,5,5,5));
        expArea.setFont(exprFont);

       
        JScrollPane languageScrollPane = new JScrollPane(languageArea);
        languageScrollPane.setPreferredSize(new Dimension(
                                      languageArea.getPreferredSize()));

        languageScrollPane.setVerticalScrollBarPolicy(
                                      JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);


       /*set up panel to add language label and lang text areas */
        JPanel languagePanel = new JPanel();
        JPanel bPanel =new JPanel();
        bPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
        bPanel.setBorder(BorderFactory.createEmptyBorder(0,200,0,0));
        
        bPanel.add(submitExampleButton);
        bPanel.add(clearExampleButton);
       
        languagePanel.setLayout(new BorderLayout());
        languagePanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("Language"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

        /* add components to panel */
        languagePanel.add(languageLabel,"West");
        languagePanel.add(languageScrollPane,"East");
        languagePanel.add(bPanel,"South");

        /* 
           add explanation area to scroll pane, and scroll pane for
           expression area 
        */
        JScrollPane regExpScrollPane = new JScrollPane(expArea);
        regExpScrollPane.setHorizontalScrollBarPolicy(
                         JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        regExpScrollPane.setPreferredSize(
                         new Dimension(expArea.getPreferredSize()));

        /*set up scrollpane to hold explanation text Area */
        JScrollPane explScrollPane = new JScrollPane(explArea);
        explScrollPane.setVerticalScrollBarPolicy(
                            JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        explScrollPane.setPreferredSize(
                         new Dimension(explArea.getPreferredSize()));

        
        /*create some button Panels to add arrow buttons */
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(backArrowButton);
        buttonPanel.add(forwardArrowButton);

        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new FlowLayout());
        buttonPanel2.add(backArrowButton2);
        buttonPanel2.add(forwardArrowButton2);

        /*
            this panel will hold expression textArea and
            forward and backwards button
        */
        JPanel regularExpressionPanel = new JPanel();
        regularExpressionPanel.setLayout(new BorderLayout());
        regularExpressionPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("Regular Expression steps"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

         /*
            this panel will hold explanation textArea and
            forward and backwards button
        */
        JPanel explanationPanel = new JPanel();
        explanationPanel.setLayout(new BorderLayout());
        explanationPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("explanation steps"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

    
 
        explanationPanel.add(explScrollPane,"Center");
        explanationPanel.add(buttonPanel2,"South");

        regularExpressionPanel.add(regExpScrollPane,"Center");
        regularExpressionPanel.add(buttonPanel,"South");

        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel,BoxLayout.X_AXIS));
        bottomPanel.add(explanationPanel);
        bottomPanel.add(regularExpressionPanel);

        JPanel finalPanel = new JPanel();
        finalPanel.setLayout(new BoxLayout(finalPanel,BoxLayout.Y_AXIS));
        finalPanel.add(languagePanel);
        finalPanel.add(bottomPanel);


        return finalPanel;
     
    }
/***********************************************************************
 * components that are on rune xample tabbed pan
 * *********************************************************************/
    private JPanel addRunPanelComponents()
    {
   
      JPanel topPanel= new JPanel();
      JPanel bottomPanel = new JPanel();
      JPanel buttonPanel = new JPanel();
      JPanel explanationPanel = new JPanel();
      JPanel expressionPanel = new JPanel();

    
      buttonPanel.setLayout(new GridLayout(5,1,0,3));
      topPanel.setLayout(new BorderLayout());
      bottomPanel.setLayout(new BoxLayout(bottomPanel,BoxLayout.X_AXIS));
      explanationPanel.setLayout(new GridLayout(1,1));
      expressionPanel.setLayout(new GridLayout(1,1));

      topPanel.setBorder(BorderFactory.createEmptyBorder(20,50,25,20));
      bottomPanel.setBorder(BorderFactory.createEmptyBorder(5,5,50,5));

      explanationPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("explanation steps"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

      expressionPanel.setBorder(
             BorderFactory.createCompoundBorder(
                   BorderFactory.createTitledBorder("Regular Expression steps"),
                   BorderFactory.createEmptyBorder(5,5,5,5)));

     /*initialize buttons */

      runButton = new JButton("run");
      runButton.setActionCommand("run");
      runButton.addActionListener(this);
      runButton.setBackground(purple);
    
      stepButton = new JButton("step");
      stepButton.setActionCommand("step");
      stepButton.addActionListener(this);
      stepButton.setBackground(purple);
    
      pauseButton = new JButton("pause");
      pauseButton.addActionListener(this);
      pauseButton.setActionCommand("pause");
      pauseButton.setBackground(purple);
     
 
     
      buttonPanel.add(stepButton);
      buttonPanel.add(Box.createHorizontalStrut(3));
      buttonPanel.add(runButton);
      buttonPanel.add(Box.createHorizontalStrut(3));
      buttonPanel.add(pauseButton);
      buttonPanel.add(Box.createHorizontalStrut(3));
     
    
     /*set up text areas */
      explArea2 = new JTextArea(8,18);
      explArea2.setEditable(false);
      explArea2.setLineWrap(true);
      explArea2.setWrapStyleWord(true);

      regExpArea= new JTextArea(8,30);
      regExpArea.setEditable(false);
      regExpArea.setLineWrap(true);
      regExpArea.setWrapStyleWord(true);

      langArea = new JTextArea(5,45);
      langArea.setEditable(false);
      langArea.setLineWrap(true);
      langArea.setWrapStyleWord(true);


      explArea2.setMargin(new Insets(5,5,5,5));
      explArea2.setFont(explFont);

     
      regExpArea.setMargin(new Insets(5,5,5,5));
      regExpArea.setFont(exprFont);
      

      langArea.setMargin(new Insets(10,5,5,5));
      langArea.setFont(defaultFont);
     

     /*set up scroll panes for language text area */
      JScrollPane languageScrollPane = new JScrollPane(langArea);
      languageScrollPane.setPreferredSize(new Dimension(
                                      langArea.getPreferredSize()));

      languageScrollPane.setVerticalScrollBarPolicy(
                                      JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

      JScrollPane regularExpScrollPane = new JScrollPane(regExpArea);
      regularExpScrollPane.setHorizontalScrollBarPolicy(
                         JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
      regularExpScrollPane.setPreferredSize(
                         new Dimension(regExpArea.getPreferredSize()));

      JScrollPane explScrollPane = new JScrollPane(explArea2);
      explScrollPane.setVerticalScrollBarPolicy(
                         JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    
      explScrollPane.setPreferredSize(
                        new Dimension(explArea.getPreferredSize()));

      explanationPanel.add(explScrollPane);
      expressionPanel.add(regularExpScrollPane);

      /* add all components onto some more panels*/
      topPanel.add(buttonPanel,"West");
      topPanel.add(languageScrollPane,"Center");
      bottomPanel.add(explanationPanel);
      bottomPanel.add(expressionPanel);

      JPanel finalRunPanel = new JPanel();
      
      finalRunPanel.setLayout(new BoxLayout(finalRunPanel,BoxLayout.Y_AXIS));
      finalRunPanel.add(topPanel,"North");
      finalRunPanel.add(bottomPanel,"South");

      return finalRunPanel;
    }
/**************************************************************************/
    private void addComboBoxItems(JComboBox box, String [] items)
    {
        int length = items.length;
        box.setEditable(false);
        box.setFont(defaultFont);
        box.addActionListener(this);


        for(int i = 0; i < length; i++)
        {
            box.addItem(items[i]);
        }
     }
 /***********************************************************************
    construct a menu on menu bar, or submenu.  Take a string which will
    be the title of the menu and then an array of items that will be in
    the menu
   **********************************************************************/
    private void constructMenu(String title,String [] items)
    {
        
        fileMenu = new JMenu(title);
        fileMenu.setBackground(purple);
       
        /*construct a submenu for New on file menue
          submenu will have options expression, explanation set
        */
        JMenu options = new JMenu("New");
        JMenuItem item3 = new JMenuItem("new example");
        item3.setFont(new Font("Dialog",Font.BOLD,12));
        item3.addActionListener(this);
        options.add(item3);
       
        
        JMenuItem item1 = new JMenuItem("explanation set");
        item1.setFont(new Font("Dialog",Font.BOLD,12));
        item1.addActionListener(this);
        options.add(item1);

        JMenuItem item2 = new JMenuItem("expression");
        item2.setFont(new Font("Dialog",Font.BOLD,12));
        item2.addActionListener(this);
        options.add(item2);
        
        
              
        fileMenu.add(options);
        
        /*create rest of items on file menu */
        for(int i = 0; i < items.length; i++)
        {
             JMenuItem menuItem = new JMenuItem(items[i]);

              menuItem.setFont(new Font("Dialog",Font.BOLD,12));
              fileMenu.add(menuItem);
              menuItem.addActionListener(this);
           
           
        }
      
        menuBar.add(fileMenu);
    }
/*************************************************************************/
    public int getFontType(String t)
    {
       int type = Font.PLAIN;
       if(t.equals("Plain"))
          type =Font.PLAIN; 

       if(t.equals("Bold"))
          type =Font.BOLD;

       if(t.equals("Italic"))
          type = Font.ITALIC;

       return type;
 
    }
/**************************************************************************/
    public int getFontSize(String s)
    {
       int size = 12;

       if(s.equals("10"))
         size = 10;
 
       if(s.equals("12"))
         size = 12;
       if(s.equals("14"))
         size = 14;

       if(s.equals("16"))
         size = 16;

       if(s.equals("18"))
         size = 18;
 
       return size;
    }
/***************************************************************************/
    public Color getFontColor(String fc)
    {
       Color color = Color.black;

       if(fc.equals("red"))
          color = Color.red;
  
       if(fc.equals("blue"))
          color = Color.blue;

       if(fc.equals("black"))
          color = Color.black;

       if(fc.equals("green"))
          color =(Color.green).darker();
  
       return color;
    }
  
/*************************************************************************/
    public void clearAllTextComponents()
    {
    
        //reset index variables for examples tabbed panes
         index=0; index2 =0;exprStepIndex=0;explStepIndex =0;
         standardType = false;
         ebnfType = false;
         hitSubmitAux = false;
         expressionType.equals("standard");
         openMenu.removeAll();
         exerciseMenu.removeAll();
        
        //reset all text Areas
         expArea.setText("");
         explArea.setText("");
         regLanguageArea.setText("");
         languageArea.setText("");
         langArea.setText("");
         helpArea.setText("");// mayabe reset to some text
         explArea2.setText("");
         regExpArea.setText("");

         /* reset all text fields */
         expressionField.setText("");
         auxField.setText("");
         auxExpField.setText("");
         finalAuxExpr.setText("");
       

         /*clear the Jlist area */
         model = (DefaultListModel)exprList.getModel();
         model.removeAllElements();
          
         expression.resetExplSteps();
         expression.resetExprSteps();
         expression.resetEbnfExprSteps();
         expression.resetEbnfExplSteps();
        
    }
   
  
    /******************************************************************
      Save to a file
    *******************************************************************/
     public void saveFile()
     {
         int result = chooser.showSaveDialog(submitLangButton);
         if(JFileChooser.APPROVE_OPTION ==result)
         {
             if(example == true)
             {
                 //if((loadType.equals("standard")) && (hitOpenButton == true))
                 if(beenHere > 0)
                 {
                     expression.addEditedExplToList(standardNum);
                     expression.addEditedExprToList(standardNum);
                      
                     hitOpenButton = false;
                     hitOpen = 0;
                     beenHere = 0;
                 }
                 else if((expression.getExprStepSize())>0)
                 {
                     expression.addExplToList(); //add vector of steps to list
                     expression.addExprToList(); //add explanations to list
                     loadExample();
                 }
                 expArea.setText("");
                 explArea.setText("");
             }
             File file  = chooser.getSelectedFile();
             f = new File(file.getPath());
             //clearAllTextComponents();
               
             try
             {
                 out = new PrintWriter(new FileOutputStream(f));
             }
             catch(IOException e)
             {
                 System.err.println("can't create printwriter");
                 System.exit(1);
             }
          
             writeToXMLFile();
             out.flush();
             out.close();
         }
     }
 /*******************************don't think need this********************/    
    /*******************************************************************
      This function gets called when a user picks an expression from the
      file drop down menu, open ->.  Reload picked expression, user can
      change if needs to
    ********************************************************************/
    public void openExpression(String arg)
    {
         StringTokenizer token = new StringTokenizer(arg);
         DefaultListModel model = (DefaultListModel)exprList.getModel();
 
         token.nextToken();
   
         /*this will get the expression user wants ie number */
         int num = Integer.parseInt(token.nextToken());
 
         RegExpression whichExp = 
                        (RegExpression)exprVector.elementAt(num-1);

         /*get that expression from vector of expressions */
         Vector auxList = whichExp.getAuxillaryVector();

         /*set appropriate text fields */
         regLanguageArea.setText(whichExp.getLanguage());

         /*set reg expression area back to its text also */
         if((whichExp.getAuxillary()==false))  //if no auxillarys
            expressionField.setText(whichExp.getFinalExpression());

         else //is an expression made up of auxillary expressions
         {
            finalAuxField.setText(whichExp.getName());
            finalAuxExpr.setText(whichExp.getFinalExpression());

            /*go thru vector and all each expression back to list*/
            for(int i =0; i<auxList.size(); i++)
            {
                AuxillaryExpression aux = (AuxillaryExpression)auxList.get(i);
                String addToList = aux.getName() + " = " + aux.getExpression();
                model.addElement(addToList);
             }

         }

    }
    /********************************************************************
     This function creates the XML file.  Calls the reg expression class
     print fucntions that will write out the tags followed by data
    **********************************************************************/
    public void writeToXMLFile()
    {
        /*write root tag */
         out.println("<?xml version = \"1.0\"?>");
         out.println("<RegularExpression>");
         RegExpression exp;

        /*print out all expressions created, which are in the 
          exprVector
        */
    
         expression.writeExpression(out);
      
         /* close root tag */
         out.println("</RegularExpression>");
       
       
    }
    /*****************************************************************
     if the user hits the open icon button, or open from file.  Opens
     the file that the user picks and fills up an expression object.
    *******************************************************************/
    public void openFile()
    {
         hitOpenButton = true;
         hitOpen++;
         
         String message = "Opening a new file will cause all unsaved work to be lost.\n" +
                          "Are you sure you want to open a new file?";
         
         int result = JOptionPane.showConfirmDialog(regLanguageArea, message);
      
         if(result == JOptionPane.OK_OPTION)
         {   
             index = 0;
             index2 = 0;
             explanationIndex = 1;
             expressionIndex = 1; //reseting
             
             
             clearAllTextComponents();
             expression = new RegExpression();
             hitSaveButton= false;
             /* result is the file chosen */
             int result2 = chooser.showOpenDialog(submitLangButton);
         
             try
             {
                if(result2 == JFileChooser.APPROVE_OPTION)
                {                         
                   File file = chooser.getSelectedFile();
                   String path = file.getPath();
                   FileInputStream fin = new FileInputStream(path);
                
                   if(file == null)
                     JOptionPane.showMessageDialog(null,"Invalid file Name");
                                                 
                   else
                   {
                       /*read in XML file */
                       SAXBuilder builder = new SAXBuilder(false);//don't validate
                       // Document jdomDoc = builder.build(new File(file.getPath()));
                       Document jdomDoc = builder.build(fin);
                   
                       Element root = jdomDoc.getRootElement();
                       Element example = root.getChild("regExpression")
                                          .getChild("example");
                   
                       String content = example.getTextTrim();
                   
                       if(content.equals("false")) //exercise
                           processExercise(jdomDoc,root);
                   
                       else// example
                           processExample(jdomDoc,root);
                   }
                } //enf id chose approve
                else  //hit cancel
                  hitOpen--;
              
              System.out.println(expression.printExprList());
              System.out.println(expression.printExplList());
              
              }
              catch(JDOMException e)
              {
                  e.printStackTrace();
              }
              catch(IOException e)
              {}
          }//end else
    }
    /**********************************************************************
     *  if user wants to open a file to edit or run and it is an
     *  exercise, load RegExpression object and load appropriate
     *  text fields
     *  *****************************************************************/
    
    public void processExercise(Document doc,Element root)
    {
           example = false;
           Element exercise = root.getChild("regExpression");
           String languageText = exercise.getChild("language")
                                   .getChildTextTrim("langText");
           
           /*first set up all the variables for this expression
            * object, then populate application fields
            */
            /*set up the language for example */
            expression.setLanguage(languageText); 
            
            /*set up the Font attributes for the language */
            List fontAttributes = exercise.getChild("language")
                                         .getChild("fontAttributes")
                                         .getChildren();
          
           /*iterate thru list ant set up font attribute fields for
            * language text
            * */
          
           Iterator iter = fontAttributes.iterator();
           setFontAttributes(iter,"language");
           
           String aux = exercise.getChildTextTrim("auxillary");
                                
           if(aux.equals("false")) //expression not made of auxillary exp
           {
               Element standard = exercise.getChild("standardDefinition");
               expression.setAuxillary(false);
               if(standard!=null)
               {
                  expression.setStandard(true);
                  expression.setFinalExpression(standard.getTextTrim(),"standard");
                }
                  
               Element ebnf = exercise.getChild("ebnfDefinition");
               if(ebnf !=null)
               {
                   expression.setEBNF(true);
                   expression.setFinalExpression(ebnf.getTextTrim(),"ebnf");
               }
                   
           }
           
           
           /*set the language text Area with text */
           loadExercise(aux,doc,exercise);
        
    }
    /**********************************************************************
     * load all the appropriate text areas - for this opened exercise
     * ********************************************************************/
     
     public void loadExercise(String aux,Document doc,Element root)
     {    
         regLanguageArea.setText(expression.getLanguage());
         
         if(aux.equals("false"))
         {
            /*this means that there is an ebnf def and standard def.
             * load choice on drop down exercise menu so user can
             * choose which to load
             */
            if((!expression.getFinalExpression().equals(""))&&
                              (!expression.getFinalEbnfExpression().equals("")))
            {
                JMenuItem standard = new JMenuItem("standard");
                JMenuItem ebnf = new JMenuItem("EBNF");
                
                exerciseMenu.add(standard);
                exerciseMenu.add(ebnf);
                
                /*load the expression with standard def to edit */
                standard.addActionListener(new ActionListener(){
                   public void actionPerformed(ActionEvent evt)
                   {
                      String arg = evt.getActionCommand();
                   
                      if(arg.equals("standard"))
                      {
                        expressionType="standard";
                        expressionField.setText(expression.getFinalExpression());
                      }
                     
                   }
                  });
                  ebnf.addActionListener(new ActionListener(){
                   public void actionPerformed(ActionEvent evt)
                   {
                      String arg = evt.getActionCommand();
           
                      expressionType ="ebnf";
                      expressionField.setText(expression.getFinalEbnfExpression());
                   }
                  });
                  
                        
                
             }//end if both tandard and ebnf are not null
             /*there is not an ebnf and standard definition so just load 
              * none to choose from
              */
             else
             {
                  if(!expression.getFinalExpression().equals(""))
                      expressionField.setText(expression.getFinalExpression());
                  else
                      expressionField.setText(expression.getFinalEbnfExpression());
             }
             
            
         
         }//end if aux = false
         else //auxillary reg expression
           loadAuxillaryExpression(doc,root);
         
     }
     /***********************************************************************
      * this function - is called when user is opening up an exercise
      * and the exercise is an expression that is made up of auxillary
      * expressions, so need to set correct text fields and object variables
      * *********************************************************************/
      public void loadAuxillaryExpression(Document doc, Element exercise)
      {
          Element standard = exercise.getChild("standard");
          expression.setAuxillary(true);
          
          boolean ebnfAux = false;
          boolean standAux = false;
          String[] array = new String [25];
          String [] ebnfArray = new String[25];
          int size=0, ebnfSize=0;
          
            /*put opening text in */
         helpArea.setText("Create auxillary expression above "
                  + "and hit enter button.");
          if(standard!=null)
          {
          
              String text = standard.getChild("exprName").getTextTrim();
              
          
              if(!text.equals(""))
              {
                String name = standard.getChild("exprName").getTextTrim();
                standAux = true;
                expression.setName(name);
             
              
                String def = standard.getChild("standardDefinition").getTextTrim();
                expression.setFinalExpression(def,"standard");
             
              
                /*get all the aux illary expressions that make up expression
                 * and set fields in class
                 */
                /*list of all the aux expressions*/
                 List auxExps = (List)standard.getChild("auxillaryExpression")
                                        .getChildren("auxExpression");
               
                 Iterator expressions = auxExps.iterator();
                 size = auxExps.size();
                 for(int i = 0; i < auxExps.size(); i++)
                 {
                    Element aux = (Element)expressions.next();
                    /*actual steps,children are elements steps */
                    List steps = aux.getChildren();
                    StringBuffer s = new StringBuffer();
                    Iterator step = steps.iterator();
               
                    while(step.hasNext())
                    {
                 
                       String content = ((Element)step.next()).getTextTrim();
                       s.append(content + " = ");
                       
                       content = ((Element)step.next()).getTextTrim();
                       s.append(content);
                       array[i] = s.toString();
                    
                    }//end while
                    
                  }//end for
                 
              
                }//if text = ""
              
            } //end if standard is not null
            
            Element ebnf = exercise.getChild("EBNF");
            if(ebnf!=null)
            {
               ebnfAux = true;  
               String name = ebnf.getChild("ebnfName").getTextTrim();
              
               expression.setEbnfName(name);
              
               String def = ebnf.getChild("ebnfDefinition").getTextTrim();
               expression.setFinalExpression(def,"ebnf");
          
              
               /*get all the aux illary expressions that make up expression
                * and set fields in class
                */
               /*list of all the aux expressions*/
                List auxExps = (List)ebnf.getChild("ebnfAuxillaryExpression")
                                        .getChildren("ebnfAuxExpression");
                
                Iterator expressions = auxExps.iterator();
                ebnfSize = auxExps.size();
              
                for(int i = 0; i < auxExps.size(); i++)
                {
                    StringBuffer s = new StringBuffer();
                    Element aux = (Element)expressions.next();
                    /*actual steps,children are elements steps */
                    List steps = aux.getChildren();
                    
                    Iterator step = steps.iterator();
                    while(step.hasNext())
                    {
                       String content = ((Element)step.next()).getTextTrim();
                     
                       s.append(content + " = ");
                       content = ((Element)step.next()).getTextTrim();
                       s.append(content);
                    
                       ebnfArray[i] = s.toString();
                    
                    }//end while
                   
                 }//end for
             }
             loadAuxTextFields(standAux,ebnfAux,array,ebnfArray,size,ebnfSize);
      }
      
      public void loadAuxTextFields(boolean standAux,boolean ebnfAux,
  final String[] array,final String []ebnfArray,final int size,final int ebnfSize)
      {
           
            if((standAux==true) && (ebnfAux ==true))
            {
                JMenuItem ebnfItem= new JMenuItem("ebnf");
                JMenuItem item = new JMenuItem("standard");
                exerciseMenu.add(item);
                exerciseMenu.add(ebnfItem);
                
                   /*load the expression with standard def to edit */
                 ebnfItem.addActionListener(new ActionListener(){
                   public void actionPerformed(ActionEvent evt)
                   {
                      String arg = evt.getActionCommand();
                      model.removeAllElements();
                      if(arg.equals("ebnf"))
                      {
                        expressionType="ebnf";
                        expression.setEBNF(true);
                        finalAuxExpr.setText(expression.getEbnfName());
                        
                        for(int i =0; i<ebnfSize;i++)
                          model.addElement(ebnfArray[i]);
                      }
                     
                   }
                  });
                  
                      /*load the expression with standard def to edit */
                 item.addActionListener(new ActionListener(){
                  public void actionPerformed(ActionEvent evt)
                  {
                     String arg = evt.getActionCommand();
                     model.removeAllElements();
                     if(arg.equals("standard"))
                     {
                        expressionType="standard";
                        expression.setStandard(true);
                        finalAuxExpr.setText(expression.getName());
                        
                        for(int i = 0; i <size; i++)
                           model.addElement(array[i]);
                       
                    }//if standard
                     
                   }
                  });
               }//end if both are ture
               
               if(standAux==true && ebnfAux ==false)
               { 
                    expressionType="standard";
                    expression.setStandard(true);
                    finalAuxExpr.setText(expression.getName());
                    model.removeAllElements();
                    for(int i = 0; i <size; i++)
                           model.addElement(array[i]);
                    
               }
               if(ebnfAux == true && standAux ==false)
               {
                   expressionType="ebnf";
                   expression.setEBNF(true);
                   
                   finalAuxExpr.setText(expression.getEbnfName());
                   model.removeAllElements();
                   for(int i =0; i<ebnfSize;i++)
                          model.addElement(ebnfArray[i]);
               }
     
      }
     /**********************************************************************
     *  if user wants to open a file to edit or run and it is an
     *  example, load RegExpression object and load appropriate
     *  text fields
     *  *****************************************************************/
     public void processExample(Document doc, Element root)
     {
           Element example = root.getChild("regExpression");
           String languageText = example.getChild("language")
                                   .getChildTextTrim("langText");
           
           /*first set up all the variables for this expression
            * object, then populate application fields
            */
            /*set up the language for example */
            expression.setLanguage(languageText); 
            
            /*set up the Font attributes for the language */
            List fontAttributes = example.getChild("language")
                                         .getChild("fontAttributes")
                                         .getChildren();
          
           /*iterate thru list ant set up font attribute fields for
            * language text
            * */
          
           Iterator iter = fontAttributes.iterator();
           setFontAttributes(iter,"language");
        
           /*set up the vectors of steps for explanations and
            * expressions
            */
           Element standard = example.getChild("standard");
       
           if(standard != null)
           {
                /*get explanation text for standard expression */
                List stExplFontAtt = example.getChild("standard")
                                            .getChild("explFontAttributes")
                                            .getChildren();
                                            
                 /*set up attributes for explanations */
                iter = stExplFontAtt.iterator();
                setFontAttributes(iter,"explanation");                           
                                            
             
                
                List stExprFontAtt = example.getChild("standard")
                                            .getChild("exprFontAttributes")
                                            .getChildren();
                                            
                iter = stExprFontAtt.iterator();
                /*set up font atts for expression */
                setFontAttributes(iter,"expression");
                
                /*get all the steps of explanations and set up variables */
                List explSteps = example.getChild("standard")
                                        .getChildren("explanationSteps");
                
                Iterator explanations = explSteps.iterator();
                
                int temp = explSteps.size();
                for(int i = 0; i < explSteps.size(); i++)
                {
                    Element explanationSteps = (Element)explanations.next();
                    /*actual steps,children are elements steps */
                    List steps = explanationSteps.getChildren();
                    
                    Iterator step = steps.iterator();
                    while(step.hasNext())
                    {
                        String content = ((Element)step.next()).getTextTrim();
                        expression.addExplStep(content);
                    }
                    /*add the explanations to linked list of explanations */
                    expression.addExplToList();
                    expression.resetExplSteps();
                 System.out.println(expression.printExplList());
                }
                 
                /*get all expression steps for this expression and set
                 * up expression objects variables
                 */
                  /*get all the steps of explanations and set up variables */
                List exprSteps = example.getChild("standard")
                                        .getChildren("expressionSteps");
                
                Iterator expressions = exprSteps.iterator();
                
                for(int i = 0; i < exprSteps.size(); i++)
                {
                    Element expressionSteps = (Element)expressions.next();
                    /*actual steps,children are elements steps */
                    List steps = expressionSteps.getChildren();
                    
                    Iterator step = steps.iterator();
                    while(step.hasNext())
                    {
                        String content = ((Element)step.next()).getTextTrim();
                        expression.addExprStep(content);                    
                    }
                    /*add the explanations to linked list of explanations */
                    expression.addExprToList();
                    expression.resetExprSteps();
                    System.out.println(expression.printExprList());
                 }
                 
                 
               
            }
            /*check to see if there is an ebnf def for this expression */
            Element ebnf = example.getChild("EBNF");
       
            /*set up font attributes for ebnf expression for this language */
            if(ebnf!=null)
            {
                /*get explanation text for standard expression */
                List ebnfExplFontAtt = example.getChild("EBNF")
                                            .getChild("ebnfExplFontAttributes")
                                            .getChildren();
                                            
                 /*set up attributes for explanations */
                iter = ebnfExplFontAtt.iterator();
                setFontAttributes(iter,"ebnfExplanation");                           
                                            
             
                
                List ebnfExprFontAtt = example.getChild("EBNF")
                                            .getChild("ebnfExprFontAttributes")
                                            .getChildren();
                                            
                iter = ebnfExprFontAtt.iterator();
                /*set up font atts for expression */
                setFontAttributes(iter,"ebnfExpression");
                
                /*get all the steps of explanations and set up variables */
                List explSteps = example.getChild("EBNF")
                                        .getChildren("ebnfExplanationSteps");
                
                Iterator explanations = explSteps.iterator();
                
                for(int i = 0; i < explSteps.size(); i++)
                {
                    Element explanationSteps = (Element)explanations.next();
                    /*actual steps,children are elements steps */
                    List steps = explanationSteps.getChildren();
                    
                    Iterator step = steps.iterator();
                    while(step.hasNext())
                    {
                        String content = ((Element)step.next()).getTextTrim();
                        expression.addEbnfExplStep(content);
                        
                    }
                    /*add the explanations to linked list of explanations */
                    expression.addExplToEbnfList();
                    
                 }
                 
                 /*get all expression steps for this expression and set
                  * up expression objects variables
                  */
                   /*get all the steps of explanations and set up variables */
                List exprSteps = example.getChild("EBNF")
                                        .getChildren("ebnfExpressionSteps");
                
                Iterator expressions = exprSteps.iterator();
                
                for(int i = 0; i < exprSteps.size(); i++)
                {
                    Element expressionSteps = (Element)expressions.next();
                    /*actual steps,children are elements steps */
                    List steps = expressionSteps.getChildren();
                    
                    Iterator step = steps.iterator();
                    while(step.hasNext())
                    {
                        String content = ((Element)step.next()).getTextTrim();
                        expression.addEbnfExprStep(content);
                      
                    }
                    /*add the explanations to linked list of explanations */
                    expression.addExprToEbnfList();
                 }
                        
            }
          
            loadExample();
       }
       /***************************************************************
       * this function is after the user has hit the open, so read in
       * an xml file load all the variables associated with this expression
       * not in this function load all the text field windows in the
       * application
       * **************************************************************/
       public void loadExample()
       {
           example = true;
         
         
           /*get the font attributes for example and set the font*/
           Font langFont = expression.getLangFontAttributes();
           String color = expression.getLangFontColor();
           Color fontColor = getFontColor(color);
           languageArea.setFont(langFont);
           languageArea.setForeground(fontColor);
           languageArea.setText(expression.getLanguage());
           
           String temp = expression.getLanguage();
           /*set text and font for run tabbed pane to see example run*/
           if (!expression.getLanguage().equals(""))
           {
               langArea.setText(expression.getLanguage());
           }
           langArea.setForeground(fontColor);
           langArea.setFont(langFont);
           
           /*set action demand differnt for forward and back arrow buttons
            * forloading an example,have to do different than creating
            * example*/
           //forwardArrowButton.setActionCommand("openForwardArrow");
           //forwardArrowButton2.setActionCommand("openForwardArrow2");
           
           //backArrowButton.setActionCommand("openBackArrow");
           //backArrowButton2.setActionCommand("openBackArrow2");
           
          
        
           /*there is a standard expression def, possible more than 1
            * explanation set, load into open file menu so user can choose
            * if numexpl == 1, there is only one explanation, don't need to
            * load meun with expla choices
            */
         
              
           if(expression.numExplanations() > 0) 
           {
               standSize = true; //more than one explanation
               JMenu standard = new JMenu("standard");
               //setTextFontAttributes();
               for(int i = 0; i < expression.numExplanations(); i++)
               {
                   JMenuItem item = new JMenuItem("explanation " + (i+1));
                   standard.add(item);
                   
                   item.addActionListener(new ActionListener(){
                      public void actionPerformed(ActionEvent evt)
                      {
                         dummy();  
                         beenHere++;
                          
                         //looking at  another explanation for 1
                         //expression, so save any changes that
                         //may have happened
                         
                         //save vector changes add back to linkd list
                         if (beenHere > 1)
                         {
                             System.out.println("!" + expression.printExplVector());
                             System.out.println("!" + expression.printExprVector());
                             expression.addEditedExplToList(standardNum);
                             expression.addEditedExprToList(standardNum);                
                         }
                         
                         String arg = evt.getActionCommand();
                         StringTokenizer str = new StringTokenizer(arg);
                         
                         str.nextToken();  //strip off explanation part
                         standardNum = Integer.parseInt(str.nextToken());
                        
                         /*load standard explanation num*/
                         explanations = expression.getExplVectorFromList(standardNum);
                         expressions = expression.getExprVectorFromList(standardNum);
                         System.out.println(expressions.toString());
                         System.out.println(explanations.toString());
                         
                         /*copy vectors in reg expression class
                          * so can use exprStep and explStep */
                         expression.setStepVector(expressions,explanations);
                         System.out.println("*" + expression.printExplVector());
                         System.out.println("*" + expression.printExprVector());
                         setTextFontAttributes();
                        
                         explanationIndex = 0; //reset all indexes or problems will arise
                         expressionIndex = 0;
                         index = 0;
                         index2 = 0;
                         expArea.setText("");
                         explArea.setText("");
                         loadType = "standard";
                         expressionType = "standard";
                         expression.setStandard(true);
                        
                         /*load first step into text fields */
                         expArea.setText((String)expressions.elementAt(0));
                         explArea.setText((String)explanations.elementAt(0));
                        }
                    });
                }
                
                if (openMenu.getItemCount() > 0)
                {
                    openMenu.remove(0);
                }
                openMenu.add(standard);
                /*
                explanationIndex = 0; //reset
                expressionIndex = 0;
                expArea.setText("");
                explArea.setText("");
                loadType = "standard";
                expressionType = "standard";
                expression.setStandard(true);
                beenHere++;
                          
                //looking at  another explanation for 1
                //expression, so save any changes that
                //may have happened
                if(beenHere>1)
                {
                    //save vector changes add back to linkd list
                    expression.addEditedExplToList(standardNum);
                    expression.addEditedExprToList(standardNum);                           
                }
                
                explanations = expression.getExplVectorFromList(1);
                expressions = expression.getExprVectorFromList(1);
           
                        
                /*copy vectors in reg expression class
                 * so can use exprStep and explStep 
                expression.setStepVector(expressions,explanations);
                setTextFontAttributes();
                        
                /*load first step into text fields 
                expArea.setText((String)expressions.elementAt(0));
                explArea.setText((String)explanations.elementAt(0));
                */
            }
          
            /*is ebnf expression descriptioin also */
            if(expression.numEbnfExplanations()>0)
            {
                ebnfSize = true; //more than one ebnf explanation
                JMenu ebnf = new JMenu("EBNF");
                //setEbnfTextFontAttributes();
                for(int i = 0; i <expression.numEbnfExplanations();i++)
                {
                   JMenuItem item = new JMenuItem("explanation " + (i+1));
                   ebnf.add(item);
                   
                   item.addActionListener(new ActionListener(){
                      public void actionPerformed(ActionEvent evt)
                      {
                         
                         explanationIndex = 0; //reset, load new explanation
                         expressionIndex = 0;
                         expArea.setText("");
                         explArea.setText("");
                         expression.setEBNF(true);
                         loadType = "ebnf";
                         expressionType ="ebnf";
                         beenHere++;
                   
                         //looking at  another explanation for 1
                         //expression, so save any changes that
                         //may have happened
                         if(beenHere>1)
                         {
                            //save vector changes add back to linkd list
                             expression.addEditedEbnfExplToList(ebnfNum);
                             expression.addEditedEbnfExprToList(ebnfNum);
                            
                         }
                         String arg = evt.getActionCommand();
                         StringTokenizer str = new StringTokenizer(arg);
                         
                         str.nextToken();  //strip off explanation part
                         ebnfNum = Integer.parseInt(str.nextToken());
                      
                       
                         /*load standard explanation num*/
                         ebnfExpressions = expression.
                                                getEbnfExprVectorFromList(ebnfNum);
                         ebnfExplanations = expression.
                                                getEbnfExplVectorFromList(ebnfNum);
                         /*clone vectors*/
                         expression.setEbnfStepVector(ebnfExpressions,ebnfExplanations);
                         setEbnfTextFontAttributes();
                          /*load first step into text fields */
                         expArea.setText((String)ebnfExpressions.elementAt(0));
                         explArea.setText((String)ebnfExplanations.elementAt(0));
                       }
                      });
                }
                openMenu.add(ebnf);
               
             }
            
       }
       
       public void dummy()
       {
           int k = 4 + 3;
       }
       
       
       
       /*************************************************************
        * next two functionst set the font atts for loaded example
        * from xml file
        * ************************************************************/
        public void setTextFontAttributes()
        {
               /*set Fonts for text area */
               Font expressionFont = expression.getExprFontAttributes();
               Font explanationFont = expression.getExplFontAttributes();
                         
               /*set font color */
               String color = expression.getExprFontColor();
               Color fontColor = getFontColor(color);
               expArea.setForeground(fontColor);
               expArea.setFont(expressionFont);
               
               /*set run tabbed fonts*/
               regExpArea.setForeground(fontColor);
               regExpArea.setFont(expressionFont);
                          
               color = expression.getExplFontColor();
               fontColor = getFontColor(color);
               explArea.setForeground(fontColor);
               explArea.setFont(explanationFont);
               
               /*set font for expl area on runn tabbed pane*/
               explArea2.setForeground(fontColor);
               explArea2.setFont(explanationFont);
        }
        public void setEbnfTextFontAttributes()
        {
              /*set Fonts for text area */
              Font expressionFont = expression.getEbnfExprFontAttributes();
              Font explanationFont = expression.getEbnfExplFontAttributes();
                         
             /*set font color */
              String color = expression.getEbnfExprFontColor();
              Color fontColor = getFontColor(color);
              expArea.setForeground(fontColor);
              expArea.setFont(expressionFont);
                          
              color = expression.getEbnfExplFontColor();
              fontColor = getFontColor(color);
              explArea.setForeground(fontColor);
              explArea.setFont(explanationFont);
        }
            
      /*********************************************************************
        * the next 4 functions are functions that get called when user hits
        * the forward and back arrow buttons for an example.  these functions
        * only get called when a user loads in an existing file, other
        * wise the other foward and back arrow button functions get called
        * for when a user creates an example
        * ******************************************************************/
       public void loadExplanationStepsForward() throws Exception
       {
           int max = expression.getExplVector().size();
           if ((explanationIndex == max) &&
               (explArea.getText().equals("")))
           {
               throw new IndexException();
           }
           explanationIndex++; //increment into vector
          
           if(loadType.equals("standard"))
           {
             /*needed if user changed text, ensures correct data */
             
              //expression.removeExplStep(explanationIndex-1);
               expression.setExplStep(explArea.getText(),explanationIndex-1);
              
               if(explanationIndex == expression.getExplStepSize())
               {
                 //explArea.setText("");
                
                   if(!explArea.getText().equals(""))
                     expression.addExplStep(explArea.getText()); 
               }
               else
                    explArea.setText(expression.getExplStep(explanationIndex));
           }
           else
           {
             /*needed if user changed text, ensures correct data */
            
               expression.removeEbnfExplStep(explanationIndex-1);
               expression.setEbnfExplStep(explArea.getText(),explanationIndex-1);
              
               if(explanationIndex == expression.getEbnfExplStepSize())
               {
                   explArea.setText("");
                   if(!explArea.getText().equals(""));
                       expression.addEbnfExplStep(explArea.getText());
                
               }
               else
                   explArea.setText(expression.getEbnfExplStep(explanationIndex));
           }
       }
       
       public void loadExpressionStepsForward() throws Exception
       {
           int max = expression.getExprVector().size();
           if ((expressionIndex == max) &&
               (expArea.getText().equals("")))
           {
               throw new IndexException();
           }
           expressionIndex++;

            /*when user hits forward arrow button get text out of 
             * correct vector and display in text area.  if user changed
             * the text then must change in the vecor
             */
           
           if(loadType.equals("standard"))
           {
            /*needed if user changed text, ensures correct data */
              
              expression.removeExprStep(expressionIndex-1);
              expression.setExprStep(expArea.getText(),expressionIndex-1);
             
              if(expressionIndex == expression.getExprStepSize())
              {
                //expArea.setText("");
                if(!expArea.getText().equals(""))
                  expression.addExprStep(expArea.getText());
              
              }
              else
                expArea.setText(expression.getExprStep(expressionIndex));    
                
            
          }
            
           else
           {
             /*needed if user changed text, ensures correct data */
             
              expression.removeEbnfExprStep(expressionIndex-1);
              expression.setEbnfExprStep(expArea.getText(),expressionIndex-1);
              
              if(expressionIndex == expression.getEbnfExprStepSize())
              {
                 expArea.setText("");
                 if(!expArea.getText().equals(""));
                   expression.addEbnfExprStep(expArea.getText());
                 
              }
              else
                expArea.setText(expression.getEbnfExprStep(expressionIndex));
                
           
           }
       }
       /*******************************************************************
        *  the next two functions have to deal with hitting the back arrow
        *  button, when user loads in an xml file and makes changes
        *  ***************************************************************/
       public void loadExplanationStepsBack() throws Exception
       {
          if (explanationIndex == 0)
          {
              throw new IndexException();
          }
          explanationIndex--; //increment into vector
         
          if(loadType.equals("standard"))
          {
             expression.removeExplStep(explanationIndex+1);
             expression.setExplStep(explArea.getText(),explanationIndex+1);
             
             explArea.setText(expression.getExplStep(explanationIndex));
            
            
          }
            
          else
          {
             expression.removeEbnfExplStep(explanationIndex+1);
             expression.setEbnfExplStep(explArea.getText(),explanationIndex+1);
             
             explArea.setText(expression.getEbnfExplStep(explanationIndex));
          
          }
          
       }
       
       
       public void loadExpressionStepsBack() throws Exception
       {
           if (expressionIndex == 0)
           {
               throw new IndexException();
           }    
            expressionIndex--;
           
           if(loadType.equals("standard"))
           {
              expression.removeExprStep(expressionIndex+1);
              expression.setExprStep(expArea.getText(),expressionIndex+1);
              expArea.setText(expression.getExprStep(expressionIndex));
             
           }
           else
           {
              expression.removeEbnfExprStep(expressionIndex+1);
              expression.setEbnfExprStep(expArea.getText(),expressionIndex+1);
              expArea.setText(expression.getEbnfExprStep(expressionIndex));
            
              
           }
          
                         
       }
     /*****************************************************************
      * this function is used while parsing an xml file when user
      * wants to open an existing xml file.  set up font attributes
      * for that existing file, load the expression object with the
      * already existing files attributes
      * *****************************************************************/
      public void setFontAttributes(Iterator iter, String font)
      {
           Element name = (Element)iter.next();
           String fontName = name.getTextTrim();
             
           Element style = (Element)iter.next();
           String fontStyle =style.getTextTrim();
           int fstyle = Integer.parseInt(fontStyle);
                        
           Element size =(Element)iter.next();
           String fontSize = size.getTextTrim();
           int fsize = Integer.parseInt(fontSize);
               
           Element color =(Element) iter.next();
           String fontColor = color.getTextTrim();
               
           Font langFont = new Font(fontName,fstyle,fsize);
           
           if(font.equals("language"))
              expression.setLangFontAttributes(langFont,fontColor);
             
           else if(font.equals("explanation"))
              expression.setExplanationFontAttributes(langFont,fontColor);
              
           else if(font.equals("expression"))
              expression.setExpressionFontAttributes(langFont,fontColor);
              
           else if(font.equals("ebnfExplanation"))
              expression.setEbnfExplanationFontAttributes(langFont,fontColor);
              
           else if(font.equals("ebnfExpression"))
              expression.setEbnfExpressionFontAttributes(langFont,fontColor);
     
           
     }     
    /*******************************************************************
     if the user hits the save icon or save from pull down file menu
    *******************************************************************/
    public void save()
    {
        /*going to use for XML file, if it is an example make set that
          tag, so can set menus of expression ok
        */
        expression.setExample(example); 
        hitSaveButton = true;   //reset
   
        if(example == false) //exercise
        {     
            hitOpen = 0; //reset
            hitOpenButton = false;
            /*just in case user opened up an exercise and then hits
             * save without submitting, ensures everything gets saved
             */
            if(expression.getAuxillary() == true)
            { 
                if(hitSubmitAux == false)
                {
                   submitAuxillary();
                }
            }
            saveFile();
        }
        else //example
        {
            /*reset actioncommands for arrow buttons*/
            forwardArrowButton.setActionCommand("forwardRegExp");
            forwardArrowButton2.setActionCommand("forwardExpl");
            backArrowButton.setActionCommand("backRegExp");
            backArrowButton2.setActionCommand("backExpl");
         
            /*replace edited vectors back in linked list */
            if(hitOpenButton == true)
            { 
               /*
               if(loadType.equals("standard"))
               {
                 expression.addEditedExplToList(standardNum);
                 expression.addEditedExprToList(standardNum);
               }
               else //ebnf
               {
         
                  expression.addEditedEbnfExplToList(ebnfNum);
                  expression.addEditedEbnfExprToList(ebnfNum);
               }*/
             
               
               //hitOpenButton = false;
               //hitOpen = 0;
               //beenHere = 0;
        
           }//end if open = true
           else
           {
             /*make sure that vectors of explanations get added to linked list
               only if vectors have something in it
              */
              /*
              if((expression.getExprStepSize())>0)
              {
                 expression.addExplToList(); //add vector of steps to list
                 expression.addExprToList();//add explanations to list
              }*/
      
              if((expression.getEbnfExprStepSize())>0)
              {
                 expression.addExplToEbnfList();
                 expression.addExprToEbnfList();
              }
           }//end else
             /*bring up file chooser and name file and save to directory*/
           saveFile();
        }
    }

    /*****************************************************************
     if the user hits the new icon or new from file menu. Reset variables
    *********************************************************************/
     public void newExpression()
     {
         String message = "Creating a new expression/exercise will cause all unsaved work to be lost." +
                          " Are you sure you want to create a new expression/exercise?";
         String title = "New expression/exercise";
         example = false;    //new expression reset this value - maybe exercise
      
         int result = JOptionPane.showConfirmDialog(regLanguageArea,message);//,title,
                                //JOptionPane.QUESTION_MESSAGE);
      
         /*must save before can start new expression, show warning diaglog */
         if(result == JOptionPane.OK_OPTION)
         {
            clearAllTextComponents();
           
            /*creat a new expression object, reset hitSaveButton */
            expression = new RegExpression();
            hitSaveButton = false; //reset save button 
            hitOpenButton = false;
            hitOpen = 0; //reset
            beenHere = 0;
            String arg = (String)expTypeBox.getSelectedItem();
    
            expressionType = arg;
           
            if(expressionType.equals("standard"))
              expression.setStandard(true);
            else
              expression.setEBNF(true);
              //expressionType = "standard"; //reset to make sure there is a type
         }
     }
     /******************************************************************
      if user wants to create a new explanation set from new -> from file
      menu
     *******************************************************************/
     public void explanationSet()
     {
        beenHere++;
        /*make sure that vectors get added to linked list */
        if (beenHere > 1)
        {
            //System.out.println("!" + expression.printExplVector());
            //System.out.println("!" + expression.printExprVector());
            expression.addEditedExplToList(standardNum);
            expression.addEditedExprToList(standardNum);                
        }
        else if((expressionType.equals("standard")) && ((expression.getExprStepSize())>0))
        {
           expression.addExplToList(); //add vector of steps to list
           expression.addExprToList();//add explanations to list
        }
        else
        {
           //expression.addExplToEbnfList(); //add vector of steps to list
           //expression.addExprToEbnfList();//add explanations to list
        }
       
        expArea.setText("");
        explArea.setText("");

        expression.resetExplSteps();
        expression.resetExprSteps();

        //reset index variables for examples tabbed panes
        index=0; index2 =0;exprStepIndex=0;explStepIndex =0;
        beenHere = 0;

     }
     /*****************************************************************
      if user hits the forward arrow button for the explanation text area
      ******************************************************************/
     public void forwardArrowButtonExplanation() throws Exception
     {
          /*set font type, style , color and size for explanation
            text area
          */ 
           explFontStyle = (String)fontBox.getSelectedItem();
        
           String fontType = (String)fontStyleBox.getSelectedItem();
           explFontType = getFontType(fontType);

           String fontSize =  (String)fontSizeBox.getSelectedItem();

           explFontSize = getFontSize(fontSize);
           explFont = new Font(explFontStyle,explFontType,explFontSize);
          
           String color = (String)colorBox.getSelectedItem();
           Color fontColor = getFontColor(color);

           explArea.setForeground(fontColor);
           explArea.setFont(explFont);
           
           /*set expression objects expression text area attributes */
           if(expressionType.equals("standard"))
              expression.setExplanationFontAttributes(explFont,color);

           else
              /*set expression objects expression text area attributes */
              expression.setEbnfExplanationFontAttributes(explFont,color);
           
           /*this part sets the text areas text depending on index
             it will display test from previous entries or blank 
             text area
           */
           int max = expression.getExplVector().size();
           if ((index2 == max) &&
               (explArea.getText().equals("")))
           {
               throw new IndexException();
           }
           index2++;

           if(index2 == max)
           {
              if(expressionType.equals("standard"))
              {
                  /*user changed the text in text area, update in vector */
                 if(!explArea.getText().equals(expression.getExplStep((index2)-1)))
                 {
                   /*remove the text from the vector and update with new
                     text in text area
                   */

                     //expression.removeExplStep((index2)-1);
                     //System.out.println(explArea.getText());
                     expression.setExplStep(explArea.getText(),(index2)-1);
                  }
                  
                  if (index2 == expression.getExplVector().size())
                  {
                      explArea.setText("");
                  }
                  else
                  {
                      explArea.setText(expression.getExplStep(index2));
                  }
               }  //end of if standard
               else //ebnf - reset ebnf steps
               {
                  /*user changed the text in text area, update in vector */
                 if(!explArea.getText().equals(expression.getEbnfExplStep((index2)-1)))
                 {
                   /*remove the text from the vector and update with new
                     text in text area
                   */

                     expression.removeEbnfExplStep((index2)-1);
                     expression.setEbnfExplStep(explArea.getText(),(index2)-1);
                  }
                  explArea.setText("");
               }  //end of if ebnf
           }
           /*indicates that user had hit the back button at some point*/
           else if(index2 < max)
           {
               if(expressionType.equals("standard"))
               {
                 /*user changed the text in text area, update in vector */
                  if(!explArea.getText().equals(expression.getExplStep((index2)-1)))
                  {
                   /*remove the text from the vector and update with new
                     text in text area
                   */

                     //expression.removeExplStep((index2)-1);
                     //System.out.println(explArea.getText());
                     expression.setExplStep(explArea.getText(),(index2)-1);
                   }
                   explArea.setText(expression.getExplStep(index2));
                }//end if standard
                else  //ebnf
                {
                    /*user changed the text in text area, update in vector */
                    if(!explArea.getText().equals(expression.getEbnfExplStep((index2)-1)))
                    {
                     /*remove the text from the vector and update with new
                       text in text area
                      */

                       expression.removeEbnfExplStep((index2)-1);
                       expression.setEbnfExplStep(explArea.getText(),(index2)-1);
                     }
                     explArea.setText(expression.getEbnfExplStep(index2));
                }//end if Ebnf
        
           }
           /*add step to vector, just moving forward no back button */
           else
           {
               if(expressionType.equals("standard"))
               {
                   if (index2 == expression.getExplVector().size())
                   {
                       explArea.setText("");
                       explStepIndex++;
                   }
                   else
                   {
                       expression.addExplStep(explArea.getText());
                       explArea.setText("");
                       explStepIndex++;
                   }
               }//end if
               else //ebnf
               { 
                   expression.addEbnfExplStep(explArea.getText());
                   explArea.setText("");
                   explStepIndex++;
               }//end else ebnf
            } 
     }
     
     
     
     /*******************************************************************
      if user hits the forward arrow button for the regular expression
      text area
     *******************************************************************/
     public void forwardArrowButtonExpression() throws Exception
     {
        /*if I hit the arrow button, I know this is going to be
             an example, set the variable
           */
           example = true;

           /*set font type, style , color and size for expressioin 
            text area
          */ 
           exprFontStyle = (String)fontBox.getSelectedItem();
        
           String fontType = (String)fontStyleBox.getSelectedItem();
           exprFontType = getFontType(fontType);

           String fontSize =  (String)fontSizeBox.getSelectedItem();

           exprFontSize = getFontSize(fontSize);
           exprFont = new Font(exprFontStyle,exprFontType,exprFontSize);
          
           String color = (String)colorBox.getSelectedItem();
           Color fontColor = getFontColor(color);

           expArea.setForeground(fontColor);
           expArea.setFont(exprFont);
           expArea.validate();
             
          /*set expression objects expression text area attributes */
           if(expressionType.equals("standard"))
              expression.setExpressionFontAttributes(exprFont,color);

           else
              /*set expression objects expression text area attributes */
              expression.setEbnfExpressionFontAttributes(exprFont,color);
           
           
           /*this part sets the text areas text depending on index
             it will display text from previous entries or blank 
             text area for new entry
           */
           int max = expression.getExprVector().size();
           if ((index == max) &&
               (expArea.getText().equals("")))
           {
               throw new IndexException();
           }
           index++;  //index into vector in reg expresion class

           if(index == max)
           {
               if(expressionType.equals("standard"))
               {
                  /*user changed the text in text area, update in vector */
                  if(!expArea.getText().equals(expression.getExprStep(index-1)))
                  {
                     /*remove the text from the vector and update with new
                       text in text area
                     */

                     //expression.removeExprStep(index-1);
                     expression.setExprStep(expArea.getText(),index-1);
                  }
                  
                  if (index == expression.getExprVector().size())
                  {
                      expArea.setText("");
                  }
                  else
                  {
                      expArea.setText(expression.getExprStep(index));
                  }
                }//end if standard
                else //ebnf
                { 
                     /*user changed the text in text area, update in vector */
                   if(!expArea.getText().equals(expression.getEbnfExprStep(index-1)))
                   {
                      /*remove the text from the vector and update with new
                        text in text area
                      */

                       //expression.removeEbnfExprStep(index-1);
                       expression.setEbnfExprStep(expArea.getText(),index-1);
                    }
                    expArea.setText("");
                 }//end if ebnf
           } //end outer if
           else if(index < max)
           {
              if(expressionType.equals("standard"))
              {
                 /*user changed the text in text area, update in vector */
                 if(!expArea.getText().equals(expression.getExprStep(index-1)))
                 {
                     /*remove the text from the vector and update with new
                       text in text area
                     */

                     //expression.removeExprStep(index-1);
                     expression.setExprStep(expArea.getText(),index-1);
                  }
             
                  expArea.setText(expression.getExprStep(index));
               }//end if standard
            
               else  //ebnf
               {
                 /*user changed the text in text area, update in vector */
                 if(!expArea.getText().equals(expression.getEbnfExprStep(index-1)))
                 {
                     /*remove the text from the vector and update with new
                       text in text area
                     */

                     expression.removeEbnfExprStep(index-1);
                     expression.setEbnfExprStep(expArea.getText(),index-1);
                  }      
                  expArea.setText(expression.getEbnfExprStep(index));
               }//end if Ebnf
           }
            /*add step to vector */
           else
           {
               if(expressionType.equals("standard"))
               {
                   if (index == expression.getExprVector().size())
                   {
                       expArea.setText("");
                       exprStepIndex++;
                   }
                   else
                   {
                       expression.addExprStep(expArea.getText());
                       expArea.setText("");
                       exprStepIndex++;
                   }
               }
               else
               {
                  expression.addEbnfExprStep(expArea.getText());
                  expArea.setText("");
                  exprStepIndex++;
               } 
            } 
     }
     /*********************************************************************
      if user hits the back arrow button for explanation text area
     *********************************************************************/
     public void backArrowButtonExplanation() throws Exception
     {
         if (index2 == 0)
         {
             throw new IndexException();
         }
         index2--;

         /*if user changes text and then hits the back arrow button 
          again, have to update the vector with right text.
         */
         if(expressionType.equals("standard"))
         {
             if(!explArea.getText().equals(""))
             {
                if((index2 + 1) == expression.getExplVector().size())
                {
                    expression.addExplStep(explArea.getText());
                }
                else if(!explArea.getText().equals(expression.getExplStep((index2)+1)))
                {
                   //expression.removeExplStep((index2)+1);
                   expression.setExplStep(explArea.getText(),(index2)+1);
                }
             }
             explArea.setText(expression.getExplStep(index2));
         }
         else  //expression type is EBNF
         {
             if(!explArea.getText().equals(""))
             {
                if(!explArea.getText().equals(expression.getEbnfExplStep((index2)+1)))
                {
                   expression.removeEbnfExplStep((index2)+1);
                   expression.setEbnfExplStep(explArea.getText(),(index2)+1);
                }
             }
             explArea.setText(expression.getEbnfExplStep(index2));
         }
    }
     /*********************************************************************
      if user hits the back arrow button for expression text area
     *********************************************************************/
     public void backArrowButtonExpression() throws Exception
     {
         if (index == 0)
         {
             throw new IndexException();
         }
         index--;      

          /*if user changes text and then hits the back arrow button 
            again, have to update the vector with right text.
          */
          if(expressionType.equals("standard"))
          {
             if(!expArea.getText().equals(""))
             {
                if((index + 1) == expression.getExprVector().size())
                {
                    expression.addExprStep(expArea.getText());
                }
                else if(!expArea.getText().equals(expression.getExprStep(index+1)))
                {
                   //expression.removeExprStep(index+1);
                   expression.setExprStep(expArea.getText(),index+1);
                }
             }
             /*set the text area */
             expArea.setText(expression.getExprStep(index));
          }
          else //Ebnf
          {
             if(!expArea.getText().equals(""))
             {
                if(!expArea.getText().equals(expression.getEbnfExprStep(index+1)))
                {
                   expression.removeEbnfExprStep(index+1);
                   expression.setEbnfExprStep(expArea.getText(),index+1);
                }
             }
             /*set the text area */
             expArea.setText(expression.getEbnfExprStep(index));
          }
     }
     /**************************************************************
      if user hits the submitt button on the expression tabbed pane
      set language variable in the regExpression object
     ***************************************************************/
     public void submitLanguage()
     { 
         /*initialize languange for expression object */
          expression.setLanguage(regLanguageArea.getText());

          /*get and set attributes for the text areas */
          langFontStyle = (String)fontBox.getSelectedItem();
        
          String fontType = (String)fontStyleBox.getSelectedItem();
          langFontType = getFontType(fontType);


          String fontSize =  (String)fontSizeBox.getSelectedItem();

          langFontSize = getFontSize(fontSize);
          Font languageFont = new Font(langFontStyle,langFontType,langFontSize);
          String color = (String)colorBox.getSelectedItem();

          Color fontColor = getFontColor(color);
          regLanguageArea.setForeground(fontColor);
          regLanguageArea.setFont(languageFont);
        

          /*set expression object with font and color attributes */
          expression.setLangFontAttributes(languageFont,color);

     }
     /*******************************************************************
      user is creating an example, so needs to submit the language for
      the example, when user hits the submit language button this 
      function gets called.  get all font attributes and set the 
      reg expression language
     ********************************************************************/
     public void submitExample()
     {
         /*initialize languange for expression object */
          expression.setExampLang(languageArea.getText());
          expression.setLanguage(languageArea.getText());

          /*get and set attributes for the text areas */
          langFontStyle = (String)fontBox.getSelectedItem();
        
          String fontType = (String)fontStyleBox.getSelectedItem();
          langFontType = getFontType(fontType);


          String fontSize =  (String)fontSizeBox.getSelectedItem();

          langFontSize = getFontSize(fontSize);
          Font languageFont = new Font(langFontStyle,langFontType,langFontSize);
          String color = (String)colorBox.getSelectedItem();

          Color fontColor = getFontColor(color);

          /*set text in example area and run tabbed pane*/
        
          langArea.setText(languageArea.getText());
        
          languageArea.setForeground(fontColor);
          langArea.setForeground(fontColor);

          languageArea.setFont(languageFont);
          langArea.setFont(languageFont);
     

          /*set expression object with font and color attributes */
          expression.setLangFontAttributes(languageFont,color);
          expression.setExample(true);

     }
     /*****************************************************************
      if the user hits the enter button on auxillary tabbed pane. will
      display the auxillary in jlist area
     *****************************************************************/
     public void enter()
     {
         DefaultListModel model = (DefaultListModel)exprList.getModel();
         String auxName =auxField.getText();
         String auxExpr = auxExpField.getText();

        
         if(auxName.equals(""))
         {
            helpArea.setText("You must first enter an auxiallary expression " +
                    "in the above text fields");
         }
         else
         {
             String addToList = auxName  + " = " + auxExpr;
             helpArea.setText("If you create an auxillary expression that uses an "
              +"auxillary expression on the right hand side, you must put the " +
              "auxillary expression on the right hand side in between < >. "+
              "e.g integer = <digit>*");

            /*add to the list, add to vector of aux expressions */
            model.addElement(addToList);

            /*clear text fields for another auxillary exp */
            auxField.setText("");
            auxExpField.setText("");
            
         }
     }
     /*****************************************************************
      if the user hits the enter button on auxillary tabbed pane. will
      display the auxillary expr. so can edit
     *****************************************************************/
     public void edit()
     {
        DefaultListModel model = (DefaultListModel)exprList.getModel();
         StringTokenizer token;

         int selected = exprList.getSelectedIndex();
      
         if(selected==-1) //no selection made
         {
           helpArea.setText("You must make a selection before you press edit");
         }
         else //made a selection
         {
            String selectedValue = (String)exprList.getSelectedValue();
            token = new StringTokenizer(selectedValue);
            String aux = token.nextToken();
            String equal = token.nextToken();
            String auxExp = token.nextToken();

            helpArea.setText("");

            /*reset text fields with selection */
            auxField.setText(aux);
            auxExpField.setText(auxExp);
             
           /*remove that element from list */
            model.removeElementAt(selected);
         }
     }
     /*****************************************************************
      if the user hits the delete button on auxillary tabbed pane. will
      delete the aux expression from the list
     *****************************************************************/
     public void delete()
     {
         DefaultListModel model = (DefaultListModel)exprList.getModel();
  
          /*get selectetd items and delete them from list */
          int [] selected = exprList.getSelectedIndices();
        
          if(selected.length ==0) //no selections made
          {
             helpArea.setText("you must first make one or more selections "+
                              "before you can hit the delete button");
          }
          else  //made some selections
          {
             for(int i = 0; i <selected.length; ++i)
             {
                model.removeElementAt(selected[i]-i);
             }
             helpArea.setText("");
          }
     }
     /********************************************************************
      if user hits the submit final auxillary expression on auxillary
      tabbed pane.  will set values for expression object
     ********************************************************************/
     public void submitAuxillary()
     {
          model = (DefaultListModel)exprList.getModel();
          int listSize = model.getSize();
          String auxExp="";
          AuxillaryExpression aux=null;
          hitSubmitAux = true;
      
          /*for all the auxillary expressions in the JList
           * if any of the expressions consist of other and are in
           * between < > strip off <>
           * */
          for(int i =0; i < listSize; i++)
          {
              aux = new AuxillaryExpression();
              StringBuffer s = new StringBuffer();
              String exp = (String)model.get(i);
           
              StringTokenizer token = new StringTokenizer(exp);
              String name = token.nextToken();
              aux.setName(name);
         
              token.nextToken();  //strip off =
             
              
              while(token.hasMoreTokens())
                s.append(auxExp =token.nextToken());
                
              auxExp = s.toString();
              aux.setExpression(auxExp);

              /*add the auxillary expression to expression vector */
              expression.addAuxExp(aux,expressionType);
                /*strip off < > get text inbetween, see if already defined
               * and replace with actual expression not aux
               */
              getExpBetweenBrackets(auxExp,aux);
              /*now strip off brackets, can't have <> in xml file*/
         
             
          }

          /*just a flag to signify that the user does have some 
            auxillary expresssions
          */
          expression.setAuxillary(true);

          /*this sets the expression object with a name and the 
            final expression which is made up of auxillary expressions
          */
        String finalExp = finalAuxExpr.getText();
        setFinalExpression(finalAuxExpr.getText());
        replaceBrackets(finalExp);
        
        
     }
     /******************************************************************
      * take the text from final expression, aux, and set 
      * ***************************************************************/
      public void setFinalExpression(String exp)
      {
    
         int beginIndex = 0,endIndex =0;
         char c;
         StringBuffer s = new StringBuffer(exp);
         int i = 0;
       
         while(i <s.length())
         {
            c = s.charAt(i);
          
             if(c == '<')
             {
           
                beginIndex = i; 
               
             }
             if(c=='>')
             {
                endIndex = i;
                /*get def and replace aux with real def for exp*/
                //String newString = exp.substring(beginIndex +1, endIndex);
                String newString = exp.substring(beginIndex, endIndex + 1);
                
                String def = "(" + getDefinition(newString) + ")";
             
                s.replace(beginIndex,endIndex+1,def);
                exp = s.toString();
                i = def.length()-1;
             
            }
            
            i++;
        }
       
       String string = s.toString();
 
       expression.setFinalExpression(string,expressionType);   
      
       
        
      }
     /************************************************************
      * this function takes the < and > off of expression, because
      * the xml file can not have those in the file, gets confused
      * ************************************************************/
     public void replaceBrackets(String exp)
     {
          StringBuffer s = new StringBuffer();
          char c;
        
          
          for(int i = 0; i < exp.length(); i++)
          {
             c = exp.charAt(i);
             
             if(c =='<')
             {
                 s.append("&lt;");
                
             }
             else if(c =='>')
                s.append("&gt;");
                
             else
               s.append(c);
               
          }
          if(expressionType.equals("standard"))
             expression.setName(s.toString());
          else
             expression.setEbnfName(s.toString());
     }
     
     
     public void getExpBetweenBrackets(String exp,AuxillaryExpression aux)
     {
         int beginIndex = 0,endIndex =0,index =0;
         char c;
         int i =0;
       
         StringBuffer s = new StringBuffer(exp);
         while(i <s.length())
         {
            c = exp.charAt(i);
         
             if(c == '<')
             {
                beginIndex = i; 
             }
             else if(c=='>')
             {
                endIndex = i;
                /*get def and replace aux with real def for exp*/
                //String newString = exp.substring(beginIndex +1, endIndex);
                String newString = exp.substring(beginIndex, endIndex + 1);
                String def = "(" + getDefinition(newString) + ")";
         
                s.replace(beginIndex,endIndex+1,def);
                exp = s.toString();
                i = def.length()-1;
           
             }
             i++;
          
           
        } //end while
       
        String string = s.toString();
        aux.setExpression(string);
     
    }
   /*******************************************************************
    * this function takes the name of then new string which is an
    * auxillary expression and finds out what makes that auxillary 
    * expression and returns its true def
    * *****************************************************************/
    public String getDefinition(String string)
    {
        Vector auxillaryVector;
        String def = "";
        
        if(expressionType.equals("standard"))
        {
            auxillaryVector = expression.getAuxillaryVector();
           
            for(int i = 0; i <auxillaryVector.size();i++)
            {
               AuxillaryExpression aux = (AuxillaryExpression)
                                            auxillaryVector.elementAt(i);
               /*what defines the aux expression*/
               if(string.equals(aux.getName()))
               {
                  def = aux.getExpression();
                  
               }
              
            }//end for
        }
        else //ebnf
        {
            auxillaryVector = expression.getEbnfAuxillaryVector();
            for(int i = 0; i <auxillaryVector.size();i++)
            {
               AuxillaryExpression aux = (AuxillaryExpression)
                                            auxillaryVector.elementAt(i);
               /*what defines the aux expression*/
               if(string.equals(aux.getName()))
               {
                 def = aux.getExpression();
                  
               }
              
            }//end for
        }
      
        return def;
    }
 /*************************************************************************
                ACTION PERFORMED METHODS
  ***************************************************************************/
    public void actionPerformed(ActionEvent evt)
    {
       String arg = evt.getActionCommand();
     
  
       /*if user hits the clear button to clear the language text area */
       if(arg.equals("clearlang"))
       {
          regLanguageArea.setText("");
          languageArea.setText("");
          
       }
       /*if user hits the submit expression button,exression tabbed pane */
       if(arg.equals("submitexp"))
       {
           try
           {
               Parser parse1 = new Parser();
               StateMachine Answer = parse1.parse(expressionField.getText(), Reader.SETNEW, null);
               Font font = new Font("Monospaced", 0, 10);
               JOptionPane jpane = new JOptionPane();
               jpane.setFont(font);
               jpane.showMessageDialog(null,"Entered Expression is in correct form.");
               //JOptionPane.showMessageDialog(null,"Entered Expression is in correct form.");
               //FSAFile newFile = new FSAFile(Answer);
               //File outFile = new File("C:/Pascoe/Research03/testFiles/fsaT2.fsa");
               //FileOutputStream out = new FileOutputStream(outFile);
               //newFile.saveFile(out);
               //System.out.println(standardDef);
               expression.setFinalExpression(expressionField.getText(),
                                                   expressionType);
           }
           catch (ParsingException e)
           {
               JOptionPane.showMessageDialog(null,e.printError());
           }
           catch (SymTableException e)
           {
               JOptionPane.showMessageDialog(null, e.printError());
           }
           catch (Exception e)
           {
               System.out.println("oops");
           }
                           
           /*the expression is not an auxillary expression */
           expression.setAuxillary(false);
       }
       /*if user hits the clear expression button on expression tabbed pane*/
       if(arg.equals("clearexp"))
       {
          expressionField.setText("");
       }
       /*if user hits new icon or new from file menu */
       if(arg.equals("newButton"))
       {
           newExpression();
       }

       /*if user hits new explanation set */    
       if(arg.equals("explanation set"))
       {
           try
           {
               submitExample();
               forwardArrowButtonExplanation();
               forwardArrowButtonExpression();
           }
           catch(Exception e)
           {
           }
           explanationSet();
           loadExample();
       }
       /*if new from file menu */
       if(arg.equals("expression"))
       {
           newExpression();
       }
       /*if new example from file menu*/
       if(arg.equals("new example"))
       {
           newExpression();
       }
       /*if user hits the open icon */
       if(arg.equals("openButton"))
       {
            openFile();
       }
       /*if user chooses open from file menu */
       if(arg.equals("Open"))
       {
           openFile();
       }
       /*if user hits the save icon (disk) */
       if(arg.equals("saveButton"))
       {
           try
           {
               boolean temp;
               String s = languageArea.getText();
               if (languageArea.getText().equals(""))
                   temp = false;
               else
                   temp = true;
              
               if (!temp)
                   submitLanguage();
               else
                   submitExample();
                   
               expression.setExample(temp);
               example = temp;
               forwardArrowButtonExplanation();
               forwardArrowButtonExpression();
           }
           catch(IndexException e)
           {
           }
           catch(Exception e)
           {
           }
           save();
       }
       /*if user chooses save from the drop down file menu */
       if(arg.equals("Save"))
       {
           try
           {
               boolean temp = expression.getExample();
               if (!temp)
                   submitLanguage();
               else
                   submitExample();
               expression.setExample(temp);
               forwardArrowButtonExplanation();
               forwardArrowButtonExpression();
           }
           catch(IndexException e)
           {
           }
           catch(Exception e)
           {
           }
           save();
       }
       /*if user hits the forward arrow button for expression */
       if(arg.equals("forwardRegExp"))
       {
           try
           {
               forwardArrowButtonExpression();
           }
           catch(IndexException e)
           {
           }
           catch(Exception e)
           {
           }
       }
       /*if user hits the back arrow button for expression text area */
       if(arg.equals("backRegExp"))
       {
           try
           {
               backArrowButtonExpression();
           }
           catch(IndexException e)
           {
           }
           catch(Exception e)
           {
           }
       }
       
       /*if user hits the forward arrow button for explanation */
       if(arg.equals("forwardExpl"))
       {
           try
           {
               forwardArrowButtonExplanation();
           }
           catch (IndexException e)
           {
           }
           catch (Exception e)
           {
           }
       }
       /*if user hits the back arrow button for explanation area */
       if(arg.equals("backExpl"))
       {
           try
           {
               backArrowButtonExplanation();
           }
           catch(IndexException e)
           {
           }
           catch(Exception e)
           {
           }
       }
       /*********************************************************************
        * for when user opens up an existing file, and is example load
        * example steps
        * *******************************************************************/
        if(arg.equals("openForwardArrow"))
        {
            try
            {
                loadExpressionStepsForward();
            }
            catch(IndexException e)
            {
            }
            catch(Exception e)
            {
            }
        }
        if(arg.equals("openForwardArrow2"))
        {
            try
            {
                loadExplanationStepsForward();
            }
            catch(IndexException e)
            {
            }
            catch(Exception e)
            {
            }
        }
        if(arg.equals("openBackArrow"))
        {
            try
            {
               loadExpressionStepsBack();
            }
            catch(IndexException e)
            {
            }
            catch(Exception e)
            {
            }
        }
        if(arg.equals("openBackArrow2"))
        {
            try
            {
                loadExplanationStepsBack();
            }
            catch(IndexException e)
            {
            }
            catch(Exception e)
            {
            }
        }
       /*if user hits the submit button on expression tabbed pane */
       if(arg.equals("submitLang"))
       {
           submitLanguage();
       }
       /*if user is creating an example and needs to submit the language
         for example - get font attributes
       */
       if(arg.equals("submitExample"))
       {
           submitExample();
       }
       if(arg.equals("clearExample"))
           languageArea.setText("");
       /*if user hits the enter button on auxillary tabbed pane */
       if(arg.equals("enter"))
       {
           enter();
       }
       /*if user hits the edit button on aux tabbed pane */
       if(arg.equals("edit"))
       {
          edit();
       }
       /*if user hits delete button from aux tabbed pane */
       if(arg.equals("delete"))
       {
          delete();
       }
       /*if user hits the submit button on auxillary tabbed pane */
      if(arg.equals("submitAux"))
      {   
          String auxiliary = "";
          for (int i = 0; i < exprList.getModel().getSize(); i++)
          {
              auxiliary = auxiliary + exprList.getModel().getElementAt(i) + ",";
          }
          auxiliary = auxiliary + finalAuxExpr.getText();
          
          try
          {
              //submitAuxillary();
              Parser parse1 = new Parser();
              StateMachine Answer = parse1.parse(auxiliary, Reader.SETNEW, null);
              Font font = new Font("Monospaced", Font.PLAIN, 18);
              JOptionPane jpane = new JOptionPane();
              jpane.setFont(font);
              //TextLayout test = new TextLayout("Entered", font, null);
              jpane.showMessageDialog(null, "Entered Expression is in correct form.");
            
              //JOptionPane.showMessageDialog(null,"Entered Expression is in correct form.");
              //FSAFile newFile = new FSAFile(Answer);
              //File outFile = new File("C:/Pascoe/Research03/testFiles/fsaT2.fsa");
              //FileOutputStream out = new FileOutputStream(outFile);
              //newFile.saveFile(out);
              submitAuxillary();
              //System.out.println(standardDef);
          }
          catch (ParsingException e)
          {
              JOptionPane.showMessageDialog(null,e.printError());
          }
          catch (SymTableException e)
          {
              JOptionPane.showMessageDialog(null, e.printError());
          }
          catch (Exception e)
          {               
              System.out.println("oops");
          }
          //System.out.println("aux Here");
           
      }
      /*if user hits the step button on the run example tabbed pane
        will step thur all steps to explain how to build expression
      */
      if(arg.equals("step"))  //step thru expression
      {  
           if(count==0)
           {
               regExpArea.setText(" ");
               explArea2.setText(""); //resest text fields
               regExpArea.setForeground(Color.black);
           }
          
          stepExpression();

           
       }
      /*if user hits the run button on run example tabbed pane,
        can only run the current example
      */
      if(arg.equals("run")) //animate the displaying of expression
      {
          count = 0;
          regExpArea.setText("");
          explArea2.setText(""); //reset text fields to blank
          regExpArea.setForeground(Color.black);
          timer.restart();
         
             
      }
      /*if user hits the pause button, pause the animation */
      if(arg.equals("pause"))
      {
          runButton.setEnabled(false);
          //stepButton.setEnabled(false);
         
          if(numClicks%2==0)   //stop the animation
          {   
             pauseButton.setBackground(Color.red);
             timer.stop();
          }
          else  //restart the animation
          {
             pauseButton.setBackground(Color.green);
             timer.start();
          }
          numClicks++;
      }
      /*if user chooses to load stand or ebnf example*/
      
       
      /*if user hits the quit maybe get rid of*/
      if(arg.equals("Quit"))
      {
         String message = "Are you sure you want to quite, this will "+
                           "close the XML file";
         String title = "quite dialog";
         int result=0;
         if(hitSaveButton ==false)
         {
             JOptionPane.showMessageDialog(
                    submitLangButton,"you must save expression before you quit",
                    "save before you quite",JOptionPane.WARNING_MESSAGE);
         }
         else
         {
             result = JOptionPane.showConfirmDialog(submitLangButton,message,title,
                                JOptionPane.YES_NO_OPTION,
                                JOptionPane.QUESTION_MESSAGE);
         }

         switch(result)
         {
             case JOptionPane.YES_OPTION:
                       out.flush();
                       out.close();
                       break;

             case JOptionPane.NO_OPTION:
                       break;
         }
      }
         
    }//end action perfomed

    /* this function finds out what tabbed pane panel has focus, get the
       title of that tabbed pane
    */
    public void stateChanged(ChangeEvent e)
    {
        JTabbedPane tp = (JTabbedPane)e.getSource();
        int index = tp.getSelectedIndex();
        String s = tp.getTitleAt(index);

        /*create exampe tabbed pane has focus, set run tabbed pane text fields
          to empty string
        */
      
        if(s.equals("create example"))
        {
           explArea2.setText("");
           regExpArea.setText("");
           /*reset counter, needed for step button on run panel */
           count = 0;
        }          
    }
/**************************************************************************/
    /* just a helper class, for putting buttons on panels */
    class ButtonPanel extends JPanel
    {
        JPanel buttonPanel = new JPanel();
        JSeparator sep = new JSeparator();


        public ButtonPanel()
        {
           buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
           setLayout(new BorderLayout(0,5));
           add(sep,"North");
           add(buttonPanel,"Center");
         }
         public void add(JButton button)
         {
            buttonPanel.add(button);
            
         }
     }
  
}
