package FSAComponents;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;


public final class FSAOperations
{
    public static StateMachine makeDeterministic(StateMachine nfsa)
    {
        Character symbol;
        HashMap n2dMap;
        HashSet stateSets, endStateSet, startStateSet;
        Iterator emptyStates, transitions, states, symbols;
        State dfsaStartState, nfsaStartState, startState, endState;
        State emptyState, state;
        StateMachine dfsa;
        SymbolSet alphabet;
        Transition transition;
        Vector stateSetQueue;

        n2dMap = new HashMap();
        stateSets = new HashSet();
        dfsa = new StateMachine();
        stateSetQueue = new Vector();
        alphabet = nfsa.getAlphabet();

        try
        {
            dfsa.getAlphabet().addSymbols(nfsa.getAlphabet().getSymbolArray());
        }
        catch(SymbolChangeException e)
        {
            //This shouldn't happen
            System.exit(1);
        }

        nfsaStartState = nfsa.getStartState();

        dfsaStartState = new State();
        dfsa.addState(dfsaStartState);
        dfsaStartState.setStartState(true);

        startStateSet = new HashSet();
        startStateSet.add(nfsaStartState);

        states = getEmptyTransitionSet(nfsaStartState);

        while(states.hasNext())
        {
            state = (State)states.next();
            startStateSet.add(state);
        }

        dfsaStartState.setFinalState(hasFinalState(startStateSet));

        n2dMap.put(startStateSet, dfsaStartState);
        stateSets.add(startStateSet);

        stateSetQueue.add(startStateSet);

        while(!stateSetQueue.isEmpty())
        {
            startStateSet = (HashSet)stateSetQueue.remove(0);

            startState = (State)n2dMap.get(startStateSet);

            symbols = alphabet.getSymbols();

            while(symbols.hasNext())
            {
                symbol = (Character)symbols.next();
                if(!symbol.equals(StateMachine.EMPTY_SYMBOL))
                {
                    endStateSet = new HashSet();

                    states = startStateSet.iterator();
                    while(states.hasNext())
                    {
                        state = (State)states.next();

                        transitions = nfsa.transitionFunction(state, symbol);

                        while(transitions.hasNext())
                        {
                            transition = (Transition)transitions.next();
                            endState = transition.getDestination();
                            endStateSet.add(endState);

                            emptyStates = getEmptyTransitionSet(endState);
                            while(emptyStates.hasNext())
                            {
                                emptyState = (State)emptyStates.next();
                                endStateSet.add(emptyState);
                            }
                        }
                    }

                    if(!endStateSet.isEmpty())
                    {
                        if(!stateSets.contains(endStateSet))
                        {
                            endState = new State();
                            dfsa.addState(endState);
                            endState.setFinalState(hasFinalState(endStateSet));

                            n2dMap.put(endStateSet, endState);
                            stateSets.add(endStateSet);
                            stateSetQueue.add(endStateSet);
                        }
                        else
                        {
                            endState = (State)n2dMap.get(endStateSet);
                        }

                        if(dfsa.transitionExists(startState, endState))
                        {
                            transition = dfsa.getTransition(startState,
                                                            endState);
                        }
                        else
                        {
                            transition = new Transition(startState, endState);
                            dfsa.addTransition(transition);
                        }

                        try
                        {
                            transition.getSymbolSet().addSymbol(symbol);
                        }
                        catch(SymbolChangeException e)
                        {
                            //This shouldn't happen
                            System.exit(1);
                        }
                    }
                }
            }
        }

        return dfsa;
    }

    protected static Iterator getEmptyTransitionSet(State startState)
    {
        HashSet stateSet;
        Iterator transitions;
        State state, destination;
        StateMachine fsa;
        Transition transition;
        Vector stateQueue;

        fsa = startState.getOwner();
        stateQueue = new Vector();
        stateSet = new HashSet();

    stateSet.add(startState);
        stateQueue.add(startState);

        while(!stateQueue.isEmpty())
        {
            state = (State)stateQueue.remove(0);
            
            transitions = fsa.transitionFunction(state, fsa.EMPTY_SYMBOL);

            while(transitions.hasNext())
            {
                transition = (Transition)transitions.next();
        destination = transition.getDestination();

        if(!stateSet.contains(destination))
        {
            stateQueue.add(destination);
            stateSet.add(destination);
        }
            }
        }

        return stateSet.iterator();
    }

    protected static boolean hasFinalState(HashSet stateSet)
    {
        Iterator states;
        State state;

        states = stateSet.iterator();

        while(states.hasNext())
        {
            state = (State)states.next();

            if(state.isFinalState())
            {
                return true;
            }
        }

        return false;
    }

    public static StateMachine complement(StateMachine fsa)
    {
        Iterator states;
        State state;
        StateMachine comp_fsa;

    comp_fsa = copy(fsa);
        states = comp_fsa.getStates();

        while(states.hasNext())
        {
            state = (State)states.next();
        state.setFinalState(!state.isFinalState());
        }

        return comp_fsa;
    }

    public static StateMachine copy(StateMachine fsa)
    {
        Character symbols[];
        HashMap statesMap;
        Iterator states, transitions;
        State state, newState, startState, endState;
        StateMachine copy_fsa;
        Transition transition, newTransition;

        statesMap = new HashMap();
        copy_fsa = new StateMachine();

        symbols = fsa.getAlphabet().getSymbolArray();

        try
        {
            copy_fsa.getAlphabet().addSymbols(symbols);
        }
        catch(SymbolChangeException sce)
        {
            //This shouldn't happen
            System.exit(1);
        }

        states = fsa.getStates();

        while(states.hasNext())
        {
            state = (State)states.next();

            newState = new State();
            statesMap.put(state, newState);
            copy_fsa.addState(newState);

            newState.setPosition(state.getPosition());

            if(state.isStartState())
            {
                newState.setStartState(true);
            }

            if(state.isFinalState())
            {
                newState.setFinalState(true);
            }
        }

        transitions = fsa.getTransitions();

        while(transitions.hasNext())
        {
            transition = (Transition)transitions.next();

            startState = transition.getSource();
            endState = transition.getDestination();

            newTransition = new Transition((State)statesMap.get(startState),
                                           (State)statesMap.get(endState));

            symbols = transition.getSymbolSet().getSymbolArray();

            try
            {
                newTransition.getSymbolSet().addSymbols(symbols);
            }
            catch(SymbolChangeException sce)
            {
                //This shouldn't happen
                System.exit(1);
            }

            copy_fsa.addTransition(newTransition);
        }
        return copy_fsa;
    }

    public static void addDeadState(StateMachine fsa)
    {
    State state, deadState = new State();
    Transition transition;

    fsa.addState(deadState);
    
    Transition deadLoop = new Transition(deadState, deadState);

    try
    {
        deadLoop.getSymbolSet().addSymbols(fsa.getAlphabet().getSymbolArray());
        deadLoop.getSymbolSet().removeSymbol(StateMachine.EMPTY_SYMBOL);
    }
    catch(SymbolChangeException sce)
    {
        //This shouldn't happen
        System.exit(1);
    }

    fsa.addTransition(deadLoop);

    Iterator states, symbols;

        states = fsa.getStates();

    SymbolSet deadSymbols = new SymbolSet(null);
    Character symbol;

        while(states.hasNext())
        {
            state = (State)states.next();

        if(state != deadState)
        {
        symbols = fsa.getAlphabet().getSymbols();

        while(symbols.hasNext())
        {
            symbol = (Character)symbols.next();

            if(!symbol.equals(StateMachine.EMPTY_SYMBOL) && !fsa.transitionFunction(state, symbol).hasNext())
            {
            try
            {
                deadSymbols.addSymbol(symbol);
            }
            catch(SymbolChangeException sce)
            {
                //This shouldn't happen
                System.exit(1);
            }
            }
        }

        if(!deadSymbols.isEmpty())
        {
            transition = new Transition(state, deadState);

            try
            {
            transition.getSymbolSet().addSymbols(deadSymbols.getSymbolArray());
            }
            catch(SymbolChangeException sce)
            {
            //This shouldn't happen
            System.exit(1);
            }

            fsa.addTransition(transition);
        }

        try
        {
            deadSymbols.clear();
        }
        catch(SymbolChangeException sce)
        {
            //This shouldn't happen
            System.exit(1);
        }
        
        }
    }
    }


    public static StateMachine intersect(StateMachine fsa1,
                                         StateMachine fsa2)
    {
        Character symbol;
        HashMap statesMap;
        Iterator states1, states2, dests, symbols, pairs;
        State state1, state2, source, dest, dest1, dest2, newState;
        StateMachine intersection;
        SymbolSet alphabet;
        Transition transition;
        Vector pair;

        statesMap = new HashMap();
        intersection = new StateMachine();

        alphabet = intersection.getAlphabet();

        try
        {
            alphabet.addSymbols(fsa1.getAlphabet().getSymbolArray());
            alphabet.addSymbols(fsa2.getAlphabet().getSymbolArray());
        }
        catch(SymbolChangeException sce)
        {
            //This shouldn't happen
            System.exit(1);
        }

        states1 = fsa1.getStates();

        while(states1.hasNext())
        {
            state1 = (State)states1.next();
            states2 = fsa2.getStates();

            while(states2.hasNext())
            {
                state2 = (State)states2.next();

                pair = new Vector();
                pair.add(state1);
                pair.add(state2);

                newState = new State();
                intersection.addState(newState);
                statesMap.put(pair, newState);

                if(state1.isStartState() && state2.isStartState())
                {
                    newState.setStartState(true);
                }

                if(state1.isFinalState() && state2.isFinalState())
                {
                    newState.setFinalState(true);
                }
            }
        }

        symbols = alphabet.getSymbols();

        while(symbols.hasNext())
        {
            symbol = (Character)symbols.next();
            pairs = statesMap.keySet().iterator();

            while(pairs.hasNext())
            {

                pair = (Vector)pairs.next();
                state1 = (State)pair.elementAt(0);
                state2 = (State)pair.elementAt(1);

                source = (State)statesMap.get(pair);
                dests = fsa1.transitionFunction(state1, symbol);

                if(dests.hasNext())
                {
                    dest1 = ((Transition)dests.next()).getDestination();
                    dests = fsa2.transitionFunction(state2, symbol);

                    if(dests.hasNext())
                    {
                        dest2 = ((Transition)dests.next()).getDestination();

                        pair = new Vector();
                        pair.add(dest1);
                        pair.add(dest2);

                        dest = (State)statesMap.get(pair);
                        dests = intersection.transitionFunction(source,
                                                                symbol);

                        if(dests.hasNext())
                        {
                            transition = (Transition)dests.next();
                        }
                        else
                        {
                            transition = new Transition(source, dest);
                            intersection.addTransition(transition);
                        }

                        try
                        {
                            transition.getSymbolSet().addSymbol(symbol);
                        }
                        catch(SymbolChangeException sce)
                        {
                            //This shouldn't happen
                            System.exit(1);
                        }
                    }
                }
            }
        }

        return intersection;
    }

    public static String getIntersectString(StateMachine fsa1,
                        StateMachine fsa2)
    {
        StateMachine dfsa1, dfsa2, intersection;

    if(fsa1.isDeterministic())
    {
        dfsa1 = makeDeterministic(fsa1);
    }
    else
    {
        dfsa1 = fsa1;
    }

    if(fsa2.isDeterministic())
    {
        dfsa2 = makeDeterministic(fsa2);
    }
    else
    {
        dfsa2 = fsa2;
    }

        intersection = intersect(dfsa1, dfsa2);

        return getAcceptedString(intersection);
    }

        

    public static String getAcceptedString(StateMachine fsa)
    {
        HashSet visitedStates;
        State startState;
        StringBuffer returnValue;

        startState = fsa.getStartState();

        if(startState.isFinalState())
        { 
            return "";
        }

        visitedStates = new HashSet();
        visitedStates.add(startState);
        
        returnValue = getAcceptedString(fsa, startState, visitedStates);

        if(returnValue != null)
        {
            return returnValue.toString();
        }

        return null;
    }

    protected static StringBuffer getAcceptedString(StateMachine fsa,
                                                    State fromState,
                                                    HashSet visitedStates)
    {
        Character symbol;
        Iterator transitions; 
        State nextState;
        StringBuffer acceptedString;
        Transition transition;

        if(fromState.isFinalState())
        {
            return new StringBuffer();
        }

        transitions = fsa.getTransitionsStartingFrom(fromState);

        while(transitions.hasNext())
        {
            transition = (Transition)transitions.next();
            nextState = transition.getDestination();

            if(!visitedStates.contains(nextState))
            {
        visitedStates.add(nextState);

                symbol = getRealSymbol(transition.getSymbolSet());

                if(symbol != null)
                {
                    acceptedString = getAcceptedString(fsa, nextState,
                                                     visitedStates);
                    if(acceptedString != null)
                    {
                        return acceptedString.insert(0, symbol);
                    }
                }
            }
        }

        return null;
    }

    protected static Character getRealSymbol(SymbolSet symbolSet)
    {
        Character symbol;
        Iterator symbols;

        symbols = symbolSet.getSymbols();

        while(symbols.hasNext())
        {
            symbol = (Character)symbols.next();
            if(!StateMachine.EMPTY_SYMBOL.equals(symbol))
            {
                return symbol;
            }

        }

        return null;
    }


    // method to union to fsas
    public static StateMachine union(StateMachine fsa1, StateMachine fsa2)
    {
    HashMap statesMap;
    StateMachine unionFSA;
    SymbolSet unionAlphabet, symbols;
    Iterator states1, states2, trans;
    Transition transition;
    State state1, state2, unionStart, startState, endState;

    statesMap = new HashMap();
    unionFSA = new StateMachine();
    
    unionAlphabet = unionFSA.getAlphabet();
    unionStart = new State();
    unionFSA.addState(unionStart);

    try
    {
        unionAlphabet.addSymbols(fsa1.getAlphabet().getSymbolArray());
        unionAlphabet.addSymbols(fsa2.getAlphabet().getSymbolArray());
    }
    catch (SymbolChangeException sce)
    {
        //This shouldn't happen
        System.exit(1);
    }

    states1 = fsa1.getStates();

    while (states1.hasNext())
    {
        state1 = (State)states1.next();
        
        if (state1.isStartState())
        {
            transition = new Transition(unionStart, state1);
            symbols = transition.getSymbolSet();
            try
            {
                symbols.addSymbol(StateMachine.EMPTY_SYMBOL);
            }
            catch (SymbolChangeException sce)
            {
                System.exit(1);
            }
            unionFSA.addTransition(transition);
        }
        
        unionFSA.addState(state1);
    }
    
    states1 = fsa2.getStates();
    
    while (states1.hasNext())
    {
        state1 = (State)states1.next();
     
        if (state1.isStartState())
        {
            transition = new Transition(unionStart, state1);
            symbols = transition.getSymbolSet();
            try
            {
                symbols.addSymbol(StateMachine.EMPTY_SYMBOL);
            }
            catch (SymbolChangeException sce)
            {
                System.exit(1);
            }
            unionFSA.addTransition(transition);
        }
        
        unionFSA.addState(state1);
    }    
    unionStart.setStartState(true);

    trans = fsa1.getTransitions();
    
    while (trans.hasNext())
    {
        transition = (Transition)trans.next();
        unionFSA.addTransition(transition);
    }
    
    trans = fsa2.getTransitions();
    
    while (trans.hasNext())
    {
        transition = (Transition)trans.next();
        unionFSA.addTransition(transition);
    }

    return unionFSA;
    }   
    
    
    // method to concatenate two fsas
    public static StateMachine concatenation(StateMachine fsaA, StateMachine fsaB)
    {
    HashMap statesMap;
    StateMachine catFSA;
    SymbolSet catAlphabet, symbols;
    Iterator states1, states2, trans;
    Transition transition;
    State state1, state2, catStart, startState, endState;

    StateMachine fsa1 = fsaA;
    StateMachine fsa2 = fsaB;

    statesMap = new HashMap();
    catFSA = new StateMachine();
    
    catAlphabet = catFSA.getAlphabet();

    try
    {
        catAlphabet.addSymbols(fsa1.getAlphabet().getSymbolArray());
        catAlphabet.addSymbols(fsa2.getAlphabet().getSymbolArray());
    }
    catch (SymbolChangeException sce)
    {
        //This shouldn't happen
        System.exit(1);
    }

    states1 = fsa2.getStates();

    while (states1.hasNext())
    {
        state1 = (State)states1.next();
        catFSA.addState(state1);
    }
    
    states1 = fsa1.getStates();
    
    while (states1.hasNext())
    {
        state1 = (State)states1.next();
        
        if (state1.isFinalState())
        {
            state1.setFinalState(false);
            transition = new Transition(state1, fsa2.getStartState());
            symbols = transition.getSymbolSet();
            try
            {
                symbols.addSymbol(StateMachine.EMPTY_SYMBOL);
            }
            catch (SymbolChangeException sce)
            {
                System.exit(1);
            }
            catFSA.addTransition(transition);
        }
        
        catFSA.addState(state1);
    }  
    catFSA.setStartState(fsa1.getStartState());
  
    trans = fsa1.getTransitions();
    
    while (trans.hasNext())
    {
        transition = (Transition)trans.next();
        catFSA.addTransition(transition);
    }
    
    trans = fsa2.getTransitions();
    
    while (trans.hasNext())
    {
        transition = (Transition)trans.next();
        catFSA.addTransition(transition);
    }

    return catFSA;
    }   
    
    // method to perform star operation
    public static StateMachine star(StateMachine fsa1)
    {
    HashMap statesMap;
    StateMachine starFSA;
    SymbolSet starAlphabet, symbols;
    Iterator states1, states2, trans;
    Transition transition;
    State state1, state2, starStart, startState, endState;

    statesMap = new HashMap();
    starFSA = new StateMachine();
    
    starAlphabet = starFSA.getAlphabet();

    try
    {
        starAlphabet.addSymbols(fsa1.getAlphabet().getSymbolArray());
    }
    catch (SymbolChangeException sce)
    {
        //This shouldn't happen
        System.exit(1);
    }
    
    starStart = new State();
    starFSA.addState(starStart);
    
    states1 = fsa1.getStates();
    
    while (states1.hasNext())
    {
        state1 = (State)states1.next();
        
        if (state1.isStartState())
        {
            transition = new Transition(starStart, state1);
            symbols = transition.getSymbolSet();
            try
            {
                symbols.addSymbol(StateMachine.EMPTY_SYMBOL);
            }
            catch (SymbolChangeException sce)
            {
                System.exit(1);
            }
            starFSA.addTransition(transition);
        }
        
        if (state1.isFinalState())
        {
            transition = new Transition(state1, starStart);
            symbols = transition.getSymbolSet();
            try
            {
                symbols.addSymbol(StateMachine.EMPTY_SYMBOL);
            }
            catch (SymbolChangeException sce)
            {
                System.exit(1);
            }
            starFSA.addTransition(transition);
        }
        
        starFSA.addState(state1);
    }  
    starFSA.setStartState(starStart);
    starStart.setFinalState(true);
  
    trans = fsa1.getTransitions();
    
    while (trans.hasNext())
    {
        transition = (Transition)trans.next();
        starFSA.addTransition(transition);
    }

    return starFSA;
    }   
    
    public StateMachine createSimple(char ch)
    {
        Transition transition, t1;
	    StateMachine FSA1 = new StateMachine();
	    State one = new State();
	    State two = new State();
	    
	    FSA1.addState(one);
	    FSA1.addState(two);
	    t1 = new Transition(one, two);
	    FSA1.setStartState(one);
	    two.setFinalState(true);
	    FSA1.addTransition(t1);
	    try
	    {
	        FSA1.getAlphabet().addSymbol(ch);
	        t1.getSymbolSet().addSymbol(ch);
	    }
	    catch (SymbolChangeException sce)
	    {
	        System.exit(1);
	    }
	    
	    return FSA1;
    }
    
    public StateMachine createEmptySet()
    {
	    StateMachine FSA1 = new StateMachine();
	    State one = new State();
	    
	    FSA1.addState(one);
	    FSA1.setStartState(one);
	    
	    return FSA1;
    }
    
    public StateMachine createLambda()
    {
        StateMachine FSA1 = new StateMachine();
	    State one = new State();
	    
	    FSA1.addState(one);
	    FSA1.setStartState(one);
	    one.setFinalState(true);
	    
	    return FSA1;
    }
    
    public String compare(StateMachine one, StateMachine two)
    {
        String s;
        
        StateMachine fsa1 = makeDeterministic(one);
        StateMachine fsa2 = makeDeterministic(two);
        addDeadState(fsa1);
        addDeadState(fsa2);
        StateMachine compfsa1 = complement(copy(fsa1));
        StateMachine compfsa2 = complement(copy(fsa2));
        
        s = getIntersectString(fsa1, compfsa2);
        System.out.println(s);
        if (s != null)
        {
            return "1" + s;
        }
        
        s = getIntersectString(compfsa1, fsa2);
        
        System.out.println(s);
        if (s != null)
        {
            return "2" + s;
        }
        
        return null;
    }
}
