package FSAComponents;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;

public class State
{
    HashMap _properties;
    String _id;
    boolean _finalState;
    StateMachine _owner;
    Object _userObject;
    private static int nextID = 0;

    public State()
    {
	_id = Integer.toString(nextID++);
	_owner = null;
	_finalState = false;
	_properties = new HashMap();
    }

    public int hashCode()
    {
	return _id.hashCode();
    }

    public String toString()
    {
	return _id;
    }

    public String getKey()
    {
	return _id;
    }

    public String getDescription()
    {
	return (String)_properties.get("description");
    }

    public void setDescription(String description)
    {
	_properties.put("description", description);

	if(_owner != null)
	{
	    _owner.stateDescriptionChange(this);
	}
    }

    public boolean equals(Object obj)
    {
	if(obj instanceof State)
	{
	    return _id.equals(((State)obj).toString());
	}

	return false;
    }

    public void setStartState(boolean startState)
    {
	if(_owner != null && isStartState() != startState)
	{
	    if(startState)
	    {
		_owner.setStartState(this);
	    }
	    else
	    {
		_owner.setStartState(null);
	    }
	}
    }

    public void setFinalState(boolean finalState)
    {
	_finalState = finalState;

	if(_owner != null)
	{
	    _owner.finalStateChange(this);
	}
    }

    public boolean isStartState()
    {
	if(_owner != null)
	{
	    return this == _owner.getStartState();
	}

	return false;
    }

    public boolean isFinalState()
    {
	return _finalState;
    }

    public StateMachine getOwner()
    {
	return _owner;
    }

    protected void setOwner(StateMachine owner)
    {
	_owner = owner;
    }

    public void setUserObject(Object userObject)
    {
	_userObject = userObject;
    }

    public Object getUserObject()
    {
	return _userObject;
    }

    public Point2D getPosition()
    {
	double x = 0;
	double y = 0;

	if(_properties.containsKey("x"))
	{
	    x = Double.valueOf((String)_properties.get("x")).doubleValue();
	}

	if(_properties.containsKey("y"))
	{
	    y = Double.valueOf((String)_properties.get("y")).doubleValue();
	}

	return new Point2D.Double(x, y);
    }

    public void setPosition(Point2D position)
    {
	setProperty("x", Double.toString(position.getX()));
	setProperty("y", Double.toString(position.getY()));
    }

    public void setProperty(String name, String value)
    {
	_properties.put(name, value);
	_owner.statePropertyChange(this, name);
    }

    public String getProperty(String name)
    {
	return (String)_properties.get(name);
    }

    public Iterator getPropertyNames()
    {
	return _properties.keySet().iterator();
    }
}
