package FSAComponents;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;


public class StateMachine
    implements java.io.Serializable
{
    private SymbolSet alphabet;
    private HashMap refCounts;
    private HashMap transitions;
    private HashSet states;
    private HashMap function;
    private HashMap sources;
    private HashMap destinations;
    private HashMap symbolAdapters;
    private State startState;
    private int stateNum;
    public static final Character EMPTY_SYMBOL = new Character('\u03b5');
    private static final HashSet empty_set = new HashSet();

    private HashMap specificListeners;
    private HashSet transitionListeners;
    private HashSet stateListeners;
    private String description;

    public StateMachine()
    {
	SymbolAdapter sa;

	stateNum = 0;

	refCounts = new HashMap();
	alphabet = new SymbolSet(this);
	states = new HashSet();
	transitions = new HashMap();

	function = new HashMap();
	sources = new HashMap();
	destinations = new HashMap();
    
	startState = null;

	try
	{
	    ReferenceCount rc;

	    alphabet.addSymbol(EMPTY_SYMBOL);
	    rc = new ReferenceCount(EMPTY_SYMBOL);
	    //rc.incrementCount();

	    refCounts.put(EMPTY_SYMBOL, rc);
	}
	catch(SymbolChangeException sce)
	{
	    System.err.println("This shouldn't have happened!");
	    sce.printStackTrace();
	}

	sa = new SymbolAdapter(this, null, "alphabetSymbolsAdded",
			       "requestAlphabetSymbolRemoval",
			       "alphabetSymbolsRemoved");
	alphabet.addSymbolListener(sa);

	specificListeners = new HashMap();
	symbolAdapters = new HashMap();
	transitionListeners = new HashSet();
	stateListeners = new HashSet();
    }

    public void alphabetSymbolsAdded(SymbolEvent e)
    {
	Iterator i;
	Character symbol;
	
	i = e.getSymbols();

	while(i.hasNext())
	{
	    symbol = (Character)i.next();
	    refCounts.put(symbol, new ReferenceCount(symbol));
	}
    }

    public void requestAlphabetSymbolRemoval(VetoableSymbolEvent e)
    {
	Iterator i;
	Character symbol;
	ReferenceCount rc;

	i = e.getSymbols();

	while(i.hasNext())
	{
	    symbol = (Character)i.next();
	    rc = (ReferenceCount)refCounts.get(symbol);

	    if(rc != null && rc.getCount() > 0)
	    {
		e.veto("The symbol " + symbol +
		       " is being used and cannot be removed from the alphabet.");
		return;
	    }
	}
    }

    public void alphabetSymbolsRemoved(SymbolEvent e)
    {
	Iterator i;

	i = e.getSymbols();

	while(i.hasNext())
	{
	    refCounts.remove(i.next());
	}
    }
      
    public SymbolSet getAlphabet()
    {
	return alphabet;
    }
    
    public boolean symbolInUse(Character symbol)
    {
	ReferenceCount rc = (ReferenceCount)refCounts.get(symbol);

	if(rc != null)
	    return rc.getCount() > 0;
	else
	    return false;
    }

    public void addState(State state)
    {
	if(!states.contains(state))
	{
	    states.add(state);
	    state.setOwner(this);

	    fireStateEvent(state, StateEvent.ADDED);
	}
    }

    public void removeState(State s)
    {
	if(states.contains(s))
	{
	    Transition t;
	    HashSet transitionSet;
	    Iterator transitions;

	    if(s.isStartState())
	    {
		s.setStartState(false);
	    }

	    if(sources.containsKey(s))
	    {
		transitionSet = (HashSet)((HashSet)sources.get(s)).clone();
		transitions = transitionSet.iterator();

		while(transitions.hasNext())
		{
		    removeTransition((Transition)transitions.next());
		}
	    }
	    
	    if(destinations.containsKey(s))
	    {
		transitionSet = (HashSet)((HashSet)destinations.get(s)).clone();
		transitions = transitionSet.iterator();
	    
		while(transitions.hasNext())
		{
		    removeTransition((Transition)transitions.next());
		}
	    }
	    
	    states.remove(s);
	    s.setOwner(null);

	    fireStateEvent(s, StateEvent.REMOVED);
	}
    }

    protected void finalStateChange(State s)
    {
	if(states.contains(s))
	{
	    fireStateEvent(s, StateEvent.FINAL);
	}
    }

    protected void stateDescriptionChange(State s)
    {
	if(states.contains(s))
	{
	    fireStateEvent(s, StateEvent.DESCRIPTION);
	}
    }

    protected void statePositionChange(State s)
    {
	if(states.contains(s))
	{
	    fireStateEvent(s, StateEvent.POSITION);
	}
    }

    protected void statePropertyChange(State state, String propertyName)
    {
	fireStatePropertyEvent(state, propertyName);
    }

    public void addTransition(Transition transition)
    {
	if(!transitions.containsKey(transition.getKey()))
	{
	    Character symbol;
	    Iterator iterator;
	    ReferenceCount rc;
	    SymbolAdapter sa;

	    transitions.put(transition.getKey(), transition);
	    addToHashedSet(sources, transition.getSource(), transition);
	    addToHashedSet(destinations, transition.getDestination(),
			   transition);

	    iterator = transition.getSymbolSet().getSymbols();

	    while(iterator.hasNext())
	    {
		symbol = (Character)iterator.next();
		
		addToHashedSet(function, transition.functionKey(symbol),
			       transition);
		
		rc = (ReferenceCount)refCounts.get(symbol);
		rc.incrementCount();
	    }

	    sa = new SymbolAdapter(this, "requestTransitionSymbolAddition",
				   "transitionSymbolsAdded", null,
				   "transitionSymbolsRemoved");
	    transition.getSymbolSet().addSymbolListener(sa);
	    symbolAdapters.put(transition.getKey(), sa);

	    transition.setOwner(this);

	    fireTransitionEvent(TransitionEvent.ADDED, transition);
	}
    }

    public void removeTransition(Transition transition)
    {
	if(transitions.containsKey(transition.getKey()))
	{
	    Character symbol;
	    Iterator iterator;
	    ReferenceCount rc;
	    SymbolAdapter sa;

	    transitions.remove(transition.getKey());
	    removeFromHashedSet(sources, transition.getSource(), transition);
	    removeFromHashedSet(destinations, transition.getDestination(),
				transition);

	    sa = (SymbolAdapter)symbolAdapters.get(transition.getKey());
	    symbolAdapters.remove(transition.getKey());
	    transition.getSymbolSet().removeSymbolListener(sa);

	    iterator = transition.getSymbolSet().getSymbols();

	    while(iterator.hasNext())
	    {
		symbol = (Character)iterator.next();
		
		removeFromHashedSet(function, transition.functionKey(symbol),
				    transition);
		
		rc = (ReferenceCount)refCounts.get(symbol);
		rc.decrementCount();
	    }

	    transition.setOwner(null);
	    fireTransitionEvent(TransitionEvent.REMOVED, transition);
	}
    }

    protected void addToHashedSet(HashMap hm, Object key, Object value)
    {
	Set set;

	if(hm.containsKey(key))
	{
	    set = (Set)hm.get(key);
	}
	else
	{
	    set = new HashSet();
	    hm.put(key, set);
	}

	set.add(value);
    }

    protected void removeFromHashedSet(HashMap hm, Object key, Object value)
    {
	if(hm.containsKey(key))
	{
	    Set set = (Set)hm.get(key);

	    set.remove(value);

	    if(set.size() == 0)
	    {
		hm.remove(key);
	    }
	}
    }

    public void requestTransitionSymbolAddition(VetoableSymbolEvent e)
    {
	Iterator i;
	Character symbol;

	i = e.getSymbols();

	while(i.hasNext())
	{
	    symbol = (Character)i.next();
	    if(!alphabet.contains(symbol))
	    {
		e.veto(symbol + " not in alphabet");
		return;
	    }
	}
    }

    public void transitionSymbolsAdded(SymbolEvent e)
    {
	Character symbol;
	SymbolUser su;
	ReferenceCount rc;
	Transition t;
	Iterator i;

	i = e.getSymbols();
	su = (SymbolUser)e.getSource();
	t = (Transition)su.getOwner();

	while(i.hasNext())
	{
	    symbol = (Character)i.next();
	    rc = (ReferenceCount) refCounts.get(symbol);
	    rc.incrementCount();
	    addToHashedSet(function, t.functionKey(symbol), t);
	}

	fireTransitionEvent(TransitionEvent.SYMBOLCHANGE, t);
    }

    public void transitionSymbolsRemoved(SymbolEvent e)
    {
	Character symbol;
	SymbolUser su;
	ReferenceCount rc;
	Transition t;
	Iterator i;

	i = e.getSymbols();
	su = (SymbolUser)e.getSource();
	t = (Transition)su.getOwner();

	while(i.hasNext())
	{
	    symbol = (Character)i.next();

	    rc = (ReferenceCount) refCounts.get(symbol);
	    rc.decrementCount();

	    removeFromHashedSet(function, t.functionKey(symbol), t);
	}

	fireTransitionEvent(TransitionEvent.SYMBOLCHANGE, t);
    }


    public boolean equals(Object obj)
    {
	if(obj instanceof StateMachine)
	{
	    StateMachine sm = (StateMachine) obj;
	    return alphabet.equals(sm.alphabet) &&
		transitions.equals(sm.transitions) &&
		states.equals(sm.states) &&
		function.equals(sm.function) &&
		stateNum == sm.stateNum;
	}

	return false;
    }

    public Iterator transitionFunction(State state, Character symbol)
    {
	HashSet transitions;
	String functionKey;

	functionKey = Transition.generateFunctionKey(state, symbol);
	transitions = (HashSet)function.get(functionKey);

	if(transitions == null)
	    return ((HashSet)empty_set.clone()).iterator();
    
	return Arrays.asList(transitions.toArray()).iterator();
    }

    public Iterator getStates()
    {
	return Arrays.asList(states.toArray()).iterator();
    }
    
    public Iterator getTransitions()
    {
	return Arrays.asList(transitions.values().toArray()).iterator();
    }
    
    public Iterator getTransitionsStartingFrom(State state)
    {
	HashSet transitions = (HashSet)sources.get(state);
	
	if(transitions != null)
	{
	    return ((HashSet)transitions.clone()).iterator();
	}
	
	return ((HashSet)empty_set.clone()).iterator();
    }
    
    public State getStartState()
    {
	return startState;
    }

    public Iterator getFinalStates()
    {
	ArrayList finalStates;
	Iterator states;
	State state;

	finalStates = new ArrayList();

	states = getStates();

	while(states.hasNext())
	{
	    state = (State)states.next();
	    if(state.isFinalState())
	    {
		finalStates.add(state);
	    }
	}

	return finalStates.iterator();
    }
	

    public void setStartState(State s)
    {
	if(s != startState && (s == null || states.contains(s)))
	{
	    State oldStart = startState;

	    startState = s;

	    if(oldStart != null)
	    {
		fireStateEvent(oldStart, StateEvent.START);
	    }

	    if(s != null)
	    {
		fireStateEvent(s, StateEvent.START);
	    }
	}
    }

    public boolean transitionExists(State start, State end)
    {
	return transitions.containsKey(Transition.generateKey(start, end));
    }

    public Transition getTransition(State source, State destination)
    {
	String key = Transition.generateKey(source, destination);
	return (Transition)transitions.get(key);
    }
    
    public boolean isDeterministic()
    {
	ReferenceCount rc;
	Iterator iterator;
	HashSet set;
	
	rc = (ReferenceCount)refCounts.get(EMPTY_SYMBOL);
	
	if(rc.getCount() > 0)
	{
	    return false;
	}
	
	iterator = function.values().iterator();
	
	while(iterator.hasNext())
	{
	    set = (HashSet)iterator.next();
	    
	    if(set.size() > 1)
	    {
		return false;
	    }
	}
	
	return true;
    }

    public void setDescription(String description)
    {
	this.description = description;
    }	

    public String getDescription()
    {
	return description;
    }

    
    /***** StateEvent support *****/

    public synchronized void addStateListener(StateListener l, State state)
    {
	addToHashedSet(specificListeners, state, l);
    }

    public synchronized void removeStateListener(StateListener l, State state)
    {
	removeFromHashedSet(specificListeners, state, l);
    }

    public synchronized void addStateListener(StateListener l)
    {
	stateListeners.add(l);
    }

    public synchronized void removeStateListener(StateListener l)
    {
	stateListeners.remove(l);
    }

    public synchronized void removeStateListeners(State state)
    {
	specificListeners.remove(state);
    }

    private void fireStateEvent(State s, int type)
    {
	ArrayList listeners;
	StateListener sl;
	StateEvent se;
	Iterator iterator;

	se = new StateEvent(this, type, s);
	listeners = new ArrayList();

	synchronized(this)
	{
	    if(specificListeners.containsKey(s))
	    {
		listeners.addAll((Collection)specificListeners.get(s));
	    }

	    listeners.addAll(stateListeners);
	}


	iterator = listeners.iterator();

	while(iterator.hasNext())
	{
	    sl = (StateListener)iterator.next();
	    switch(type)
	    {
		case StateEvent.ADDED:
		    sl.stateAdded(se);
		    break;

		case StateEvent.REMOVED:
		    sl.stateRemoved(se);
		    break;

		    //case StateEvent.DESCRIPTION:
		    //sl.statePropertyChanged(se);
		    //break;

		case StateEvent.START:
		    sl.startStateChange(se);
		    break;

		case StateEvent.FINAL:
		    sl.finalStateChange(se);
		    break;

		    //case StateEvent.POSITION:
		    //sl.statePropertyChanged(se);
		    //break;
	    }
	}
    }


    /***** TransitionEvent support *****/

    public synchronized void addTransitionListener(TransitionListener l,
						   State start, State end)
    {
	String key = Transition.generateKey(start, end);
	addToHashedSet(specificListeners, key, l);
    }

    public synchronized void addTransitionListener(TransitionListener l,
						   Transition t)
    {
	addToHashedSet(specificListeners, t.getKey(), l);
    }

    public synchronized void removeTransitionListener(TransitionListener l,
						      State start, State end)
    {
	String key = Transition.generateKey(start, end);
	removeFromHashedSet(specificListeners, key, l);
    }

    public synchronized void removeTransitionListener(TransitionListener l,
						      Transition t)
    {
	removeFromHashedSet(specificListeners, t.getKey(), l);
    }

    public synchronized void addTransitionListener(TransitionListener l)
    {
	transitionListeners.add(l);
    }

    public synchronized void removeTransitionListener(TransitionListener l)
    {
	transitionListeners.remove(l);
    }

    private void fireTransitionEvent(int type, Transition t)
    {
	ArrayList listeners;
	Iterator iterator;
	TransitionListener tl;
	TransitionEvent te;

	te = new TransitionEvent(this, type, t);

	listeners = new ArrayList();

	synchronized(this)
	{
	    if(specificListeners.containsKey(t.getKey()))
	    {
		listeners.addAll((Collection)specificListeners.get(t.getKey()));
	    }

	    listeners.addAll(transitionListeners);
	}

	iterator = listeners.iterator();

	while(iterator.hasNext())
	{
	    tl = (TransitionListener)iterator.next();

	    switch(type)
	    {
		case TransitionEvent.ADDED:
		    tl.transitionAdded(te);
		    break;

		case TransitionEvent.REMOVED:
		    tl.transitionRemoved(te);
		    break;

		case TransitionEvent.SYMBOLCHANGE:
		    tl.transitionSymbolsChanged(te);
		    break;
	    }
	}
    }

    private void fireTransitionMoved(Transition t, State original)
    {
	ArrayList listeners;
	Iterator iterator;
	TransitionListener tl;
	TransitionMovedEvent tme;
	String key;

	tme = new TransitionMovedEvent(this, t, original);
	key = t.generateKey(t.getSource(), original);
	listeners = new ArrayList();

	synchronized(this)
	{
	    if(specificListeners.containsKey(t.getKey()))
	    {
		listeners.addAll((Collection)specificListeners.get(t.getKey()));
	    }

	    if(specificListeners.containsKey(key))
	    {
		listeners.addAll((Collection)specificListeners.get(key));
	    }

	    listeners.addAll(transitionListeners);
	}

	iterator = listeners.iterator();

	while(iterator.hasNext())
	{
	    tl = (TransitionListener)iterator.next();
	    tl.transitionMoved(tme);
	}
    }


    private void fireStatePropertyEvent(State state, String propertyName)
    {
	ArrayList listeners;
	StateListener sl;
	StatePropertyEvent spe;
	Iterator iterator;

	spe = new StatePropertyEvent(this, state, propertyName);
	listeners = new ArrayList();

	synchronized(this)
	{
	    if(specificListeners.containsKey(state))
	    {
		listeners.addAll((Collection)specificListeners.get(state));
	    }

	    listeners.addAll(stateListeners);
	}


	iterator = listeners.iterator();

	while(iterator.hasNext())
	{
	    sl = (StateListener)iterator.next();
	    sl.statePropertyChanged(spe);
	}
    }

    public void reset()
    {
	Character symbol;
	HashMap cloneMap;
	HashSet cloneSet;
	Iterator iterator;
	Transition transition;
	State state;

	cloneMap = (HashMap)transitions.clone();
	iterator = cloneMap.values().iterator();

	while(iterator.hasNext())
	{
	    transition = (Transition)iterator.next();
	    removeTransition(transition);
	}

	cloneSet = (HashSet)states.clone();
	iterator = cloneSet.iterator();

	while(iterator.hasNext())
	{
	    state = (State)iterator.next();
	    removeState(state);
	}

	iterator = alphabet.getSymbols();

	while(iterator.hasNext())
	{
	    symbol = (Character)iterator.next();
	    if(!symbol.equals(EMPTY_SYMBOL))
	    {
		try
		{
		    alphabet.removeSymbol(symbol);
		}
		catch(SymbolChangeException sce)
		{
		    sce.printStackTrace();
		}
	    }
	}

	stateNum = 0;
    }
}
