package FSAComponents;


import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

public class SymbolAdapter
  implements SymbolListener, java.io.Serializable
{
  Object _obj;
  transient Method[] _methods;
  Object[] _args = new Object[1];
  String _aboutToAddMethod, _addMethod, _aboutToRemoveMethod, _removeMethod;

  static Class[] _params = new Class[] {SymbolEvent.class};
  static Class[] _vparams = new Class[] {VetoableSymbolEvent.class};

  static final int ABOUT_TO_ADD = 0;
  static final int ADDED = 1;
  static final int ABOUT_TO_REMOVE = 2;
  static final int REMOVED = 3;

  public SymbolAdapter(Object o, String aboutToAddMethod, String addMethod,
		       String aboutToRemoveMethod, String removeMethod)
  {
    _obj = o;
    _methods = new Method[4];

    _aboutToAddMethod = aboutToAddMethod;
    _addMethod = addMethod;
    _aboutToRemoveMethod = aboutToRemoveMethod;
    _removeMethod = removeMethod;

    setupMethods();
  }

  protected void setupMethods()
  {
    Class cl = _obj.getClass();
    _methods = new Method[4];

    if(_aboutToAddMethod != null)
    {
      try
      {
	_methods[ABOUT_TO_ADD] = cl.getMethod(_aboutToAddMethod, _vparams);
      }
      catch(Exception e)
      {
	e.printStackTrace();
	System.exit(1);
      }
    }
    else
    {
      _methods[ABOUT_TO_ADD] = null;
    }

    if(_addMethod != null)
    {
      try
      {
	_methods[ADDED] = cl.getMethod(_addMethod, _params);
      }
      catch(Exception e)
      {
	e.printStackTrace();
	System.exit(1);
      }
    }
    else
    {
      _methods[ADDED] = null;
    }

    if(_aboutToRemoveMethod != null)
    {
      try
      {
	_methods[ABOUT_TO_REMOVE] = cl.getMethod(_aboutToRemoveMethod, _vparams);
      }
      catch(Exception e)
      {
	e.printStackTrace();
	System.exit(1);
      }
    }
    else
    {
      _methods[ABOUT_TO_REMOVE] = null;
    }

    if(_removeMethod != null)
    {
      try
      {
	_methods[REMOVED] = cl.getMethod(_removeMethod, _params);
      }
      catch(Exception e)
      {
	e.printStackTrace();
	System.exit(1);
      }
    }
    else
    {
      _methods[REMOVED] = null;
    }
  }

  public void aboutToAddSymbols(VetoableSymbolEvent e)
  {
    processEvent(ABOUT_TO_ADD, e);
  }

  public void symbolsAdded(SymbolEvent e)
  {
    processEvent(ADDED, e);
  }

  public void aboutToRemoveSymbols(VetoableSymbolEvent e)
  {
    processEvent(ABOUT_TO_REMOVE, e);
  }

  public void symbolsRemoved(SymbolEvent e)
  {
    processEvent(REMOVED, e);
  }

  private void processEvent(int methodType, Object event)
  {
    if(_methods[methodType] == null)
      return;

    _args[0] = event;

    try
    {
      _methods[methodType].invoke(_obj, _args);
    }
    catch(InvocationTargetException e)
    {
      e.getTargetException().printStackTrace();
      System.exit(1);
    }
    catch(Exception e)
    {
      e.printStackTrace();
      System.exit(1);
    }
  }

  private void readObject(java.io.ObjectInputStream in)
    throws java.io.IOException, ClassNotFoundException
  {
    in.defaultReadObject();

    setupMethods();
  }
}
