package FSAComponents;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;


public class SymbolSet
    implements SymbolUser, java.io.Serializable
{
    TreeSet _delegate;
    transient HashSet _listeners;
    Object _owner;
  
    public SymbolSet(Object owner)
    {
	_owner = owner;
	_delegate = new TreeSet();
	_listeners = new HashSet();
    }

    public SymbolSet(Object owner, char[] chars)
    {
	this(owner);

	for(int i = 0; i < chars.length; i++)
	{
	    _delegate.add(new Character(chars[i]));
	}
    }
  
    public SymbolSet(Object owner, Iterator iterator)
    {
	this(owner);

	while(iterator.hasNext())
	{
	    _delegate.add((Character)iterator.next());
	}
    }
  
    public boolean contains(Character c)
    {
	return _delegate.contains(c);
    }

    public boolean contains(char c)
    {
	return _delegate.contains(new Character(c));
    }

    public void addSymbol(Character symbol)
	throws SymbolChangeException
    {
	Character[] symbols = new Character[1];

	symbols[0] = symbol;

	fireVetoableSymbolEvent(VetoableSymbolEvent.ADD, symbols);
	_delegate.add(symbol);
	fireSymbolEvent(SymbolEvent.ADD, symbols);
    }

    public void addSymbol(char symbol)
	throws SymbolChangeException
    {
	addSymbol(new Character(symbol));
    }

    public void addSymbols(Character[] symbols)
	throws SymbolChangeException
    {
	int i;

	fireVetoableSymbolEvent(VetoableSymbolEvent.ADD, symbols);

	for(i = 0; i < symbols.length; i++)
	{
	    _delegate.add(symbols[i]);
	}

	fireSymbolEvent(SymbolEvent.ADD, symbols);
    }

    public void addSymbols(SymbolSet symbols)
	throws SymbolChangeException
    {
	addSymbols(symbols.getSymbolArray());
    }

    public void removeSymbol(char symbol)
	throws SymbolChangeException
    {
	removeSymbol(new Character(symbol));
    }

    public void removeSymbol(Character symbol)
	throws SymbolChangeException
    {
	Character[] symbols = new Character[1];
	symbols[0] = symbol;

	fireVetoableSymbolEvent(VetoableSymbolEvent.REMOVE, symbols);
	_delegate.remove(symbol);
	fireSymbolEvent(SymbolEvent.REMOVE, symbols);
    }

    public void removeSymbols(Character[] symbols)
	throws SymbolChangeException
    {
	int i;

	fireVetoableSymbolEvent(VetoableSymbolEvent.REMOVE, symbols);

	for(i = 0; i < symbols.length; i++)
	{
	    _delegate.remove(symbols[i]);
	}

	fireSymbolEvent(SymbolEvent.REMOVE, symbols);
    }

    public void clear()
	throws SymbolChangeException
    {
	int i = 0;
	Character[] symbols = new Character[_delegate.size()];
	Iterator iterator = _delegate.iterator();

	while(iterator.hasNext())
	{
	    symbols[i] = (Character)iterator.next();
	    i++;
	}

	fireVetoableSymbolEvent(VetoableSymbolEvent.REMOVE, symbols);
	_delegate.clear();
	fireSymbolEvent(SymbolEvent.REMOVE, symbols);
    }

    public boolean isEmpty()
    {
	return _delegate.isEmpty();
    }

    public String getSymbolString()
    {
	Iterator i = _delegate.iterator();
	StringBuffer sb = new StringBuffer();

	while(i.hasNext())
	{
	    sb.append((Character)i.next());
	}

	return sb.toString();
    }

    public String getFormattedSymbolString()
    {
	boolean startNewRange = false;
	boolean rangeStarted = false;
	boolean rangeEnded = false;
	char curChar;
	char rangeEnd = 0;
	char rangeStart = 0;
	Iterator i = _delegate.iterator();
	StringBuffer sb = new StringBuffer();

	while(i.hasNext())
	{
	    curChar = ((Character)i.next()).charValue();

	    if(rangeStarted)
	    {
		if(Character.isLetterOrDigit(curChar))
		{
		    if(rangeEnd + 1 == curChar)
		    {
			rangeEnd = curChar;
		    }
		    else
		    {
			rangeEnded = true;
			startNewRange = true;
		    }
		}
		else
		{
		    rangeEnded = true;
		}
	    }
	    else
	    {
		if(Character.isLetterOrDigit(curChar))
		{
		    startNewRange = true;
		}
	    }

	    if(rangeStarted && (rangeEnded || !i.hasNext()))
	    {
		int rangeSize = rangeEnd - rangeStart + 1;

		if(sb.length() > 0)
		{
		    sb.append(", ");
		}

		sb.append(rangeStart);

		if(rangeSize == 2)
		{
		    sb.append(", " + rangeEnd);
		}
		else if(rangeSize > 2)
		{
		    sb.append("-" + rangeEnd);
		}

		rangeStarted = false;
		rangeEnded = false;
	    }

	    if(startNewRange)
	    {
		if(i.hasNext())
		{
		    rangeStarted = true;
		    rangeEnded = false;
		    rangeStart = rangeEnd = curChar;
		    startNewRange = false;
		}
		else
		{
		    if(sb.length() > 0)
		    {
			sb.append(", ");
		    }
		    
		    sb.append(curChar);
		}
	    }

	    if(!Character.isLetterOrDigit(curChar))
	    {
		if(sb.length() > 0)
		{
		    sb.append(", ");
		}

		sb.append(curChar);
	    }
	}

	return sb.toString();
    }
	    

    public Character[] getSymbolArray()
    {
	Character[] symbolArray;
	Iterator iterator;
	int position;

	symbolArray = new Character[_delegate.size()];
	iterator = _delegate.iterator();
	position = 0;

	while(iterator.hasNext())
	{
	    symbolArray[position++] = (Character) iterator.next();
	}

	return symbolArray;
    }

    /***** SymbolUser methods *****/
    public Iterator getSymbols()
    {
	return Arrays.asList(_delegate.toArray()).iterator();
    }

    public synchronized void addSymbolListener(SymbolListener l)
    {
	_listeners.add(l);
    }

    public synchronized void removeSymbolListener(SymbolListener l)
    {
	_listeners.remove(l);
    }

    public Object getOwner()
    {
	return _owner;
    }

    protected void fireVetoableSymbolEvent(int type, Character[] symbols)
	throws SymbolChangeException
    {
	VetoableSymbolEvent e = null;
	Iterator iterator;
	SymbolListener sl;
	Object[] listenerArray;

	synchronized(this)
	{
	    listenerArray = _listeners.toArray();
	}

	e = new VetoableSymbolEvent(this, type, symbols);
	iterator = Arrays.asList(listenerArray).iterator();

	while(iterator.hasNext())
	{
	    sl = (SymbolListener)iterator.next();

	    switch(type)
	    {
		case VetoableSymbolEvent.ADD:
		    sl.aboutToAddSymbols(e);
		    break;

		case VetoableSymbolEvent.REMOVE:
		    sl.aboutToRemoveSymbols(e);
		    break;
	    }
	
	    if(e.isVetoed())
	    {
		throw new SymbolChangeException(e.getMessage());
	    }
	}	       
    }

    protected void fireSymbolEvent(int type, Character[] symbols)
    {
	Iterator iterator;
	Object[] listenerArray;
	SymbolListener sl;
	SymbolEvent e = null;

	synchronized(this)
	{
	    listenerArray = _listeners.toArray();
	}

	e = new SymbolEvent(this, type, symbols);
	iterator = Arrays.asList(listenerArray).iterator();

	while(iterator.hasNext())
	{
	    sl = (SymbolListener)iterator.next();

	    switch(type)
	    {
		case SymbolEvent.ADD:
		    sl.symbolsAdded(e);
		    break;

		case SymbolEvent.REMOVE:
		    sl.symbolsRemoved(e);
		    break;
	    }

	    //sl.symbolsAdded(e);
	}
    }

    private void readObject(java.io.ObjectInputStream in)
	throws java.io.IOException, ClassNotFoundException
    {
	in.defaultReadObject();
	_listeners = new HashSet();
    }
}
