package FSAComponents;

public class Transition
{
  State _source;
  State _destination;
  SymbolSet _symbols;
  String _key;
  StateMachine _owner;
  Object _userObject;

  public Transition(State source, State destination)
  {
    _source = source;
    _destination = destination;
    _owner = null;

    _symbols = new SymbolSet(this);
    _key = generateKey(_source, _destination);
  }

  public static String generateKey(State source, State destination)
  {
    return source.toString() + "-" + destination.toString();
  }

  public String getKey()
  {
    return _key;
  }

  protected String functionKey(Character symbol)
  {
    return generateFunctionKey(_source, symbol);
  }

  protected String endpointKey()
  {
    return _key;
  }

  public SymbolSet getSymbolSet()
  {
    return _symbols;
  }

  public State getSource()
  {
    return _source;
  }

  public State getDestination()
  {
    return _destination;
  }

  protected void setDestination(State newDestination)
  {
    _destination = newDestination;
    _key = generateKey(_source, _destination);
  }

  public StateMachine getOwner()
  {
    return _owner;
  }

  protected void setOwner(StateMachine owner)
  {
    _owner = owner;
  }

  protected static String generateFunctionKey(State s, Character c)
  {
    return s.toString() + "," + c.toString();
  }

  public int hashCode()
  {
    return _key.hashCode();
  }

  public String toString()
  {
    return _key;
  }

  public boolean equals(Object obj)
  {
    if(obj instanceof Transition)
    {
      Transition t = (Transition) obj;
      return _source.equals(t._source) &&
             _destination.equals(t._destination) &&
             _symbols.equals(t._symbols) &&
             _key.equals(t._key);
    }

    return false;
  }

  public void setUserObject(Object userObject)
  {
      _userObject = userObject;
  }

  public Object getUserObject()
  {
      return _userObject;
  }
}
